DPUT(5)
=======
:doctype: manpage


NAME
----
dput - configuration file format for dput-ng


DESCRIPTION
-----------

*dput* supports two configuration file formats. The old-style configuration
format was originally introduced by dput and is described in *dput.cf(5)*.
This manpage describes new-style configuration files only. All details are
covered in in </usr/share/doc/dput-ng/html/reference/configs.html> which is
available in the dput-ng-doc package.

FILES AND FORMAT
----------------

Upload targets are configured using JSON as described in *RFC 4627*. In a
nutshell, *dput* configuration allows insignificant whitespace before or after
any type statement. Each upload profile is stored in its own file and is
represented as  a pair of curly brackets surrounding name/value pairs described
below. Both, name and values are strings. A single colon separates the name
from the value. A string begins and ends with quotation marks and may be
escaped. Booleans are either 'true' or 'false' (mind these are not surrounded
by quotation marks).

Some keys names are accepting lists as possible value. A list is represented
as square brackets surrounding zero or more values, separated by commas.

*dput* reads, in order, these directories:

 1. '/usr/share/dput-ng/'
 2. '/etc/dput.d/'
 3. '~/.dput.d/'
 4. The directory supplied via command line argument

Moreover, old-style configuration files are parsed and read. See *READING
TRADITIONAL CONFIGURATION FILES* below. In general, packages are installing
pre-defined defaults for popular upload targets to '/usr/share/dput-ng/profiles/'.
System administrators who wish to override or create a new system-wide and
shared target for many users may choose '/etc/dput.d/profiles'. Finally, local
targets may be written to '~/.dput.d/profiles' for personal upload targets.


Within each configuration directory, there may be another tier of
configuration directories. There, these actual configuration directories may
exist:

 * *metas/* define super-classes of upload profiles. They can define any name
   and value known to profiles (see below) which are shared across profiles.

 * *profiles/* define upload profiles. Files therein are looked-up by their
   name as 'HOST' argument by *dput*. This is, where upload hosts are defined.

Moreover, these directories can exist and are documented here for the sake of
completeness. However, users typically do not need to touch these unless you
are developing or customizing existing plug-ins to *dput* or *dcut*

 * *hooks/* define entry hooks to checker functions which are registered for
   use with *dput*. See *HOOKS* below.

 * *commands/* define entry hooks to command functions which are registered for
   use with *dcut*.

 * *interfaces/* define entry hooks to user interface functions which are
   registered for use with *dput* and *dcut*. They are responsible to retrieve
   data from the user.

By default *all* configuration file locations are parsed, and overlaid in a
additive manner. This way both, entire profiles and actual settings within a
profile is inherited from any parent location defining a key within the current
scope. Details are explained in the *INHERITANCE OF KEYS* section.



PROFILES
---------

Profiles are indexed as '<profile name>.json' within the 'profiles/'
configuration directory. Every profile may define these keys. Optionally a
profile called 'DEFAULT.json' can be defined as a superset of all existing
profiles. Any other profile will inherit values from this profile. For a finer
grained control see *meta* keyword and *META-CLASSES* below.

Following is an example configuration for a local upload profile, named
"'localhost.json'".

    {
        "+hooks": [
            "lintian"
        ],
        "-hooks": [
            "gpg"
        ],
        "incoming": "~/incoming",
        "meta": "debian",
        "method": "local",
        "run_lintian": true
    }


Supported keys are:

*allow_dcut* (boolean)::

This defines if you are allowed to upload a dcut changes file to the queue to
remove or move files. See *dcut(1)*.

*allow_unsigned_uploads* (boolean)::

This defines if you are allowed to upload files without a GnuPG signature to
this host or not.

*allowed_distributions* (string)::

A regular expression (of Python re module syntax) that the distribution field
must match or dput will refuse the upload.

*default_host_main* (string)::

This defines the default host for packages that are allowed to be uploaded to
the main archive. This variable is used when guessing the host to upload to.

*default_keyid* (string)::

This defines the default GPG key ID to be used to sign dcut commands. This
option can be overridden by -k parameter.

*full_upload_log* (boolean)::

This defines the verbosity of upload logs. When set to *true*, logs will
include more details. This setting might be overridden on the command line and
defaults to *false*.

*fqdn* (string)::

This is the fully qualified domain name that *dput* will connect to as a target
site.

*distributions* (string)::

This defines a comma-separated list of distributions that this host accepts,
used to guess the host to use when none is given on the command line.

*hash* (string)::

The hash algorithm that should be used in calculating the checksum of the
files before uploading them. Currently, dput accepts the following values
for hash:

	* 'sha1': Perform validation of the SHA-1 hash (default when omitted)
	* 'sha256': Perform validation of the SHA-256 hash
	* 'md5': Perform validation of the MD5 hash

*hooks* (list of string)::

Defines a list of checkers which are running before or after the upload. See
*HOOKS* below.


*interface* (string)::

Not supported yet. This is a known limitation.

*incoming* (string)::

The directory that *dput* should upload files to. Most upload sites do not
allow to write files in the log-in directory. Specify a path here, to which
*dput* should change the directory to, before starting to write files.

*method* (string)::

Use the specified method to upload your package. Currently these alternatives
are supported:

	* 'ftp':: Use FTP to upload files
	* 'http' or 'https':: Use HTTP or HTTPS to upload files
	* 'local':: Upload to a locally mounted location of the file system.
	  Internally this calls *install(1)*.
	* 'scp':: Use scp to upload files (requires python-paramiko).
	  *This method is deprecated*, use 'sftp' instead when possible.
	* 'sftp':: Use the sftp protocol (a secured file transfer via
	  SSH, requires python-paramiko).

	* *dput-ng* does not support 'rsync'.

*login* (string)::

Your login on the machine named before. A single asterisk ('*') will cause the
'scp', 'sftp' and uploaders to not supply a login name when calling trying to
authenticate.


*meta* (list of string)::

Specify a list of super classes from which the profile should inherit settings
explicitly. This is different to the 'DEFAULT.json' profile in such that this
defines settings conditionally, and not for all profiles.

*passive_ftp* (boolean)::

This  option  defines whether *dput* should use passive or active FTP for
uploading a package to one of the upload queues. This name is only meaningful
when 'method' is set to 'ftp'.

*post_upload_command* (string)::

This option defines a command to be run by dput after a successful upload. The
command is invoked via the shell and does not get passed any argument. See
*PROCESSORS* for more sophisticated approaches which are integrated in the
upload process.


*pre_upload_command* (string)::

This option defines a command to be run by dput before an upload. The
command is invoked via the shell and does not get passed any argument. See
*HOOKS* for more sophisticated approaches which are integrated in the
upload process and can gracefully interrupt the upload process.


*run_lintian* (boolean)::

This option defines if lintian should be run before the package will be
uploaded or not.  *This setting is deprecated* but works as a fallback to the
corresponding *HOOK*. The Lintian hook allows much more fine grained
control over the Lintian invocation.

READING TRADITIONAL CONFIGURATION FILES
---------------------------------------

As outlined initially, *dput* reads and parses traditional INI style
configuration files. It's format is documented in *dput.cf(5)*. These files
are deprecated, but for the time being read and parsed. We encourage the
removal of these global and local configuration files entirely.

Having that said, when in place old-style configuration files will overrule
new style files, to preserve a possibly modified legacy behavior. That means,
in order configuration values are inherited and keys are successively
overwritten in this order:

 1. '/etc/dput.d/profiles'
 2. '/etc/dput.cf'
 3. '~/.dput.d/profiles'
 4. '~/.dput.cf'

This means, old-style configuration files always take relative precedence when
installed. Use them with caution.

INHERITANCE OF KEYS
-------------------

By default, keys will override any previously defined value. However, as a
special case, there are three operators (*=*, *+* and *-*) that may be prefixed
to names to merge with existing inherited values. This is beneficial when a
profile wishes to add or remove values from an existing key which accepts lists
of values. This is mostly useful to *hooks* which may want to extend an
existing profile key that is inheriting values via it's meta-class or parent.

* The *=* operator is the default operator when no operator was explicitly
  provided. It overwrites any previous key.
* The *+* operator is additive. When set, it merges the supplied value(s) with
  any previous value
* The *-* operator is subtractive. When set, it removes the supplied value(s)
  from any previous value.

The DEFAULT Profile
~~~~~~~~~~~~~~~~~~~

There is a special profile called 'DEFAULT' ("'DEFAULT.json'" in any
configuration location). This profile is the root profile. All profiles are
automatically inheriting values from this profile. Values set there are global
defaults. The profile itself is subject to the same inheritance rules as any
other profile itself as well.

All keys and values can be set in the 'DEFAULT' profile.

META PROFILES
~~~~~~~~~~~~~

Configuration files may declare an optional *meta* key, who's value is the
name of a meta-configuration to be placed under this configuration. You can
check for meta-configuration in '/usr/share/dput-ng/metas', '/etc/dput.d/metas'
or '~/.dput.d/metas'. This helps declare common settings (such as general
Debian archive configuration values (GPG requirements, enforcing
that binary files exist, etc) without having to maintain may of the
same values in many places).

They are different to the 'DEFAULT' profile in such, that no profile
automatically inherits values from a meta profile, but only upon explicit
request.

Meta profiles can in turn inherit itself values from other meta profiles.

OVERRIDING SINGLE VALUES
~~~~~~~~~~~~~~~~~~~~~~~~

Here's an example stanza from a local dput config to remove an annoying
hook from being run:

'~/.dput.d/profiles/DEFAULT.json':

    {
        "hooks": [
            "gpg",
            "lintian"
        ]
    }


At this point, every profile will invoke the hooks 'gpg', 'lintian'

'~/.dput.d/metas/my-defaults.json':

    {
        "hooks": [
            "checksum",
        ]
    }

This defines a meta profile named 'my-defaults', which will also invoke the
'checksum' hook. At this point this meta profile, inherits values from
'DEFAULT' and therefore invokes the hooks 'gpg', 'lintian' and 'checksum'.

'~/.dput.d/profiles/ftp-master.json':

    {
        "-hooks": [
            "lintian"
        ]
        "meta": [
        	"my-defaults"
        ]
    }

At this point, the profile 'ftp-master' will inherit values from 'DEFAULT' and
'my-defaults'. However, the '-' operator prefix removes 'lintian' from the
checker list.  Hence, 'ftp-master' will run the checkers 'gpg' and 'checksum'.

HOOKS
------

Hooks are pre- or post-uupload checks, They are pluggable components running
before or after the upload of a package. Whether they run before or after the
upload is determined by the JSON definition of a hook. That is an
implementation detail the user typically does not need to worry about.

Pre-Upload Hooks
~~~~~~~~~~~~~~~~

Pre-upload hooks are pluggable components which are designed to run before the
upload actually happens. This typically involves consistency checks, sanity
checks and similar tasks. The list of available pre-upload hooks can be
obtained using *dirt(1)*. The hooks invoked by default are determined on a
per-profile basis by retrieving the setting of the *hooks* key. Hooks also run
in simulation and check-only mode.

It is easy to write your own hook extensions. Consult the manual for
instructions.

Post-Upload Hooks
~~~~~~~~~~~~~~~~~

Processors are pluggable components which are designed to run after the upload
actually happens. They cannot interrupt the upload, because they are invoked
after a successful upload only. They do _not_ run when *dput* was invoked with
check-only or simulation mode. Such post-upload hooks may invoke post-
processing tasks such as closing or filing bugs. The list of available
processors can be obtained using *dirt(1)*. The hooks invoked by default
are determined on a per-profile basis by retrieving the setting of the
*hooks* key and follow the same rules as pre-upload hooks.

It is easy to write your own hook extensions. Consult the manual for
instructions.

FILES
-----

     /usr/share/dput-ng/
     /etc/dput.d/
     ~/.dput.d/

AUTHOR
------
dput-ng was originally written by `Arno Töll <arno(a)debian.org>` and `Paul
Richard I by the Grace of God of the United Kingdom of Debian and Ubuntu and
of his other realms and territories King Head of the Fluxbox Window Manager
Defender of the Faith Tagliamonte <paultag(a)debian.org>`.


RESOURCES
---------

*RFC 4627*, */usr/share/doc/dput-ng/html/reference/*, *dput(1)*, *dcut(1)*,
*dcut(1)*
