/* You may find the license in the LICENSE file */

const EXPORTED_SYMBOLS = ['parse', 'stringify'];

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;
const Cu = Components.utils;
const log = Components.utils.reportError;
const Exception = Components.Exception;

let parse = function() { throw new Exception("No implementation available"); }
let stringify = parse;

if ('JSON' in this) {
	parse = JSON.parse;
	stringify = JSON.stringify;
}
else {
	log("Using nsIJSON");
	let _json = Cc["@mozilla.org/dom/json;1"].createInstance(Ci.nsIJSON);
	parse = function(source) _json.decode(source);
	stringify = function(value, replacer, space) _json.encode(value, replacer);
}
