from re import compile

from dosage.helpers import BasicScraper, bounceStarter

class xkcd(BasicScraper):
    starter = bounceStarter('http://xkcd.com/', compile(r'<a href="(/?\d+/?)"[^>]*>Next'))
    imageUrl = 'http://xkcd.com/c%s.html'
    imageSearch = compile(r'<img[^<]+src="(http://imgs.xkcd.com/comics/[^<>"]+)"')
    prevSearch = compile(r'<a href="(/?\d+/?)"[^>]*>&lt; Prev')
    help = 'Index format: n (unpadded)'

    def namer(cls, imageUrl, pageUrl):
        index = int(pageUrl.rstrip('/').split('/')[-1])
        name = imageUrl.split('/')[-1].split('.')[0]
        return 'c%03d-%s' % (index, name)
