import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class SnafuComics(BasicComicModule):
    imageUrl = 'index.php?strip_id=%s'
    imageSearch = re.compile(r'"(comics/.*?)"')
    prevSearch = re.compile(r'<a href="(\?strip_id=.*?)".+?[^>].+PREVIOUS')
    help = 'Index format: n (unpadded)'

    submodules = {
        'Grim': 'http://grim.snafu-comics.com/',
        'KOF': 'http://kof.snafu-comics.com/',
        'PowerPuffGirls': 'http://ppg.snafu-comics.com/',
        'Snafu': 'http://www.snafu-comics.com/',
        'Tin': 'http://tin.snafu-comics.com/',
        'TW': 'http://tw.snafu-comics.com/',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = baseUrl
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'SnafuComics' + '/' + submodule
