import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin

class SmackJeeves(BasicComicModule, BounceMixin):
    imageSearch = re.compile(r'<img src="(http://www\.smackjeeves\.com/images/uploaded/comics/[^"]*)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(/comics/\d+/[^"]*)(:?\?PHPSESSID=[a-f0-9]*)"><img[^>]*alt="< Previous"', re.IGNORECASE)
    nextSearch = re.compile(r'<a href="(/comics/\d+/[^"]*)(:?\?PHPSESSID=[a-f0-9]*)"><img[^>]*alt="Next >"', re.IGNORECASE)
    help = 'Index format: nnnn (some increasing number)'

    submodules = {
        '20galaxies': 1,
        'axe13': 1,
        'beartholomew': 1,
        'bliss': 1,
        'cyberia': 1,
        'durian': 1,
        'mpmcomic': 1,
        'nlmo-project': 1,
        'paranoidloyd': 1,
        'thatdreamagain': 1,
        'wowcomics': 1,
        'xiongwulegend': 1,
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = 'http://%s.smackjeeves.com/comics/' % (submodule)
        self.imageUrl = self.baseUrl + '%s/'
        self.name = 'SmackJeeves/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        return pageUrl.split('/')[-2]

