import re
from dosage.util import fetchUrl, getQueryParams
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin

class KiagiSwordscat(BasicComicModule, BounceMixin):
    baseUrl = 'http://kiagi.com/'
    imageUrl = 'http://kiagi.com/archive.php?go=%s'
    imageSearch = re.compile(r'"(autonav.php\?img=.+?)".+?alt="Comic"', re.IGNORECASE)
    prevSearch = re.compile(r'<A HREF="(archive\.php\?go=\d{8})">&lt;</A>', re.IGNORECASE)
    nextSearch = re.compile(r'<A HREF="(archive\.php\?go=\d{8})">&gt;</A>', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(pageUrl)['go'][0]
