import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin
from dosage.util import getQueryParams

class CloneManga(BasicComicModule, BounceMixin):
    imageSearch = re.compile(r'<img src="(http://manga\.clone-army\.org/[^"]+)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]+)"><img src="previous\.gif"', re.IGNORECASE)
    nextSearch = re.compile(r'<a href="([^"]+)"><img src="next\.gif"', re.IGNORECASE)
    help = 'Index format: n'

    submodules = {
        'AprilAndMay': 'http://manga.clone-army.org/anm.php',
        'Kanami': 'http://manga.clone-army.org/kanami.php',
        'NanasEverydayLife': 'http://manga.clone-army.org/nana.php?page=78',
        'PaperEleven': 'http://manga.clone-army.org/pxi.php?page=311',
        'Tomoyo42sRoom': 'http://manga.clone-army.org/t42r.php',
        'PennyTribute': 'http://manga.clone-army.org/penny.php',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.submodules[submodule]
        self.imageUrl = self.baseUrl + '?page=%s'
        self.name = 'CloneManga' + '/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        return '%03d' % (int(getQueryParams(pageUrl)['page'][0]),)
