/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _WIDGETSELECTOR_H_
#define _WIDGETSELECTOR_H_

#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>

#include "sidebar.h"

class QPainter;

class WidgetSelector : public QToolButton
{
    Q_OBJECT
public:
    WidgetSelector(Sidebar* parent);
    virtual ~WidgetSelector();


public slots:
	void newWidgetRegistered(const QString& widgetName);
	void slotSetCurrentWidget(const QString& widgetName, uint wtype);
	void slotWidgetActivated(int indx);

signals:
	void widgetChangeRequest(const QString& widgetName);

protected:
    /**
     * Draws selector and a name of current selected sidebar widget
     */
    //virtual void drawButton(QPainter* painter);
	virtual void drawButtonLabel(QPainter* painter);

    virtual void enterEvent(QEvent* event);
    virtual void leaveEvent(QEvent* event);
	
	// TODO: should be moved outside for sharing with URLButton
    QColor mixColors(const QColor& c1, const QColor& c2) const;

private:
	bool m_mouseOver;
	//QValueList<QString> m_widgetTitles;
    QPopupMenu* m_widgetsMenu;

};
#endif // WIDGETSElECTOR_H_
