#include <gnome.h>
#include "appglobals.h"
#include "appfunctions.h"
#include "appsupport.h"
#include "profile.h"
#include "usergrouplists.h"
#include "icon_entry.h"

void
fill_iconlist (connection_profile * usethisone)
{
  //needs a connection profile already connected.  thanks.  REMEMBER DAT!!!

  LDAP *conn = NULL;
  gchar *root = NULL;
  gchar *filter = NULL;
  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  gchar *attributetoreturn[4];
  char **value_collection;
  char **oc_collection;
  int oc_iterator;
  int ldap_errors;
  gchar *dn;

  GnomeIconList *itemlist;
  icon_entry *i_entry;
  itemlist = (GnomeIconList *) lookup_widget (app, "itemlist");

  g_print ("\ncalled: fill_iconlist\n");
  gnome_icon_list_clear (itemlist);

  //check 4 connection
  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("\ndisconnected: list emptied\n");
      return;
    }

  conn = connection_profile_get_ldap_handler (usethisone);
  root = connection_profile_get_treeroot (usethisone);

  attributetoreturn[0] = "uid";
  attributetoreturn[1] = "cn";
  attributetoreturn[2] = "objectClass";
  attributetoreturn[3] = NULL;

  gnome_icon_list_freeze (itemlist);

  filter = "(|(objectclass=posixAccount)(objectclass=posixGroup))";

  //look data up
  ldap_errors =
    ldap_search_s (conn, root, LDAP_SCOPE_SUBTREE, filter,
		   attributetoreturn, 0, &results);
  if (ldap_errors)
    {
      g_print ("LDAP error while filling icon list: %s\n",
	       ldap_err2string (ldap_errors));
      return;
    }
  g_assert (results);

  ldap_errors =
    ldap_sort_entries (conn, &results, "dn", (void *) ldap_sort_strcasecmp);
  if (ldap_errors)
    {
      g_print ("LDAP error while sorting entries: %s\n",
	       ldap_err2string (ldap_errors));
      return;
    }

  entry = ldap_first_entry (conn, results);
  oc_iterator = 0;
  while (entry)
    {
      //quiero ver que chucha hay en la lista de objectClass
      g_print ("\ninvestigando este entry: %s", ldap_get_dn (conn, entry));
      oc_collection = ldap_get_values (conn, entry, "objectClass");
      g_assert (oc_collection);
      while (oc_collection[oc_iterator])
	{
	  g_print ("\n  investigando este objectclass: %s",
		   oc_collection[oc_iterator]);
	  //si es un posix account, aadir como usuario
	  if (g_strcasecmp (oc_collection[oc_iterator], "posixAccount") == 0)
	    {
	      g_print ("\n   Es un POSIXACCOUNT");
	      value_collection = ldap_get_values (conn, entry, "uid");
	      g_assert (value_collection);
	      dn = ldap_get_dn (conn, entry);
	      i_entry =
		icon_entry_new_with_parms (value_collection[0], dn,
					   DIRADMIN_USER);
	      objectview_icon_add (itemlist, i_entry);
	      icon_entry_destroy (i_entry);
	      g_free (dn);
	      ldap_value_free (value_collection);
	    }
	  //si es un posix group, aadir como grupo
	  if (g_strcasecmp (oc_collection[oc_iterator], "posixGroup") == 0)
	    {
	      g_print ("\n   Es un POSIXGROUP");
	      value_collection = ldap_get_values (conn, entry, "cn");
	      g_assert (value_collection);
	      dn = ldap_get_dn (conn, entry);
	      i_entry =
		icon_entry_new_with_parms (value_collection[0], dn,
					   DIRADMIN_GROUP);
	      objectview_icon_add (itemlist, i_entry);
	      icon_entry_destroy (i_entry);
	      g_free (dn);
	      ldap_value_free (value_collection);
	    }
	  oc_iterator++;
	}
      oc_iterator = 0;
      ldap_value_free (oc_collection);
      entry = ldap_next_entry (conn, entry);
    }
  ldap_msgfree (results);
  gnome_icon_list_thaw (itemlist);

}



/* there are two views

objectview_icon
objectview_list_detailed

objectview_icon_add (GnomeIconList* , icon_entry *) adds an entry to the icon view
                                                    (dupes the icon_entry for itself and frees it
                                                     on item removal)
objectview_list_detailed_add (GtkCList* , icon_entry *) adds an entry to the detail list view
                                                    (dupes the icon_entry for itself and frees it
                                                     on item removal)

objectview_icon_remove_bydn(GnomeIconList*,gchar*) finds the entry with the corr. DN and removes it
objectview_list_detailed_remove_bydn(GnomeIconList*,gchar*) does the same thing for the list view

those two functions are marshaled by the master functions

objectview_add (icon_entry *)
objectview_remove_bydn (gchar *)

*/

void
objectview_add (icon_entry * entry)
{
  objectview_icon_add ((GnomeIconList *) lookup_widget (app, "itemlist"),
		       entry);
}

void
objectview_icon_add (GnomeIconList * list, icon_entry * entry)
{
  int pos;
  gchar *pixmapfile = NULL;
  icon_entry *newentry = icon_entry_new (entry);
  if (newentry->type == DIRADMIN_USER)
    pixmapfile = gnome_pixmap_file ("directory-administrator/user-icon.xpm");
  if (newentry->type == DIRADMIN_GROUP)
    pixmapfile = gnome_pixmap_file ("directory-administrator/group-icon.xpm");
  pos = gnome_icon_list_append (list, pixmapfile, newentry->name);
  gnome_icon_list_set_icon_data_full (list, pos, newentry,
				      (GtkDestroyNotify) icon_entry_destroy);
  g_free (pixmapfile);
}

void
objectview_remove_bydn (gchar * dn)
{
  objectview_icon_remove_bydn ((GnomeIconList *)
			       lookup_widget (app, "itemlist"), dn);
}

void
objectview_icon_remove_bydn (GnomeIconList * list, gchar * dn)
{
  icon_entry *curr_entry;
  int pos;
  for (pos = 0; pos < list->icons; pos++)
    {
      curr_entry = gnome_icon_list_get_icon_data (list, pos);
      if (g_strcasecmp (dn, curr_entry->dn) == 0)
	{
	  gnome_icon_list_remove (list, pos);
	  pos = list->icons + 1;
	}
    }
}
