#include "appsupport.h"
#include "appglobals.h"
#include "profile.h"
#include "appfunctions.h"
#include "prefsdialog.h"

void
list_profiles_fill (GtkWidget * widget)
{

  GList *loopix = g_list_first (connection_profile_list);
  gchar *fila[1];

  g_assert (widget);
  gtk_clist_clear ((GtkCList *) widget);

  while (loopix)
    {
      fila[0] =
	connection_profile_get_name ((connection_profile *) loopix->data);
      gtk_clist_append ((GtkCList *) widget, fila);

      loopix = g_list_next (loopix);
    }

  app_reference = widget;
}


gboolean
on_button4_clicked_handler (GtkButton * button, GtkWidget * list_reference)
{
  connection_profile *newone;
  gchar *nombrecitocojudo;


  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a profile name"));
      return (FALSE);
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server address"));
      return (FALSE);
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (connection_profile_list_getbyname
      (connection_profile_list, nombrecitocojudo) != NULL)
    {
//    g_print("\nItem was found on the list.  Not admissible.");
      gtk_widget_show (create_messagebox_with_message
		       ("An entry with this name already exists"));
      return (FALSE);
    }


  newone =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));
  connection_profile_list =
    connection_profile_list_add (connection_profile_list, newone);
  if (list_reference)
    list_profiles_fill (list_reference);
  return (TRUE);

}

void
on_login_modify_finish (GtkButton * button, GtkCList * list_reference)
{
  connection_profile *newone = NULL;
  connection_profile *oldone = NULL;
  gchar *nombrecitocojudo = NULL;


  //gets the text from the list reference, first row selected, column 0, and puts it into nombrecitocojudo
  gtk_clist_get_text (list_reference,
		      GPOINTER_TO_INT (list_reference->selection->data), 0,
		      &nombrecitocojudo);

  oldone =
    connection_profile_list_getbyname (connection_profile_list,
				       nombrecitocojudo);
  g_assert (oldone);

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a profile name"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server address"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));

  newone =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));

  connection_profile_list =
    connection_profile_list_remove (connection_profile_list, oldone);
  connection_profile_list =
    connection_profile_list_add (connection_profile_list, newone);
  g_assert (list_reference);
  list_profiles_fill (GTK_WIDGET (list_reference));
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "login"));

}



void
fill_loginshells_list (GtkWidget * widget)
{


  GList *loopix = g_list_first (preferences.logindefaults.shells);
  gchar *fila[1];

  g_print ("\ncalled: fill_loginshells_list\n");

  g_assert (widget);
  gtk_clist_clear ((GtkCList *) widget);

  while (loopix)
    {
      fila[0] = loopix->data;
      gtk_clist_append ((GtkCList *) widget, fila);
      loopix = g_list_next (loopix);
    }

}


void
fill_login (GtkWidget * about, char *profilename)
{

  connection_profile *conprof = NULL;

  conprof =
    connection_profile_list_getbyname (connection_profile_list, profilename);
  if (conprof == NULL)
    {
      g_print
	("***ERROR! no such profile! could not get data about selected profile");
      return;
    }

  g_print
    ("\n\nNow a dialog box with the profile information should pop up\n");

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_profile_name")),
		      connection_profile_get_name (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_dn")),
		      connection_profile_get_dn (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_pw")),
		      connection_profile_get_password (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_server")),
		      connection_profile_get_server (conprof));

  gtk_entry_set_text (GTK_ENTRY
		      (lookup_widget (about, "entry_login_treeroot")),
		      connection_profile_get_treeroot (conprof));

}
