/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.util;

import de.xeinfach.kafenio.util.LeanLogger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TreeSpider {
    private static LeanLogger log = new LeanLogger("TreeSpider.class");
    private File rootFile;
    private Vector vcFiles;
    private Vector vcExtensions;
    private int maxDepth;
    private boolean bScreenExtensions;
    private boolean bFileNamesOnly;
    private boolean bDisplayMode;
    private FileTreeComparator localComparison;

    public TreeSpider(String string, Vector vector, boolean bl, int n) {
        this.rootFile = new File(string);
        this.vcFiles = new Vector();
        this.vcExtensions = vector;
        this.maxDepth = n;
        this.bScreenExtensions = false;
        this.bFileNamesOnly = false;
        this.bDisplayMode = false;
        if (this.vcExtensions.size() > 0) {
            this.bScreenExtensions = true;
        }
        this.localComparison = new FileTreeComparator(bl);
    }

    public TreeSpider(String string, Vector vector, boolean bl) {
        this(string, new Vector(), bl, 0);
    }

    public TreeSpider(String string, boolean bl, int n) {
        this(string, new Vector(), bl, n);
    }

    public TreeSpider(String string, boolean bl) {
        this(string, new Vector(), bl, 0);
    }

    public TreeSpider(String string, int n) {
        this(string, new Vector(), false, n);
    }

    public TreeSpider(String string) {
        this(string, new Vector(), false, 0);
    }

    public TreeSpider() {
        this(".", new Vector(), false, 0);
    }

    public File getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(File file) {
        this.rootFile = file;
    }

    public Vector getFiles() {
        return this.vcFiles;
    }

    public void setFiles(Vector vector) {
        this.vcFiles = vector;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public boolean doScreenExtensions() {
        return this.bScreenExtensions;
    }

    public void setScreenExtensions(boolean bl) {
        this.bScreenExtensions = bl;
    }

    public boolean showFileNamesOnly() {
        return this.bFileNamesOnly;
    }

    public void setFileNamesOnly(boolean bl) {
        this.bFileNamesOnly = bl;
    }

    public boolean getDisplayMode() {
        return this.bDisplayMode;
    }

    public void setDisplayMode(boolean bl) {
        this.bDisplayMode = bl;
    }

    public Vector getExtensions() {
        return this.vcExtensions;
    }

    public void setExtensions(Vector vector) {
        this.vcExtensions = vector;
        if (this.vcExtensions.size() > 0) {
            this.setScreenExtensions(true);
        } else {
            this.setScreenExtensions(false);
        }
    }

    public DefaultTreeModel fetchTree(File file) {
        return this.describeTree(file);
    }

    public DefaultTreeModel fetchTree() {
        return this.describeTree(this.rootFile);
    }

    public Vector fetchMassListing() {
        return this.fetchListing();
    }

    public Vector sortMassListing() {
        Vector vector = this.fetchListing();
        Collections.sort(vector, this.localComparison);
        return vector;
    }

    public Vector sortFileListing() {
        Vector vector = this.trimToName(this.fetchListing());
        Collections.sort(vector, this.localComparison);
        return vector;
    }

    public Hashtable collectListing() {
        Vector vector = this.fetchListing();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = string.substring(0, string.lastIndexOf(File.separator));
            String string3 = string.substring(string.lastIndexOf(File.separator) + 1, string.length());
            if (hashtable.containsKey(string2)) {
                ((Vector)hashtable.get(string2)).add(string3);
                continue;
            }
            hashtable.put(string2, new Vector());
            ((Vector)hashtable.get(string2)).add(string3);
        }
        return hashtable;
    }

    private DefaultTreeModel describeTree(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(file.getName());
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        if (!file.isDirectory()) {
            return defaultTreeModel;
        }
        String string = file.getAbsolutePath().trim() + File.separator;
        Vector vector = this.fetchListing();
        while (vector.size() > 0) {
            String string2 = (String)vector.elementAt(0);
            if (string2.startsWith(string)) {
                if ((string2 = string2.substring(string.length())).indexOf(File.separator) > -1) {
                    String string3 = string2.substring(0, string2.indexOf(File.separator));
                    this.describeTreeSubNodes(vector, defaultTreeModel, defaultMutableTreeNode, string, string3);
                    continue;
                }
                defaultTreeModel.insertNodeInto(new DefaultMutableTreeNode(string2), defaultMutableTreeNode, defaultTreeModel.getChildCount(defaultMutableTreeNode));
                vector.removeElementAt(0);
                continue;
            }
            vector.removeElementAt(0);
        }
        return defaultTreeModel;
    }

    private void describeTreeSubNodes(Vector vector, DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultTreeModel.getChildCount(defaultMutableTreeNode));
        boolean bl = true;
        String string3 = string + string2 + File.separator;
        while (bl && vector.size() > 0) {
            String string4 = (String)vector.elementAt(0);
            if (string4.startsWith(string3)) {
                if ((string4 = string4.substring(string3.length())).indexOf(File.separator) > -1) {
                    String string5 = string4.substring(0, string4.indexOf(File.separator));
                    this.describeTreeSubNodes(vector, defaultTreeModel, defaultMutableTreeNode2, string3, string5);
                    continue;
                }
                defaultTreeModel.insertNodeInto(new DefaultMutableTreeNode(string4), defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                vector.removeElementAt(0);
                continue;
            }
            bl = false;
        }
    }

    private Vector fetchListing() {
        Vector<Object> vector = new Vector<Object>();
        if (this.rootFile.isDirectory()) {
            vector.add(this.exploreFolder("", this.rootFile, new Vector(), 1));
        } else {
            String string = this.rootFile.getAbsolutePath().trim();
            if (!this.bScreenExtensions || this.bScreenExtensions && this.screensOkay(string)) {
                vector.add(string);
            }
        }
        return this.describeListing(vector);
    }

    private Vector trimToName(Vector vector) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.indexOf(File.separator) > -1) {
                vector2.add(string.substring(string.lastIndexOf(File.separator) + 1, string.length()));
                continue;
            }
            vector2.add(string);
        }
        return vector2;
    }

    private Vector exploreFolder(String string, File file, Vector vector, int n) {
        if (this.maxDepth != 0 && n > this.maxDepth) {
            return vector;
        }
        String string2 = string + File.separator + file.getName();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                vector.add(this.exploreFolder(string2, fileArray[i], new Vector(), n + 1));
                continue;
            }
            String string3 = fileArray[i].getAbsolutePath();
            if (this.bFileNamesOnly) {
                string3 = fileArray[i].getName();
            }
            if (this.bScreenExtensions && (!this.bScreenExtensions || !this.screensOkay(string3))) continue;
            vector.add(string3.trim());
        }
        Collections.sort(vector, this.localComparison);
        return vector;
    }

    private Vector exploreFolderOnly(String string, File file, Vector vector) {
        String string2 = string + File.separator + file.getName();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) continue;
            String string3 = fileArray[i].getAbsolutePath();
            if (this.bFileNamesOnly) {
                string3 = fileArray[i].getName();
            }
            if (this.bScreenExtensions && (!this.bScreenExtensions || !this.screensOkay(string3))) continue;
            vector.add(string3.trim());
        }
        Collections.sort(vector, this.localComparison);
        return vector;
    }

    private Vector describeListing(Vector vector) {
        Collections.sort(vector, this.localComparison);
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof Vector) {
                this.describeNode((Vector)vector.elementAt(i), vector2);
                continue;
            }
            vector2.add(vector.elementAt(i));
        }
        return vector2;
    }

    private void describeNode(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof Vector) {
                this.describeNode((Vector)vector.elementAt(i), vector2);
                continue;
            }
            vector2.add(vector.elementAt(i));
        }
    }

    private boolean screensOkay(String string) {
        for (int i = 0; i < this.vcExtensions.size(); ++i) {
            String string2 = ((String)this.vcExtensions.elementAt(i)).toLowerCase();
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static void unitTest(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(".java");
        vector.add(".class");
        vector.add(".txt");
        vector.add(".html");
        vector.add(".htm");
        vector.add(".gif");
        vector.add(".jpeg");
        vector.add(".jpg");
        TreeSpider treeSpider = new TreeSpider(string, vector, false, 0);
        log.debug("UNIT TEST SCAN");
        Hashtable hashtable = treeSpider.collectListing();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            log.debug(string2);
            Vector vector2 = (Vector)hashtable.get(string2);
            for (int i = 0; i < vector2.size(); ++i) {
                log.debug("  " + vector2.elementAt(i));
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            try {
                TreeSpider.unitTest(new File(".").getCanonicalPath());
            }
            catch (IOException iOException) {
                log.error("Unable to resolve current directory. Please specify a directory explicitly.");
                System.exit(1);
            }
        } else {
            TreeSpider.unitTest(stringArray[0]);
        }
    }

    class FileTreeComparator
    implements Comparator {
        private boolean isCaseSensitive;

        public FileTreeComparator(boolean bl) {
            this.isCaseSensitive = bl;
        }

        public FileTreeComparator() {
            this.isCaseSensitive = true;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Vector) {
                if (object2 instanceof Vector) {
                    if (((Vector)object).size() < 1) {
                        return -1;
                    }
                    if (((Vector)object2).size() < 1) {
                        return 1;
                    }
                    return this.compare(((Vector)object).elementAt(0), ((Vector)object2).elementAt(0));
                }
                return 1;
            }
            if (object2 instanceof Vector) {
                return -1;
            }
            String string = (String)object;
            String string2 = (String)object2;
            return this.isCaseSensitive ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
        }
    }
}

