#!/usr/bin/php4 -q
<?php
/* Script for updating the database structure.
*/

// Initialisation
require_once("Console/Getopt.php");
require_once("diogenes/diogenes.database-creator.inc.php");

class DiogenesDbInit extends DiogenesDatabaseCreator
{
  // database versions history
  var $versions = array("0.9.9.3", "0.9.10", "0.9.12", "0.9.15", "0.9.16");

  /**
   * Upgrades the database from one version to the next
   */
  function upgradeDb($newversion)
  {
    // upgrade barrels
    $res = $this->dbh->query("select alias from diogenes_site");
    while (list($alias) = mysql_fetch_row($res))
    {   
      $this->info("* Upgrading barrel '$alias'");    
      $this->upgradeBarrel($alias, $newversion);
    }
    mysql_free_result($res);

    // upgrade master tables
    $this->info("* Upgrading master tables : diogenes_*");
    $this->upgradeMaster($newversion);
  }

  
  /** upgrade a barrel's tables
   *
   */
  function upgradeBarrel($alias, $newversion)
  {
#    $this->info("Processing : {$alias}_menu, {$alias}_page and {$alias}_option");

    switch($newversion) {
    case "0.9.10":
      $this->info(" - upgrading : {$alias}_menu");
      // these field where NULL, change to NOT NULL
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `link` `link` TEXT NOT NULL");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `ordre` `ordre` SMALLINT( 6 ) UNSIGNED NOT NULL");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `MIDpere` `MIDpere` SMALLINT( 6 ) UNSIGNED NOT NULL");
    
      // break down old 'link' column into 'link' and 'PID'
      $this->dbh->query("ALTER TABLE `{$alias}_menu` ADD `PID` SMALLINT( 6 ) UNSIGNED NOT NULL");
      $res2 = $this->dbh->query("select MID,link from {$alias}_menu");
      while (list($MID,$link) = mysql_fetch_row($res2)) {
        switch (substr($link,0,3)) {
        case "PI:":
          $pid = substr($link,3);
          $this->dbh->query("UPDATE `{$alias}_menu` SET link='',PID='$pid' WHERE MID='$MID'");
          break;
        case "SE:":
          $adr = substr($link,3);
          $this->dbh->query("UPDATE `{$alias}_menu` SET link='$adr' WHERE MID='$MID'");
          break;
        }
      }
      mysql_free_result($res2);
    
      $this->info(" - creating : {$alias}_option");
      $this->dbh->query("CREATE TABLE `{$alias}_option` (name VARCHAR( 32 ) NOT NULL, value TEXT NOT NULL, PRIMARY KEY (`name`)) TYPE=MyISAM;");    
    
      $this->info(" - registering title, description and keywords");
      $res2 = $this->dbh->query("select title,description,keywords from diogenes_site where alias='$alias'");
      list($title,$description,$keywords) = mysql_fetch_row($res2);
      $this->dbh->query("replace into `{$alias}_option` set name='title',value='$title'");
      $this->dbh->query("replace into `{$alias}_option` set name='description',value='$description'");
      $this->dbh->query("replace into `{$alias}_option` set name='keywords',value='$keywords'");
      break;
      
    case "0.9.12":
      $this->info(" - adding 'template' field");
      $this->dbh->query("ALTER TABLE `{$alias}_page` ADD `template` VARCHAR(255) NOT NULL");
      $this->info(" - dropping 'hits' field");
      $this->dbh->query("ALTER TABLE `{$alias}_page` DROP `hits`");
      $this->info(" - replacing 'visible' field by 'status'");
      $this->dbh->query("ALTER TABLE `{$alias}_page` DROP `visible`");
      $this->dbh->query("ALTER TABLE `{$alias}_page` ADD `status` tinyint(1) unsigned NOT NULL");
      $this->info(" - modifying 'perms' and 'wperms' to add 'forbidden' access");
      $this->dbh->query("ALTER TABLE `{$alias}_page` CHANGE `perms` `perms` ENUM( 'public', 'auth', 'user', 'admin', 'forbidden' ) DEFAULT 'public' NOT NULL");
      $this->dbh->query("ALTER TABLE `{$alias}_page` CHANGE `wperms` `wperms` ENUM( 'public', 'auth', 'user', 'admin', 'forbidden' ) DEFAULT 'admin' NOT NULL");
      break;
    
    case "0.9.16":
      $this->info(" - changing page id fields to INT UNSIGNED");
      $this->dbh->query("ALTER TABLE `{$alias}_page` CHANGE `PID` `PID` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `PID` `PID` INT( 10 ) UNSIGNED NOT NULL default '0'");
      $this->info(" - changing menu id fields to INT UNSIGNED");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `MID` `MID` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `MIDpere` `MIDpere` INT( 10 ) UNSIGNED NOT NULL default '0'");
      $this->dbh->query("ALTER TABLE `{$alias}_menu` CHANGE `ordre` `ordre` INT( 10 ) UNSIGNED NOT NULL default '0'");
      break;
      
    default:
#      $this->info(" - no changes needed.");
      break;
    }
  }

  function upgradeMaster($newversion)
  {
    // upgrade master tables
    switch($newversion) {
    case "0.9.10":
      $this->info(" - dropping fields : title, description, keywords");
      $this->dbh->query("ALTER TABLE `diogenes_site` DROP `title`");
      $this->dbh->query("ALTER TABLE `diogenes_site` DROP `description`");
      $this->dbh->query("ALTER TABLE `diogenes_site` DROP `keywords`");
      break;

    case "0.9.15":
      $this->info(" - adding field : email");
      $this->dbh->query("ALTER TABLE `diogenes_auth` ADD `email` VARCHAR( 255 ) NOT NULL");
      break;
      
    case "0.9.16":
      $this->info(" - changing user id fields to INT UNSIGNED");
      $this->dbh->query("ALTER TABLE `diogenes_auth` CHANGE `user_id` `user_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT");
      $this->dbh->query("ALTER TABLE `diogenes_logsessions` CHANGE `uid` `uid` INT(10) UNSIGNED NOT NULL default '0'");
      $this->dbh->query("ALTER TABLE `diogenes_logsessions` CHANGE `suid` `suid` INT(10) UNSIGNED NOT NULL default '0'");
      $this->dbh->query("ALTER TABLE `diogenes_perm` CHANGE `uid` `uid` INT(10) UNSIGNED NOT NULL default '0'");
      break;
      
    default:
      $this->info(" - no changes needed.");
      break;
    }
  }
}

/*
 * Main routine
*/
$creator = new DiogenesDbInit("diogenes_option");
$creator->parseOptions($argv, "diogenes", "localhost", "diogenes", "");
$creator->run();

?>
