/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.KafenioPanelActions;
import de.xeinfach.kafenio.KafenioPanelConfiguration;
import de.xeinfach.kafenio.action.StylesAction;
import de.xeinfach.kafenio.component.JButtonNoFocus;
import de.xeinfach.kafenio.component.JComboBoxNoFocus;
import de.xeinfach.kafenio.component.JToggleButtonNoFocus;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.text.DefaultEditorKit;

public class KafenioToolBar {
    private static LeanLogger log = new LeanLogger("KafenioToolBar.class");
    public static final String KEY_TOOL_SEP = "separator";
    public static final String KEY_TOOL_NEW = "new";
    public static final String KEY_TOOL_OPEN = "open";
    public static final String KEY_TOOL_SAVE = "save";
    public static final String KEY_TOOL_CUT = "cut";
    public static final String KEY_TOOL_COPY = "copy";
    public static final String KEY_TOOL_PASTE = "paste";
    public static final String KEY_TOOL_FIND = "find";
    public static final String KEY_TOOL_BOLD = "bold";
    public static final String KEY_TOOL_ITALIC = "italic";
    public static final String KEY_TOOL_UNDERLINE = "underline";
    public static final String KEY_TOOL_STRIKE = "strike";
    public static final String KEY_TOOL_SUPER = "superscript";
    public static final String KEY_TOOL_SUB = "subscript";
    public static final String KEY_TOOL_ULIST = "ulist";
    public static final String KEY_TOOL_OLIST = "olist";
    public static final String KEY_TOOL_UNDO = "undo";
    public static final String KEY_TOOL_REDO = "redo";
    public static final String KEY_TOOL_CLEAR = "clearformats";
    public static final String KEY_TOOL_CHARACTER = "insertcharacter";
    public static final String KEY_TOOL_ANCHOR = "anchor";
    public static final String KEY_TOOL_SOURCE = "viewsource";
    public static final String KEY_TOOL_STYLES = "styleselect";
    public static final String KEY_TOOL_ALIGNLEFT = "left";
    public static final String KEY_TOOL_ALIGNCENTER = "center";
    public static final String KEY_TOOL_ALIGNRIGHT = "right";
    public static final String KEY_TOOL_ALIGNJUSTIFIED = "justify";
    public static final String KEY_TOOL_INDENTLEFT = "deindent";
    public static final String KEY_TOOL_INDENTRIGHT = "indent";
    public static final String KEY_TOOL_IMAGE = "image";
    public static final String KEY_TOOL_COLOR = "color";
    public static final String KEY_TOOL_TABLE = "table";
    public static final String KEY_TOOL_SAVECONTENT = "savecontent";
    public static final String KEY_TOOL_DETACHFRAME = "detachframe";
    private KafenioPanel parent;
    private KafenioPanelConfiguration config;
    private JToolBar toolBar;
    private Hashtable toolbarItems;
    private JComboBoxNoFocus styleSelector;

    public KafenioToolBar(KafenioPanel kafenioPanel) {
        this.parent = kafenioPanel;
        this.config = this.parent.getConfig();
        this.toolBar = this.createNewToolbar();
        this.toolbarItems = this.createItems();
    }

    public JToolBar createToolbar(Vector vector, boolean bl) {
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = vector.get(i).toString();
                if (!this.toolbarItems.containsKey(string)) continue;
                if (this.toolbarItems.get(string) instanceof JButtonNoFocus) {
                    this.toolBar.add((JButtonNoFocus)this.toolbarItems.get(string));
                    continue;
                }
                if (this.toolbarItems.get(string) instanceof JToggleButtonNoFocus) {
                    this.toolBar.add((JToggleButtonNoFocus)this.toolbarItems.get(string));
                    continue;
                }
                if (this.toolbarItems.get(string) instanceof JComboBoxNoFocus) {
                    this.toolBar.add((JComboBoxNoFocus)this.toolbarItems.get(string));
                    continue;
                }
                if (this.toolbarItems.get(string) instanceof JToolBar.Separator) {
                    this.toolBar.add(new JToolBar.Separator());
                    continue;
                }
                this.toolBar.add((JComponent)this.toolbarItems.get(string));
            }
            return this.toolBar;
        }
        return null;
    }

    private JToolBar createNewToolbar() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setBackground(this.config.getBgcolor());
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private Hashtable createItems() {
        Hashtable<String, JComponent> hashtable = new Hashtable<String, JComponent>();
        hashtable.put(KEY_TOOL_NEW, this.createButton("New", "NewDocument", "newdoc", this.getParent(), null));
        hashtable.put(KEY_TOOL_OPEN, this.createButton("Open", "OpenDocument", "openhtml", this.getParent(), null));
        hashtable.put(KEY_TOOL_SAVE, this.createButton("Save", "SaveDocument", KEY_TOOL_SAVE, this.getParent(), null));
        hashtable.put(KEY_TOOL_SEP, this.createSeparator());
        hashtable.put(KEY_TOOL_CUT, this.createButton("Cut", "Cut", null, null, new DefaultEditorKit.CutAction()));
        hashtable.put(KEY_TOOL_COPY, this.createButton("Copy", "Copy", null, null, new DefaultEditorKit.CopyAction()));
        hashtable.put(KEY_TOOL_PASTE, this.createButton("Paste", "Paste", null, null, new DefaultEditorKit.PasteAction()));
        hashtable.put(KEY_TOOL_BOLD, this.createButton("Bold", "FontBold", null, null, this.getActionList().getActionFontBold()));
        hashtable.put(KEY_TOOL_ITALIC, this.createButton("Italic", "FontItalic", null, null, this.getActionList().getActionFontItalic()));
        hashtable.put(KEY_TOOL_UNDERLINE, this.createButton("Underline", "FontUnderline", null, null, this.getActionList().getActionFontUnderline()));
        hashtable.put(KEY_TOOL_STRIKE, this.createButton("Strike", "FontStrike", null, null, this.getActionList().getActionFontStrike()));
        hashtable.put(KEY_TOOL_SUPER, this.createButton("Super", "FontSuperscript", null, null, this.getActionList().getActionFontSuperscript()));
        hashtable.put(KEY_TOOL_SUB, this.createButton("Sub", "FontSubscript", null, null, this.getActionList().getActionFontSubscript()));
        hashtable.put(KEY_TOOL_ULIST, this.createButton("UList", "ListUnordered", null, null, this.getActionList().getActionListUnordered()));
        hashtable.put(KEY_TOOL_OLIST, this.createButton("OList", "ListOrdered", null, null, this.getActionList().getActionListOrdered()));
        hashtable.put(KEY_TOOL_CLEAR, this.createButton("ClearFormat", "FormatClear", null, null, this.getActionList().getActionClearFormat()));
        hashtable.put(KEY_TOOL_CHARACTER, this.createButton("Character", "InsertCharacterDialogTitle", null, null, this.getActionList().getActionInsertCharacter()));
        hashtable.put(KEY_TOOL_ALIGNLEFT, this.createButton("AlignLeft", "AlignLeft", null, null, this.getActionList().getActionAlignLeft()));
        hashtable.put(KEY_TOOL_ALIGNCENTER, this.createButton("AlignCenter", "AlignCenter", null, null, this.getActionList().getActionAlignCenter()));
        hashtable.put(KEY_TOOL_ALIGNRIGHT, this.createButton("AlignRight", "AlignRight", null, null, this.getActionList().getActionAlignRight()));
        hashtable.put(KEY_TOOL_ALIGNJUSTIFIED, this.createButton("AlignJustified", "AlignJustified", null, null, this.getActionList().getActionAlignJustified()));
        if (this.config.isApplet()) {
            log.debug("insert server image");
            hashtable.put(KEY_TOOL_IMAGE, this.createButton("InsertImage", "InsertServerImage", null, null, this.getActionList().getActionInsertServerImage()));
        } else {
            log.debug("insert local image");
            hashtable.put(KEY_TOOL_IMAGE, this.createButton("InsertImage", "InsertLocalImage", "insertlocalimage", this.getParent(), null));
        }
        hashtable.put(KEY_TOOL_UNDO, this.createButton("Undo", "Undo", null, this.getParent(), this.getParent().getUndoAction()));
        hashtable.put(KEY_TOOL_REDO, this.createButton("Redo", "Redo", null, this.getParent(), this.getParent().getRedoAction()));
        hashtable.put(KEY_TOOL_INDENTLEFT, this.createButton("IndentLeft", "IndentLeft", null, null, this.getActionList().getActionIndentLeft()));
        hashtable.put(KEY_TOOL_INDENTRIGHT, this.createButton("IndentRight", "IndentRight", null, null, this.getActionList().getActionIndentRight()));
        hashtable.put(KEY_TOOL_ANCHOR, this.createButton("Anchor", "ToolAnchor", null, null, this.getActionList().getActionInsertHyperlink()));
        hashtable.put(KEY_TOOL_FIND, this.createButton("Find", "SearchFind", KEY_TOOL_FIND, this.getParent(), null));
        hashtable.put(KEY_TOOL_COLOR, this.createButton("Color", "CustomColor", null, null, this.getActionList().getActionFontCustomColor()));
        hashtable.put(KEY_TOOL_TABLE, this.createButton("Table", "InsertTable", "inserttable", this.getParent(), null));
        hashtable.put(KEY_TOOL_SOURCE, this.createButton("Source", "ViewSource", KEY_TOOL_SOURCE, this.getParent(), null));
        hashtable.put(KEY_TOOL_SAVECONTENT, this.createButton("SaveContent", "SaveDocument", KEY_TOOL_SAVECONTENT, this.getParent(), null));
        hashtable.put(KEY_TOOL_DETACHFRAME, this.createButton("DetachFrame", "DetachFrame", KEY_TOOL_DETACHFRAME, this.getParent(), null));
        this.styleSelector = new JComboBoxNoFocus();
        this.styleSelector.setBackground(this.config.getBgcolor());
        this.styleSelector.setAction(new StylesAction(this.styleSelector));
        hashtable.put(KEY_TOOL_STYLES, this.styleSelector);
        return hashtable;
    }

    private KafenioPanel getParent() {
        return this.parent;
    }

    public JComboBoxNoFocus getStyleSelector() {
        return this.styleSelector;
    }

    private JToolBar.Separator createSeparator() {
        return new JToolBar.Separator();
    }

    private JButtonNoFocus createButton(String string, String string2, String string3, ActionListener actionListener, Action action) {
        JButtonNoFocus jButtonNoFocus;
        if (action != null) {
            jButtonNoFocus = new JButtonNoFocus(action);
            jButtonNoFocus.setIcon(this.getParent().getKafenioIcon(string));
        } else {
            jButtonNoFocus = new JButtonNoFocus(this.getParent().getKafenioIcon(string));
            jButtonNoFocus.setActionCommand(string3);
            jButtonNoFocus.addActionListener(actionListener);
        }
        jButtonNoFocus.setBackground(this.config.getBgcolor());
        jButtonNoFocus.setToolTipText(this.getParent().getTranslation(string2));
        jButtonNoFocus.setText("");
        return jButtonNoFocus;
    }

    private KafenioPanelActions getActionList() {
        return this.getParent().getKafenioActions();
    }
}

