#line 424 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "cmdline.opt"
/* This file is part of GNU Dico. -*- c -*-
   Copyright (C) 1998-2000, 2008, 2010, 2012, 2016-2018 Sergey
   Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#include <dico-priv.h>
#include <getopt.h>
#include <sysexits.h>

#line 189 "cmdline.opt"

#line 189

#line 189
#ifdef HAVE_CONFIG_H
#line 189
# include <config.h>
#line 189
#endif
#line 189
#ifdef HAVE_GETOPT_H
#line 189
# include <getopt.h>
#line 189
#endif
#line 189
#include <unistd.h>
#line 189

#line 189
#include <grecs.h>
#line 189
#include <grecs/opt.h>
#line 189
/* Option codes */
#line 189
enum {
#line 189
	_OPTION_INIT=255,
#line 189
	#line 32 "cmdline.opt"

#line 32
	OPTION_HOST,
#line 50 "cmdline.opt"

#line 50
	OPTION_SOURCE,
#line 71 "cmdline.opt"

#line 71
	OPTION_LEVDIST,
#line 73 "cmdline.opt"

#line 73
	OPTION_LEVENSHTEIN_DISTANCE,
#line 126 "cmdline.opt"

#line 126
	OPTION_SASL,
#line 132 "cmdline.opt"

#line 132
	OPTION_NOSASL,
#line 146 "cmdline.opt"

#line 146
	OPTION_PASSWORD,
#line 151 "cmdline.opt"

#line 151
	OPTION_AUTOLOGIN,
#line 176 "cmdline.opt"

#line 176
	OPTION_TIME_STAMP,
#line 183 "cmdline.opt"

#line 183
	OPTION_SOURCE_INFO,
#line 189 "cmdline.opt"

#line 189
	OPTION_USAGE,

#line 189 "cmdline.opt"
	MAX_OPTION
#line 189
};
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
static struct option long_options[] = {
#line 189
	#line 32 "cmdline.opt"

#line 32
	{ "host", required_argument, 0, OPTION_HOST },
#line 38 "cmdline.opt"

#line 38
	{ "port", required_argument, 0, 'p' },
#line 44 "cmdline.opt"

#line 44
	{ "database", required_argument, 0, 'd' },
#line 50 "cmdline.opt"

#line 50
	{ "source", required_argument, 0, OPTION_SOURCE },
#line 58 "cmdline.opt"

#line 58
	{ "match", no_argument, 0, 'm' },
#line 64 "cmdline.opt"

#line 64
	{ "strategy", required_argument, 0, 's' },
#line 71 "cmdline.opt"

#line 71
	{ "levdist", required_argument, 0, OPTION_LEVDIST },
#line 73 "cmdline.opt"

#line 73
	{ "levenshtein-distance", required_argument, 0, OPTION_LEVENSHTEIN_DISTANCE },
#line 81 "cmdline.opt"

#line 81
	{ "dbs", no_argument, 0, 'D' },
#line 87 "cmdline.opt"

#line 87
	{ "strategies", no_argument, 0, 'S' },
#line 93 "cmdline.opt"

#line 93
	{ "serverhelp", no_argument, 0, 'H' },
#line 99 "cmdline.opt"

#line 99
	{ "info", required_argument, 0, 'i' },
#line 106 "cmdline.opt"

#line 106
	{ "serverinfo", no_argument, 0, 'I' },
#line 112 "cmdline.opt"

#line 112
	{ "quiet", no_argument, 0, 'q' },
#line 120 "cmdline.opt"

#line 120
	{ "noauth", no_argument, 0, 'a' },
#line 126 "cmdline.opt"

#line 126
	{ "sasl", no_argument, 0, OPTION_SASL },
#line 132 "cmdline.opt"

#line 132
	{ "nosasl", no_argument, 0, OPTION_NOSASL },
#line 138 "cmdline.opt"

#line 138
	{ "user", required_argument, 0, 'u' },
#line 144 "cmdline.opt"

#line 144
	{ "key", required_argument, 0, 'k' },
#line 146 "cmdline.opt"

#line 146
	{ "password", required_argument, 0, OPTION_PASSWORD },
#line 151 "cmdline.opt"

#line 151
	{ "autologin", required_argument, 0, OPTION_AUTOLOGIN },
#line 157 "cmdline.opt"

#line 157
	{ "client", required_argument, 0, 'c' },
#line 164 "cmdline.opt"

#line 164
	{ "transcript", no_argument, 0, 't' },
#line 170 "cmdline.opt"

#line 170
	{ "verbose", no_argument, 0, 'v' },
#line 176 "cmdline.opt"

#line 176
	{ "time-stamp", no_argument, 0, OPTION_TIME_STAMP },
#line 183 "cmdline.opt"

#line 183
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 189 "cmdline.opt"

#line 189
	{ "help", no_argument, 0, 'h' },
#line 189 "cmdline.opt"

#line 189
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 189 "cmdline.opt"

#line 189
	{ "version", no_argument, 0, 'V' },

#line 189 "cmdline.opt"
	{0, 0, 0, 0}
#line 189
};
#line 189
#endif
#line 189
static struct grecs_opthelp opthelp[] = {
#line 189
	#line 30 "cmdline.opt"

#line 30
	{ NULL, NULL, 0, N_("Server selection") },
#line 34 "cmdline.opt"

#line 34
	{
#line 34
#ifdef HAVE_GETOPT_LONG
#line 34
	  "--host",
#line 34
#else
#line 34
	  "",
#line 34
#endif
#line 34
				   N_("SERVER"), 0, N_("connect to this server") },
#line 40 "cmdline.opt"

#line 40
	{
#line 40
#ifdef HAVE_GETOPT_LONG
#line 40
	  "-p, --port",
#line 40
#else
#line 40
	  "-p",
#line 40
#endif
#line 40
				   N_("SERVICE"), 0, N_("specify port to connect to") },
#line 46 "cmdline.opt"

#line 46
	{
#line 46
#ifdef HAVE_GETOPT_LONG
#line 46
	  "-d, --database",
#line 46
#else
#line 46
	  "-d",
#line 46
#endif
#line 46
				   N_("NAME"), 0, N_("select a database to search") },
#line 52 "cmdline.opt"

#line 52
	{
#line 52
#ifdef HAVE_GETOPT_LONG
#line 52
	  "--source",
#line 52
#else
#line 52
	  "",
#line 52
#endif
#line 52
				   N_("ADDR"), 0, N_("set a source address for TCP connections") },
#line 56 "cmdline.opt"

#line 56
	{ NULL, NULL, 0, N_("Operation modes") },
#line 60 "cmdline.opt"

#line 60
	{
#line 60
#ifdef HAVE_GETOPT_LONG
#line 60
	  "-m, --match",
#line 60
#else
#line 60
	  "-m",
#line 60
#endif
#line 60
				   NULL, 0, N_("match instead of define") },
#line 66 "cmdline.opt"

#line 66
	{
#line 66
#ifdef HAVE_GETOPT_LONG
#line 66
	  "-s, --strategy",
#line 66
#else
#line 66
	  "-s",
#line 66
#endif
#line 66
				   N_("NAME"), 0, N_("select a strategy for matching; implies --match") },
#line 74 "cmdline.opt"

#line 74
	{
#line 74
#ifdef HAVE_GETOPT_LONG
#line 74
	  "--levdist, --levenshtein-distance",
#line 74
#else
#line 74
	  "",
#line 74
#endif
#line 74
				   N_("N"), 0, N_("set maximum Levenshtein distance") },
#line 83 "cmdline.opt"

#line 83
	{
#line 83
#ifdef HAVE_GETOPT_LONG
#line 83
	  "-D, --dbs",
#line 83
#else
#line 83
	  "-D",
#line 83
#endif
#line 83
				   NULL, 0, N_("show available databases") },
#line 89 "cmdline.opt"

#line 89
	{
#line 89
#ifdef HAVE_GETOPT_LONG
#line 89
	  "-S, --strategies",
#line 89
#else
#line 89
	  "-S",
#line 89
#endif
#line 89
				   NULL, 0, N_("show available search strategies") },
#line 95 "cmdline.opt"

#line 95
	{
#line 95
#ifdef HAVE_GETOPT_LONG
#line 95
	  "-H, --serverhelp",
#line 95
#else
#line 95
	  "-H",
#line 95
#endif
#line 95
				   NULL, 0, N_("show server help") },
#line 101 "cmdline.opt"

#line 101
	{
#line 101
#ifdef HAVE_GETOPT_LONG
#line 101
	  "-i, --info",
#line 101
#else
#line 101
	  "-i",
#line 101
#endif
#line 101
				   N_("DBNAME"), 0, N_("show information about database DBNAME") },
#line 108 "cmdline.opt"

#line 108
	{
#line 108
#ifdef HAVE_GETOPT_LONG
#line 108
	  "-I, --serverinfo",
#line 108
#else
#line 108
	  "-I",
#line 108
#endif
#line 108
				   NULL, 0, N_("show information about the server") },
#line 114 "cmdline.opt"

#line 114
	{
#line 114
#ifdef HAVE_GETOPT_LONG
#line 114
	  "-q, --quiet",
#line 114
#else
#line 114
	  "-q",
#line 114
#endif
#line 114
				   NULL, 0, N_("do not print the normal dico welcome") },
#line 118 "cmdline.opt"

#line 118
	{ NULL, NULL, 0, N_("Authentication") },
#line 122 "cmdline.opt"

#line 122
	{
#line 122
#ifdef HAVE_GETOPT_LONG
#line 122
	  "-a, --noauth",
#line 122
#else
#line 122
	  "-a",
#line 122
#endif
#line 122
				   NULL, 0, N_("disable authentication") },
#line 128 "cmdline.opt"

#line 128
	{
#line 128
#ifdef HAVE_GETOPT_LONG
#line 128
	  "--sasl",
#line 128
#else
#line 128
	  "",
#line 128
#endif
#line 128
				   NULL, 0, N_("enable SASL authentication (default)") },
#line 134 "cmdline.opt"

#line 134
	{
#line 134
#ifdef HAVE_GETOPT_LONG
#line 134
	  "--nosasl",
#line 134
#else
#line 134
	  "",
#line 134
#endif
#line 134
				   NULL, 0, N_("disable SASL authentication") },
#line 140 "cmdline.opt"

#line 140
	{
#line 140
#ifdef HAVE_GETOPT_LONG
#line 140
	  "-u, --user",
#line 140
#else
#line 140
	  "-u",
#line 140
#endif
#line 140
				   N_("NAME"), 0, N_("set user name for authentication") },
#line 147 "cmdline.opt"

#line 147
	{
#line 147
#ifdef HAVE_GETOPT_LONG
#line 147
	  "-k, --key, --password",
#line 147
#else
#line 147
	  "-k",
#line 147
#endif
#line 147
				   N_("STRING"), 0, N_("set shared secret for authentication") },
#line 153 "cmdline.opt"

#line 153
	{
#line 153
#ifdef HAVE_GETOPT_LONG
#line 153
	  "--autologin",
#line 153
#else
#line 153
	  "",
#line 153
#endif
#line 153
				   N_("NAME"), 0, N_("set the name of autologin file to use") },
#line 159 "cmdline.opt"

#line 159
	{
#line 159
#ifdef HAVE_GETOPT_LONG
#line 159
	  "-c, --client",
#line 159
#else
#line 159
	  "-c",
#line 159
#endif
#line 159
				   N_("STRING"), 0, N_("additional text for client command") },
#line 163 "cmdline.opt"

#line 163
	{ NULL, NULL, 0, N_("Debugging") },
#line 166 "cmdline.opt"

#line 166
	{
#line 166
#ifdef HAVE_GETOPT_LONG
#line 166
	  "-t, --transcript",
#line 166
#else
#line 166
	  "-t",
#line 166
#endif
#line 166
				   NULL, 0, N_("enable session transcript") },
#line 172 "cmdline.opt"

#line 172
	{
#line 172
#ifdef HAVE_GETOPT_LONG
#line 172
	  "-v, --verbose",
#line 172
#else
#line 172
	  "-v",
#line 172
#endif
#line 172
				   NULL, 0, N_("increase debugging verbosity level") },
#line 178 "cmdline.opt"

#line 178
	{
#line 178
#ifdef HAVE_GETOPT_LONG
#line 178
	  "--time-stamp",
#line 178
#else
#line 178
	  "",
#line 178
#endif
#line 178
				   NULL, 0, N_("include time stamp in the debugging output") },
#line 185 "cmdline.opt"

#line 185
	{
#line 185
#ifdef HAVE_GETOPT_LONG
#line 185
	  "--source-info",
#line 185
#else
#line 185
	  "",
#line 185
#endif
#line 185
				   NULL, 0, N_("include source line information in the debugging output") },
#line 189 "cmdline.opt"

#line 189
	{ NULL, NULL, 0, N_("Other options") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-h, --help",
#line 189
#else
#line 189
	  "-h",
#line 189
#endif
#line 189
				   NULL, 0, N_("Give this help list") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "--usage",
#line 189
#else
#line 189
	  "",
#line 189
#endif
#line 189
				   NULL, 0, N_("Give a short usage message") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-V, --version",
#line 189
#else
#line 189
	  "-V",
#line 189
#endif
#line 189
				   NULL, 0, N_("Print program version") },

#line 189 "cmdline.opt"
};
#line 22 "cmdline.opt"

#line 22

#line 22
static struct grecs_proginfo proginfo = {
#line 22
	"dico", /* progname */
#line 22
	NULL, /* subcommands */
#line 22
	N_("GNU dictionary client program"), /* docstring */
#line 22
	N_("[URL-or-WORD]"), /* args_doc */
#line 22
	opthelp, /* opthelp */
#line 22
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 22
	NULL, /* print_help_hook */
#line 22
	NULL, /* print_version_hook */
#line 22
	PACKAGE_NAME,    /* package */
#line 22
	PACKAGE_VERSION, /* version */
#line 22
	NULL, /* license */
#line 22
	"2005-2017",/* copyright_year */
#line 22
	"Free Software Foundation, Inc.", /* copyright_holder */
#line 22
	NULL, /* *authors */
#line 22
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 22
	PACKAGE_URL, /* url */
#line 22
	NULL  /* epilogue */
#line 22
};
#line 22
static struct grecs_node *cmdline_tree;
#line 22

#line 22

#line 189 "cmdline.opt"

#line 189


void
get_options (int argc, char *argv[], int *index)
{
    
#line 194
 {
#line 194
  int c;
#line 194

#line 194
  optind = 0;
#line 194
#ifdef HAVE_GETOPT_LONG
#line 194
  while ((c = getopt_long(argc, argv, "p:d:ms:DSHi:Iqau:k:c:tvhV",
#line 194
			  long_options, NULL)) != EOF)
#line 194
#else
#line 194
  while ((c = getopt(argc, argv, "p:d:ms:DSHi:Iqau:k:c:tvhV")) != EOF)
#line 194
#endif
#line 194
    {
#line 194
      switch (c)
#line 194
	{
#line 194
	default:
#line 194
	   	   exit(EX_USAGE);
#line 194
	#line 34 "cmdline.opt"
	 case OPTION_HOST:
#line 34
	  {
#line 34

  xdico_assign_string(&dico_url.host, optarg);

#line 36
	     break;
#line 36
	  }
#line 40 "cmdline.opt"
	 case 'p':
#line 40
	  {
#line 40

  xdico_assign_string(&dico_url.port, optarg);

#line 42
	     break;
#line 42
	  }
#line 46 "cmdline.opt"
	 case 'd':
#line 46
	  {
#line 46

  xdico_assign_string(&dico_url.req.database, optarg);  

#line 48
	     break;
#line 48
	  }
#line 52 "cmdline.opt"
	 case OPTION_SOURCE:
#line 52
	  {
#line 52

  source_addr = optarg;

#line 54
	     break;
#line 54
	  }
#line 60 "cmdline.opt"
	 case 'm':
#line 60
	  {
#line 60

  mode = mode_match;   

#line 62
	     break;
#line 62
	  }
#line 66 "cmdline.opt"
	 case 's':
#line 66
	  {
#line 66

  xdico_assign_string(&dico_url.req.strategy, optarg);
  mode = mode_match;

#line 69
	     break;
#line 69
	  }
#line 74 "cmdline.opt"
	 case OPTION_LEVDIST: case OPTION_LEVENSHTEIN_DISTANCE:
#line 74
	  {
#line 74

  char *p;
  levenshtein_threshold = strtoul(optarg, &p, 10);
  if (*p)
      dico_die(1, L_ERR, 0, _("%s: invalid number"), optarg);

#line 79
	     break;
#line 79
	  }
#line 83 "cmdline.opt"
	 case 'D':
#line 83
	  {
#line 83

  mode = mode_dbs;  

#line 85
	     break;
#line 85
	  }
#line 89 "cmdline.opt"
	 case 'S':
#line 89
	  {
#line 89

  mode = mode_strats;

#line 91
	     break;
#line 91
	  }
#line 95 "cmdline.opt"
	 case 'H':
#line 95
	  {
#line 95

  mode = mode_help;

#line 97
	     break;
#line 97
	  }
#line 101 "cmdline.opt"
	 case 'i':
#line 101
	  {
#line 101

  mode = mode_info;
  dico_url.req.database = optarg;

#line 104
	     break;
#line 104
	  }
#line 108 "cmdline.opt"
	 case 'I':
#line 108
	  {
#line 108

  mode = mode_server;

#line 110
	     break;
#line 110
	  }
#line 114 "cmdline.opt"
	 case 'q':
#line 114
	  {
#line 114

  quiet_option = 1;

#line 116
	     break;
#line 116
	  }
#line 122 "cmdline.opt"
	 case 'a':
#line 122
	  {
#line 122

  noauth_option = 1;

#line 124
	     break;
#line 124
	  }
#line 128 "cmdline.opt"
	 case OPTION_SASL:
#line 128
	  {
#line 128

  sasl_enable(1);

#line 130
	     break;
#line 130
	  }
#line 134 "cmdline.opt"
	 case OPTION_NOSASL:
#line 134
	  {
#line 134

  sasl_enable(0);

#line 136
	     break;
#line 136
	  }
#line 140 "cmdline.opt"
	 case 'u':
#line 140
	  {
#line 140

  default_cred.user = optarg;

#line 142
	     break;
#line 142
	  }
#line 147 "cmdline.opt"
	 case 'k': case OPTION_PASSWORD:
#line 147
	  {
#line 147

  default_cred.pass = optarg;

#line 149
	     break;
#line 149
	  }
#line 153 "cmdline.opt"
	 case OPTION_AUTOLOGIN:
#line 153
	  {
#line 153

  autologin_file = optarg;

#line 155
	     break;
#line 155
	  }
#line 159 "cmdline.opt"
	 case 'c':
#line 159
	  {
#line 159

  client = optarg;

#line 161
	     break;
#line 161
	  }
#line 166 "cmdline.opt"
	 case 't':
#line 166
	  {
#line 166

  transcript = 1;

#line 168
	     break;
#line 168
	  }
#line 172 "cmdline.opt"
	 case 'v':
#line 172
	  {
#line 172

  debug_level++;

#line 174
	     break;
#line 174
	  }
#line 178 "cmdline.opt"
	 case OPTION_TIME_STAMP:
#line 178
	  {
#line 178

  int n = 1;
  dico_stream_ioctl(debug_stream, DICO_DBG_CTL_SET_TS, &n);

#line 181
	     break;
#line 181
	  }
#line 185 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 185
	  {
#line 185

  debug_source_info = 1;

#line 187
	     break;
#line 187
	  }
#line 189 "cmdline.opt"
	 case 'h':
#line 189
	  {
#line 189

#line 189
		grecs_print_help(&proginfo);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }
#line 189 "cmdline.opt"
	 case OPTION_USAGE:
#line 189
	  {
#line 189

#line 189
		grecs_print_usage(&proginfo);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }
#line 189 "cmdline.opt"
	 case 'V':
#line 189
	  {
#line 189

#line 189
		/* Give version */
#line 189
		grecs_print_version(&proginfo, stdout);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }

#line 194 "cmdline.opt"
	}
#line 194
    }
#line 194

#line 194
  *index = optind;
#line 194
  if (cmdline_tree)
#line 194
    {
#line 194
      struct grecs_node *rn = grecs_node_create(grecs_node_root, NULL);
#line 194
      rn->down = cmdline_tree;
#line 194
      cmdline_tree = rn;
#line 194
    }
#line 194
 }
#line 194

}

static char gplv3_text[] = "\
   GNU Dico is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3, or (at your option)\n\
   any later version.\n\
\n\
   GNU Dico is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU General Public License for more details.\n\
\n\
   You should have received a copy of the GNU General Public License\n\
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>.\n";

void
ds_warranty(int argc, char **argv)
{
    grecs_print_version_only(&proginfo, stdout);
    putchar('\n');
    printf("%s", gplv3_text);
}

void
shell_banner()
{
    grecs_print_version(&proginfo, stdout);
    printf("%s\n\n", _("Type ? for help summary"));
}

