/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*****************************************************************
// Structures used to parse the Glade project file
//**************************************************************

struct s_glade_signal {
	gchar *signal_name;
	gchar *handler_function;
	gchar *after;
	struct s_glade_signal *next;
	struct s_glade_signal *previous;
};

struct s_glade_widget_property {
	gchar *property_name;
	gchar *translatable;
	gchar *value;
	struct s_glade_widget_property *next;
	struct s_glade_widget_property *previous;
};

struct s_glade_widget {
	gchar *widget_name;
	gchar *class;
	struct s_glade_signal *signals;
	struct s_glade_widget_property *properties;
	struct s_glade_widget *next;
	struct s_glade_widget *previous;
};

struct s_glade_project_window {
	gchar *window_name;
	gchar *window_class;
	GtkWidget *window_widget;
	struct s_glade_widget *widgets;
	struct s_glade_project_window *next;
	struct s_glade_project_window *previous;
};

struct s_glade_druid_data {
	gchar *name;
	gchar *program;
	gchar *directory;
	gchar *sources;
	gchar *pixmaps;
	gchar *interface;
	gboolean gnome;
	gboolean libglade;
	gboolean gettext;
	gchar *strings;
};

//*******************************************************************

struct s_glade_project_window *glade_window_list;
enum {COL_ICON, COL_NAME, TOTAL_COLUMNS};
GtkTreeStore *gui_store;
GtkTreeIter gui_raiz;
GtkWidget *current_glade_gui_widget;
struct s_glade_project_window *current_glade_gui_window;
struct s_glade_widget *glade_widget_list, *glade_widget_list_last_widget;
struct s_glade_druid_data glade_druid_data;

//*******************************************************************

void gla_ejecutar(void);

void gla_crear(gchar *nombre);

gint gla_create_glade_window_list (gchar *glade_file);

void gla_free_glade_window_list (void);

void gla_gui_treeview_init (void);

gint gla_gui_treeview_populate (void);

gint gla_parse_glade_project_file (gchar *glade_project_file);

struct s_glade_widget *gla_process_glade_widget_node (xmlNodePtr widget_node, gint *error);

gint gla_free_glade_widget_property_list (struct s_glade_widget_property *widget_property_list);

gint gla_free_glade_signal_list (struct s_glade_signal *signal_list);

gint gla_free_glade_widget_list (struct s_glade_widget *widget_list);

void gla_leer_proyecto_druid(void);

void gla_mostrar_datos_druid(void);
