/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/test_suites.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: alpha] various @ref ::diagnostics::unittest::Test_Suite s for testing
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__TEST_SUITES_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__TEST_SUITES_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

class Test_Suite;

TEST_NAMESPACE_BEGIN;

::diagnostics::unittest::Test_Suite * simple_test_suite();
::diagnostics::unittest::Test_Suite * simple_unnamed_test_suite();
::diagnostics::unittest::Test_Suite * test_suite_all_test_case_variations();


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
