/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/diff.hpp
 *
 * @brief [LEVEL: alpha] @ref diagnostics::internal::diff_text
 *
 * This component contains interfaces for diffing strings. Currently,
 * there are only methods for generating a string which describes the
 * diff in a human-readable form.
 *
 * $Id: diff.hpp 786 2007-03-01 21:48:44Z tautschn $
 * 
 * @author Piotr Esden-Tempski
 *
 * @test diagnostics/util/diff.t.cpp
 */

#ifndef DIAGNOSTICS__UTIL__DIFF_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DIFF_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

// used by reference in the interface
#include <string>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

/**
 * @brief
 *
 * @todo document
 */
void diff_text(::std::string const & texta, 
	       ::std::string const & textb, 
	       ::std::string & result, 
	       bool const use_color);

/**
 * @brief
 *
 * @todo document
 */
::std::string diff_text(::std::string const & texta,
			::std::string const & textb, 
			bool const use_color);

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
	
#endif

// vim:ts=4:sw=4
