/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/name_separators.hpp 
 *
 * @brief [LEVEL: beta] @ref
 * diagnostics::unittest::name_adheres_convention, @ref
 * diagnostics::unittest::path_adheres_convention, and @ref
 * diagnostics::unittest::mask_adheres_convention
 *
 * $Id: name_separators.hpp,v 1.7 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test diagnostics/unittest/name_separators.t.cpp
 */

#ifndef DIAGNOSTICS__UNITTEST__NAME_SEPARATORS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__NAME_SEPARATORS_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>

#include <string>

/**
 * @brief to match everything
 */
#define DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK "*"
/**
 * @brief to sperate parts of a test case path
 * (test_suite1/test_suite2/test_case)
 */
#define DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR "/"
/**
 * @brief to sperate the test case path from the the test data name
 * (test_suite1/test_suite2/test_case//data)
 */
#define DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR "//"

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

/**
 * @brief checks whether @a name can be used as a name for a @ref
 * Test_Suite or a @ref Test_Case.
 *
 * @returns true iff name does neither contain a @ref
 * DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR nor a @ref
 * DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR nor a @ref
 * DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK.
 *
 * @note a name can be empty. This is used for the unnamed @ref Test_Suite.
 *
 * @throw never
 */
bool name_adheres_convention(::std::string const & name);

/**
 * @brief checks whether @a path can be used as a path to a @ref
 * Test_Suite or a @ref Test_Case.
 *
 * @returns true iff @a path 
 * @arg starts with a @ref DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR, 
 * @arg contains neither @ref DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR 
 * @arg nor a @ref DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK, 
 * @arg and contains no DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR directly following
 * each other.
 * @arg Moreover, @a path is not allowed to end with @ref DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR
 *
 * @throw never
 */
bool path_adheres_convention(::std::string const & path);

/**
 * @brief checks whether @a mask can be used as a mask to match paths.
 *
 * @returns true iff @a mask 
 * @arg starts with a @ref DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR, 
 * @arg contains neither @ref DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR, 
 * @arg and contains no DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR directly following
 * each other.  
 * @arg Moreover, @a mask is not allowed to end with @ref DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR.
 * @arg Finally, @a mask a @ref DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK is only allowed as suffix, or 
 * it must between two @ref DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR. 
 *
 * @throw never
 */
bool mask_adheres_convention(::std::string const & mask);


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif

// vim:ts=4:sw=4
