/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */



#ifndef DIAGNOSTICS__EXTENSIONS__MEMORY__OPERATORS__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__MEMORY__OPERATORS__INCLUDE_GUARD

#include <diagnostics/frame/platform_config.hpp>

#if DIAGNOSTICS_SWITCH_MEMORY_ANALYSIS_ENABLED == 1

#include <diagnostics/extensions/memory/allocation_database.hpp>

#include <cstdlib>
 
void* operator new(::std::size_t const len) 
    throw(::std::bad_alloc)
{ 
    void* const result(malloc(len));
    ::diagnostics::memory::Allocation_Database::register_allocation(result,len);
    return result; 
}

void operator delete(void * const p,::std::size_t const len) 
{ 
    if(p==NULL) return;
    if(::diagnostics::memory::Allocation_Database::register_deallocation(p))
	free(p); 
}
void operator delete(void * const p) 
    throw()
{ 
    if(p==NULL) return;
    ::diagnostics::memory::Allocation_Database::register_deallocation(p);
    free(p); 
}

void* operator new[](::std::size_t const len) 
    throw(::std::bad_alloc)
{ 
    void* const result(malloc(len));
    ::diagnostics::memory::Allocation_Database::register_allocation(result,len);
    return result; 
}
void operator delete[](void * const p,::std::size_t const len) 
{ 
    if(p==NULL) return;
    ::diagnostics::memory::Allocation_Database::register_deallocation(p);
    free(p); 
}
void operator delete[](void * const p) 
    throw()
{ 
    if(p==NULL) return;
    ::diagnostics::memory::Allocation_Database::register_deallocation(p);
    free(p); 
}

#endif

#endif

// vim:ts=4:sw=4
