/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "utils.h"
#include "detect.h"
#include "SuperProbe/Probe.h"


extern struct video_info *video_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct video_info *result = (struct video_info *)NULL;
  static struct video_info *first = (struct video_info *)NULL;
  char *buffer = (char *)NULL;
  
  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    fprintf(stdout, "\nProbing videocards...\n");
  
  /********************************************************************/
  /********************** PCI VIDEOCARD DETECTION *********************/
  /********************************************************************/
 if(debug)
   fprintf(stdout, "\tProbing PCI videocards...\n");
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == VIDEOCARD){
      if(!first){
        first = result = (struct video_info *) 
                                   my_malloc(sizeof(struct video_info));
      }else{
        result->next = (struct video_info *) 
                                   my_malloc(sizeof(struct video_info));
        result = result->next;
      }/*endif*/
      result->next = (struct video_info *)NULL;
      
      result->vendor = pci->vendor;
      result->model = pci->model;
      result->bus = PCI;
      result->server = pci->modulename;
      result->memory = 256;
      result->ramdac = NULL;
      result->clockchip = NULL;
      result->long_id = pci->id;
      if(debug){
        fprintf(stdout, "\t\tFound %s %s (%s)\n", 
                         result->vendor, result->model, result->server);
      }/*endif*/
    }/*endif*/
  }/*next pci*/
  
  
  /********************************************************************/
  /**************** ISA/EISA/VLB VIDEOCARD DETECTION ******************/
  /***************** BASED ON THE SUPERPROBE CODE *********************/
  /********************************************************************/
  if(!first){
    if(debug){
      fprintf(stdout, "\tProbing ISA/VLB videocards...\n");
    }/*endif*/
    buffer = (char *) my_malloc(200);
    buffer = probe();
    if(buffer != NULL){
      if(!strstr(extract_word(buffer, 2, "|"), "UNKNOWN")){
        if(!first){
          first = result = (struct video_info *) 
                                   my_malloc(sizeof(struct video_info));
        }else{
          result->next = (struct video_info *) 
                                   my_malloc(sizeof(struct video_info));
          result = result->next;
        }/*endif*/
        result->next = (struct video_info *)NULL;
        
        result->vendor = extract_word(buffer, 1, "|");
        result->model = extract_word(buffer, 2, "|");
        result->server = extract_word(buffer, 3, "|");
        result->bus = UNKNOWN_BUS;
        if(extract_word(buffer, 4, "|") == NULL){
          /* Unsupported chipset :( */
          result->memory = 0;
        }else{
          result->memory = atoi(extract_word(buffer, 4, "|"));
        }/*endif*/
        result->ramdac = extract_word(buffer, 5, "|");
        result->clockchip = s_unknown;
        if(debug){
          fprintf(stdout, "\t\tFound %s %s (%s)\n", 
                         result->vendor, result->model, result->server);
        }/*endif*/
      }/*endif*/
    }/*endif*/
  }/*endif*/

  return first;
}/*endfunc video_detect*/
