/* timesigdialog.c
 * a callback that creates a dialog boxes prompting the
 * user for information on changing the time signature

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001 Matthew Hiller */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "datastructures.h"
#include "dialogs.h"
#include "draw.h"
#include "measureops.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  staff *curstaffstruct;
  GtkWidget *textentry1;
  GtkWidget *textentry2;
  GtkWidget *checkbutton;
};

gint ispow2 (gint x)
{
  for (; !(x & 1); x >>= 1)
    ;				/* Go through all the low order bits that are equal to 0 */
  return (x == 1);
}

void
set_timesig (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  gint time1 = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->textentry1)));
  gint time2 = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->textentry2)));
  staffnode *curstaff;
  staff *curstaffstruct;

  if (time1 && time2 && ispow2 (time2) && time1 < 1000 && time2 < 1000)
    {
      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (cbdata->checkbutton)))
	{
	  for (curstaff = cbdata->si->thescore;
	       curstaff; curstaff = curstaff->next)
	    {
	      curstaffstruct = curstaff->data;
	      curstaffstruct->stime1 = time1;
	      curstaffstruct->stime2 = time2;
	      beamsandstemdirswholestaff (curstaffstruct);
	    }
	  find_leftmost_allcontexts (cbdata->si);
	}
      else
	{
	  cbdata->curstaffstruct->stime1 = time1;
	  cbdata->curstaffstruct->stime2 = time2;
	  beamsandstemdirswholestaff (cbdata->curstaffstruct);
	  find_leftmost_staffcontext (cbdata->curstaffstruct, cbdata->si);
	}
      find_xes_in_all_measures (cbdata->si);
      nudgerightward (cbdata->si);
      cbdata->si->haschanged = TRUE;
      gtk_widget_draw (cbdata->si->scorearea, NULL);
    }
}

void
insert_timesig (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  gint time1 = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->textentry1)));
  gint time2 = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->textentry2)));
  staffnode *curstaff;
  measurenode *curmeasure;
  objnode *firstobj;
  mudelaobject *firstmudobj;
  struct scoreinfo *si = cbdata->si;
  gboolean replacing = FALSE;	/* if we don't use this trick, anomalous
				   * stuff can happen when replacing a time
				   * signature */

  for (curstaff = si->thescore; curstaff; curstaff = curstaff->next)
    {
      curmeasure = g_list_nth (firstmeasurenode (curstaff),
			       si->currentmeasurenum - 1);
      /* First, look to see if there already is a time signature change at
         the beginning of this measure. If so, delete it first. */
      firstobj = firstobjnode (curmeasure);
      if (firstobj)
	firstmudobj = firstobj->data;
      else
	firstmudobj = NULL;
      if (firstmudobj && firstmudobj->type == TIMESIG)
	{
	  replacing = TRUE;
	  curmeasure->data = g_list_remove_link (curmeasure->data, firstobj);
	  freeobject (firstmudobj);
	  g_list_free_1 (firstobj);
	}
      curmeasure->data = g_list_prepend (curmeasure->data,
					 newtimesigobj (time1, time2));
      if (curmeasure == si->currentmeasure)
	{
	  if (!replacing)
	    si->cursor_x++;
	  if (si->cursor_appending)
	    si->currentobject = g_list_last (curmeasure->data);
	  else
	    si->currentobject = g_list_nth (curmeasure->data, si->cursor_x);
	}
      beamsandstemdirswholestaff (curstaff->data);
    }
  find_xes_in_all_measures (si);
  nudgerightward (si);
  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}

void timesig_change
  (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *textentry1;
  GtkWidget *textentry2;
  GtkWidget *checkbutton;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static struct callbackdata cbdata;
  static GString *entrycontent = NULL;
  struct scoreinfo *si = callback_data;
  staff *curstaffstruct = si->currentstaff->data;

  if (!entrycontent)
    entrycontent = g_string_new (NULL);

  dialog = gtk_dialog_new ();

  if (callback_action == CHANGEINITIAL)
    gtk_window_set_title (GTK_WINDOW (dialog),
			  _("Change initial time signature"));
  else
    gtk_window_set_title (GTK_WINDOW (dialog),
			  _("Insert time signature change"));

  label = gtk_label_new (_("Enter desired time signature:"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  textentry1 = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", curstaffstruct->stime1);
  gtk_entry_set_text (GTK_ENTRY (textentry1), entrycontent->str);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      textentry1, TRUE, TRUE, 0);
  gtk_widget_show (textentry1);

  textentry2 = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", curstaffstruct->stime2);
  gtk_entry_set_text (GTK_ENTRY (textentry2), entrycontent->str);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      textentry2, TRUE, TRUE, 0);
  gtk_widget_show (textentry2);

  checkbutton = gtk_check_button_new_with_label (_("Apply to all staves?"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      checkbutton, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);
  gtk_widget_set_sensitive (checkbutton, FALSE);
  gtk_widget_show (checkbutton);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  cbdata.curstaffstruct = curstaffstruct;
  cbdata.textentry1 = textentry1;
  cbdata.textentry2 = textentry2;
  cbdata.checkbutton = checkbutton;
  cbdata.si = si;
  gtk_signal_connect_object (GTK_OBJECT (textentry1), "activate",
			     gtk_widget_grab_focus, GTK_OBJECT (textentry2));
  if (callback_action == CHANGEINITIAL)
    {
      processenter (textentry2, set_timesig, cbdata, dialog);
      gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
			  GTK_SIGNAL_FUNC (set_timesig), &cbdata);
    }
  else
    {
      processenter (textentry2, insert_timesig, cbdata, dialog);
      gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
			  GTK_SIGNAL_FUNC (insert_timesig), &cbdata);
    }
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_widget_grab_focus (textentry1);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
