/* $Id: file.c,v 1.1.1.1 2000/10/13 06:45:02 kitame Exp $

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <zlib.h>

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/param.h>

#include <gnome.h>

#include "dedit.h"
#include "callbacks.h"
#include "jcode.h"
#include "utils.h"
#include "mdi.h"
#include "file.h"

static void file_ok_sel(GtkWidget *widget, gpointer data);
static void save_file(DEdit *doc, gchar *file_name);
static void save_file_ok_sel(GtkWidget *widget, gpointer data);
static void fs_menu_cb(gint data);
static void cancel_cb(GtkWidget *widget, gpointer *data);

gint fs_code;
static GtkWidget *file_sel;

/*
 *
 */

static void
fs_menu_cb(gint data)
{
#ifdef TRACE_FUNC
    printf("fs_menu_cb()\n");
#endif

    fs_code = (gint)data;

    return;
}


static void
file_ok_sel(GtkWidget *widget, gpointer data)
{
    gchar file_name[PATH_MAX];
  
#ifdef TRACE_FUNC
    g_print("file_ok_sel()\n");
#endif

    g_snprintf(file_name, sizeof(file_name), "%s", 
               gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel)));

	gtk_widget_destroy(GTK_WIDGET(file_sel));
	file_sel = NULL;

    if(file_name) {
        dedit_new_document(NULL, file_name);
    }

    return;
}

static void
cancel_cb(GtkWidget *widget, gpointer *data)
{
#ifdef TRACE_FUNC
    printf("cancel_cb()\n");
#endif

    gtk_widget_destroy(GTK_WIDGET(*data));
    *data = NULL;

    return;
}

void
file_open_cb(GtkWidget *widget, gpointer data)
{
    DEdit *doc = NULL;
    gchar buf[PATH_MAX];
    GtkWidget *option_menu;
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *load_menu;
    GtkWidget *menu_items;

#ifdef TRACE_FUNC
    printf("file_open_cb()\n");
#endif

    file_sel = gtk_file_selection_new(_("DEdit: Open"));

    doc = get_doc_from_mdi_child();
    if(doc) {
        if(doc->path) {
            g_snprintf(buf, sizeof(buf), "%s/", doc->path);
            gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_sel),
                                            buf);
        }
    }
	gtk_window_position(GTK_WINDOW(file_sel), GTK_WIN_POS_MOUSE);
    GTK_WINDOW(file_sel)->type = GTK_WINDOW_DIALOG;
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_sel));

 	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC(file_ok_sel),
                       (gpointer)doc);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC(cancel_cb), &file_sel);

    gtk_window_set_modal(GTK_WINDOW(file_sel), TRUE);

    hbox = gtk_hbox_new (FALSE, 1);
    gtk_container_border_width(GTK_CONTAINER(hbox), 0);
    
    label = gtk_label_new(_("Japanese Character Set:"));
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);
    
    option_menu = gtk_option_menu_new ();
    gtk_box_pack_start(GTK_BOX(hbox), option_menu, TRUE, TRUE, 0);
    gtk_widget_show(option_menu);
    
    load_menu = gtk_menu_new();
    menu_items = gtk_menu_item_new_with_label(_("Auto Detect"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)UNKNOWN);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("EUC JP (EUC)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)EUCJP);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("ISO-2022-JP (JIS)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)JIS);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Shift JIS (SJIS)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)SJIS);
    gtk_widget_show(menu_items);
 
    fs_code = UNKNOWN;
  
    /***********************/
    gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), load_menu);
    gtk_box_pack_end (GTK_BOX (GTK_FILE_SELECTION(file_sel)->main_vbox),
                      hbox, FALSE, FALSE, 5);
    gtk_widget_show(hbox);

	gtk_widget_show(file_sel);
  
    return;
}

void
save_cb(GtkWidget *widget, gpointer data)
{
    DEdit *doc;

#ifdef TRACE_FUNC
    printf("save_cb()\n");
#endif
  
    doc = get_doc_from_mdi_child();
    if(!doc) return;

    if(!doc->filename) {
        save_as_cb(widget, data);
        return;
    }

    fs_code = UNKNOWN;
    save_file(doc, doc->filename);

    return;
}

void
save_as_cb(GtkWidget *widget, gpointer data)
{
    DEdit *doc;
    gchar buf[PATH_MAX];
    GtkWidget *option_menu;
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *load_menu;
    GtkWidget *menu_items;

#ifdef TRACE_FUNC
    printf("save_as_cb()\n");
#endif

    doc = get_doc_from_mdi_child();
    if(!doc) return;

    file_sel = gtk_file_selection_new(_("DEdit: Save As"));
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_sel));

    if(doc->path){
        g_snprintf(buf, sizeof(buf), "%s/", doc->path);
        gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_sel),
                                        buf);
    }

    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC (save_file_ok_sel), doc);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC (cancel_cb), &file_sel);

    gtk_window_set_modal(GTK_WINDOW(file_sel), TRUE);

    hbox = gtk_hbox_new (FALSE, 1);
    gtk_container_border_width(GTK_CONTAINER(hbox), 0);
    
    label = gtk_label_new(_("Japanese Character Set:"));
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);
    
    option_menu = gtk_option_menu_new ();
    gtk_box_pack_start(GTK_BOX(hbox), option_menu, TRUE, TRUE, 0);
    gtk_widget_show(option_menu);
    
    load_menu = gtk_menu_new();
    menu_items = gtk_menu_item_new_with_label(_("Current Code"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)UNKNOWN);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("EUC JP (EUC)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)EUCJP);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(N_("ISO-2022-JP (JIS)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                              GTK_SIGNAL_FUNC(fs_menu_cb),
                              (gpointer)JIS);
    gtk_widget_show(menu_items);
    
    menu_items = gtk_menu_item_new_with_label(_("Shift JIS (SJIS)"));
    gtk_menu_append(GTK_MENU (load_menu), menu_items);
    gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate",
                            GTK_SIGNAL_FUNC(fs_menu_cb),
                            (gpointer)SJIS);
    gtk_widget_show(menu_items);

    fs_code = UNKNOWN;
  
    gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), load_menu);
    gtk_box_pack_end (GTK_BOX (GTK_FILE_SELECTION(file_sel)->main_vbox),
                      hbox, FALSE, FALSE, 5);
    gtk_widget_show(hbox);

    /***********************/

    gtk_widget_show(file_sel);

    return;
}

static void
save_file_ok_sel(GtkWidget *widget, gpointer data)
{
    gchar tmp[PATH_MAX];
    DEdit *doc = (DEdit *)data;
  
#ifdef TRACE_FUNC
    printf("save_file_ok_sel()\n");
#endif

    g_snprintf(tmp, sizeof(tmp), "%s",
               gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel)));

	gtk_widget_destroy(GTK_WIDGET(file_sel));
	file_sel = NULL;

    if(tmp){
        save_file(doc, tmp);
    }

    return;
}

static void
save_file(DEdit *doc, gchar *file_name)
{
    gchar *tmp;
    gint i;
    struct stat status;
    gzFile *gzfp = NULL;
    gboolean gzMode = FALSE; 
    FILE *fp = NULL;
    gchar buf[BUFSIZ];
    gchar *buffer;
    gchar *rbuffer = NULL;
    gchar backup[PATH_MAX];
    gboolean bkFlag = FALSE;
    
    struct stat st0, st1;

#ifdef TRACE_FUNC
    printf("save_file()\n");
#endif

    tmp = g_strdup(file_name);

	if(doc->filename) g_free(doc->filename);
	if(doc->path) g_free(doc->path);

    doc->filename = (gchar *)g_malloc(PATH_MAX);
    doc->path = (gchar *)g_malloc(PATH_MAX);
    if(!force_realpath(tmp, doc->filename, doc->path)){
        g_warning(_("DEdit: %s is invalid file or path name.\n"), tmp);
        return;
    }

    for(i = strlen(doc->filename);
        (i >= 0) && (doc->filename[i] != '/');
        i--)
        ;
    if(doc->filename[i] == '/')
        doc->pathend = &doc->filename[i+1];
    else
        doc->pathend = doc->filename;
  
    if(doc->modified)
        g_snprintf(buf, sizeof(buf), "*%s", doc->pathend);
    else
        g_snprintf(buf, sizeof(buf), "%s", doc->pathend);

    gnome_mdi_child_set_name(GNOME_MDI_CHILD(doc->child), buf);

    if(stat(doc->filename, &st0) != -1) {
        if(access(doc->filename, W_OK) == -1){
            g_warning(_("DEdit: %s: Permission denied\n"), doc->filename);
            return;
        }
        g_snprintf(backup, sizeof(backup), "%s~", doc->filename);
        unlink(backup);
		rename(doc->filename, backup);
        bkFlag = TRUE;
    }

    if(strlen(doc->filename) > 4) {
        if(!strncmp(doc->filename + strlen(doc->filename) - 3, ".gz", 3)) {
            if((gzfp = gzopen(doc->filename, "w")) == NULL) {
                /* FIXME: Why? */
                g_warning(_("DEdit: %s: Cannot open file to write.\n"), 
                          doc->filename);
                if(bkFlag) {
                    rename(backup, doc->filename);
                }
                return;
            } else {
                gzMode = TRUE;
            }
        }
    }

    if(!gzMode) {
        if((fp = fopen(doc->filename, "w")) == NULL) {
            /* FIXME: Why? */
            g_warning(_("DEdit: %s: Cannot open file to write.\n"), doc->filename);
            if(bkFlag) {
                rename(backup, doc->filename);
                unlink(backup);
            }
            return;
        }
    }
    
    buffer = g_strdup(gtk_editable_get_chars(GTK_EDITABLE(doc->text), 0, -1));
    
    switch(fs_code) {
    case UNKNOWN:
        /* Current */
        if(doc->code == JIS) { /* EUC to JIS */
            rbuffer = kanji_conv(buffer, "ISO-2022-JP", "EUC-JP");
        } else if (doc->code == SJIS) { /* EUC to SJIS */
            rbuffer = kanji_conv(buffer, "SJIS", "EUC-JP");
        } else /* EUC */
            rbuffer = g_strdup(buffer);
        break;
    case EUCJP:
        /* EUC */
        doc->code = EUCJP;
        rbuffer = g_strdup(buffer);
        break;
    case JIS:
        /* JIS */
        rbuffer = kanji_conv(buffer, "ISO-2022-JP", "EUC-JP");
        doc->code = JIS;
        break;
    case SJIS:
        /* SJIS */
        rbuffer = kanji_conv(buffer, "SJIS", "EUC-JP");
        doc->code = SJIS;
        break;
    default:
        /* Current */
        if(doc->code == JIS) { /* EUC to JIS*/
            rbuffer = kanji_conv(buffer, "ISO-2022-JP", "EUC-JP");
        } else if (doc->code == SJIS) { /* EUC to SJIS */
            rbuffer = kanji_conv(buffer, "SJIS", "EUC-JP");
        } else /* EUC */
            rbuffer = g_strdup(buffer);
        break;
    }

    if(gzMode) {
        gzprintf(gzfp, "%s", rbuffer);
        gzclose(gzfp);
    } else {
        fprintf(fp, "%s", rbuffer);
        fclose(fp);
    }

    if(bkFlag) {
        chmod(doc->filename, st0.st_mode);
    }

    g_free(buffer);
    g_free(rbuffer);
  
    if(doc->modified) {
        doc->modified_id = 
            gtk_signal_connect(GTK_OBJECT(doc->text),
                               "changed", 
                               GTK_SIGNAL_FUNC(text_changed_cb),
                               doc->child);
        doc->modified = FALSE;
    }
  
    doc->w_mode = TRUE;
    gtk_text_set_editable(GTK_TEXT(doc->text), doc->w_mode);

    gnome_mdi_child_set_name(GNOME_MDI_CHILD(doc->child), doc->pathend);  
    gtk_statusbar_push(GTK_STATUSBAR(doc->code_bar), 1, c_name[doc->code]);
    gtk_statusbar_push(GTK_STATUSBAR(doc->tit_bar), 1, doc->filename);
    gtk_widget_set_sensitive(GTK_WIDGET(doc->mod_bar), doc->modified);
  
    return;
}
