#ifndef _DEBORPHAN_H
#  define _DEBORPHAN_H

#ifdef LOW_MEM
#  include <stdio.h>
#endif

#ifdef HAVE_CONFIG_H /* define some defaults if necessary. */
#  include <config.h>
#else
#  define USE_XALLOC 1
#  define DEFAULT_NICE 1
#  define STATUS_FILE "/var/lib/dpkg/status"
#  define REG_FLAGS REG_ICASE
#  define PACKAGE "deborphan"
#  define VERSION "[unknown]"
#  define DEBFOSTER_KEEP "/etc/apt/keepers"
#endif

#ifndef KEEPER_FILE
#  define KEEPER_FILE "/var/lib/deborphan/keep"
#endif

/* strsep, ftruncate, and fileno, are the only remaining functions that
 * are not ANSI-compliant, afaik. These #ifdef's will help compilation
 * with -ansi -pedantic -Wall, but not linking.
 */
#ifndef _BSD_SOURCE
extern char *strsep(char **, const char *);
#endif

#ifndef _POSIX_SOURCE
#  include <stdio.h>
#  ifndef off_t
     typedef int off_t;
#  endif
int ftruncate(int, off_t);
extern int fileno __P ((FILE *__stream));
#endif

#ifndef HAVE_ERRNO_H
#  define errno 0
#endif

/* Faster than toupper. Less reliable too. */
#define upcase(c) ((c) & 32 ? (c) ^ 32 : (c))

typedef struct dep {
     char *name;
     unsigned int namehash;
} dep;

/* These arrays aren't exactly neat, but it seems they suffice. */
typedef struct pkg_info {
     dep self;
     int priority;
     dep provides[20];
     char *section;
     dep deps[128];
     int  install;
     int  hold;
     struct pkg_info *next;
} pkg_info;

/* Size of option array. */
#define NUM_OPTIONS 14

/* Make the options[] array easier to read. */
enum { 
     SHOW_DEPS = 0, 
     NICE_MODE, 
     ALL_PACKAGES, 
     PRIORITY, 
     SHOW_SECTION, 
     SHOW_PRIORITY,
     SEARCH,
     FORCE_HOLD,
     ADD_KEEP,
     DEL_KEEP,
     GUESS,
     NO_DEBFOSTER,
     GUESS_ONLY,
     LIST_KEEP
};

#define GUESS_DEV     1
#define GUESS_PERL    2
#define GUESS_SECTION 4
#define GUESS_DEBUG   8
#define GUESS_ALL     15

#define guess_chk(n) ((options[GUESS] & (n)) == (n))
#define guess_set(n) (options[GUESS] |= (n))
#define guess_clr(n) (options[GUESS] &= ~(n))

extern dep *keep;

/* pkginfo.c */
void init_pkg_regex();
void free_pkg_regex();
void get_pkg_info(const char *line, pkg_info *package);
void get_pkg_priority (const char *line, pkg_info *package);
void get_pkg_provides (const char *line, pkg_info *package);
void get_pkg_name (const char *line, pkg_info *package);
void get_pkg_status (const char *line, pkg_info *package);
void get_pkg_section (const char *line, pkg_info *package);
void get_pkg_deps (const char *line, pkg_info *package);
unsigned int is_library(pkg_info *package);


/* libdeps.c */
void check_lib_deps(pkg_info *package, pkg_info *current_pkg);

/* exit.c */
void error(int exit_status, int error_no, const char *format, ...);
void exit_help();
void exit_version();
void print_usage();

/* string.c */
int string_to_priority(const char *priority);
const char *priority_to_string(unsigned int priority);
inline void strstripchr(char *s, int c);
inline unsigned int strhash(const char *line);
inline unsigned int pkgcmp(const dep a, const dep b);

/* keep.c */
dep *readkeep(const char *kfile);
int mustkeep(dep d);
int delkeep(const char *kfile, char **del);
int addkeep(const char *kfile, char **add);
dep *mergekeep(const dep *a, const dep *b);
void listkeepall(const char *kfile);
int listkeep(const char *kfile);
char **parseargs(int argind, int argc, char **argv);
unsigned int hasduplicate(char **list);
int pkggrep(const char *sfile, char **pkgnames);


/* file.c */
#ifdef LOW_MEM
FILE *statusopen(const char *file);
char *nextline(FILE **fp);
#else
char *nextline(char **s);
char *statusopen(const char *file);
#endif

/* xalloc.c */
#ifndef USE_XALLOC
#  define xmalloc malloc
#  define xcalloc calloc
#  define xrealloc realloc
#  define xmem_error
#endif /* USE_XALLOC */

#ifdef HAVE_GETOPT_LONG
#  define _get_opt(argc, argv, optstring, longopts, longindex) \
           getopt_long((argc), (argv), (optstring), (longopts), (longindex))
#else
#  define _get_opt(argc, argv, optstring, longopts, longindex) \
           getopt((argc), (argv), (optstring))
#endif

#ifdef ENABLE_NLS
#  undef _
#  define _(string) gettext(string)
#else
#  undef _
#  define _(string) (string)
#  undef setlocale
#  define setlocale(a, b)
#  undef bindtextdomain
#  define bindtextdomain(a, b)
#  undef textdomain
#  define textdomain(a)
#endif /* ENABLE_NLS */

#endif /* ! _DEBORPHAN_H */
