;;; skk-tankan.el --- SKK ñѴץ
;; Copyright (C) 2003 YAGI Tatsuya <ynyaaa@ybb.ne.jp>

;; Author: YAGI Tatsuya <ynyaaa@ybb.ne.jp>
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: $Id: skk-tankan.el,v 1.2 2003/03/30 02:08:56 minakaji Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2003/03/30 02:08:56 $

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.

;; Daredevil SKK is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Ȥ
;;
;; ɤߤκǸˡɤߤΰȤ @ ϤƤѴȡ
;; ʸΤߤʤ˹ʤǡ
;; ǥȤƤѴޤ
;;
;; ˡ
;;
;; .skk ˤϼͤʤȤ񤤤Ƥޤ
;;
;; (require 'skk-tankan)
;; (setq skk-tankan-search-key ?@) ;; ñΥ @ ˤ(ǥե)
;;
;; ;; @ ϤǤ褦ˤ
;; (setq skk-rom-kana-rule-list
;;       (append skk-rom-kana-rule-list
;;	         '(("@" nil "@"))))
;; ;; annotation ȤƲɽ
;; (setq skk-show-annotation t)
;; ;; ñϤϳؽоݤϤ
;; (setq skk-search-excluding-word-pattern-function
;;       (lambda (kakutei-word)
;;         (string-match (format "%c$" (regexp-quote skk-tankan-search-key))
;;                       skk-henkan-key)))
;; ;; λ
;; ;; skk-search-prog-list ˻Ǥ (function . args) Ф
;; ;; (skk-tankan-search 'function . args) ꤹ
;; (add-to-list 'skk-search-prog-list
;;              '(skk-tankan-search 'skk-search-jisyo-file
;;                                  skk-large-jisyo 10000))
;;
;; ;; ʸ CHAR  ANNOTATION (ʸ)ѹ
;; ;; (skk-tankan-set-char-annotation CHAR ANNOTATION)
;;
;; ;; 󤷤͸(ȲʳΥǡݻޤ)
;; ;; (setq skk-tankan-annotation-table nil)

;;; Code:
(require 'skk)

(defvar skk-tankan-search-key ?@)

;;; ʸʸФ (  ) ֤ؿ alist
;; ˤбǽʤ褦ѿˤƤ
(defvar skk-tankan-get-char-data-functions
  '((japanese-jisx0208 . skk-tankan-get-char-data-0213-1)
    (japanese-jisx0213-1 . skk-tankan-get-char-data-0213-1)
    (japanese-jisx0213-2 . skk-tankan-get-char-data-0213-2)
    ))

;; emacs19 ˤ char-table ʤäȻפΤ
;; skk-tankan-(get|set)-char-annotation ȹ碌Ŭ˽񤭴Ʋ
(put 'annotation 'char-table-extra-slots 0)
(defvar skk-tankan-annotation-table (make-char-table 'annotation nil))

;;; ֹɽʸѴ뤿
(defconst skk-tankan-radical-vector
  (let ((v (string-to-vector "\
\
ЦШЭ\
еѹȬұҸҹҾ\
ڻͼ֥߹ʶҴ׮װ׵\
ͼڽʸͶ۩ڷӻҲ\
̱ɥ黮̷м㼲ӷΩ\
ƻӱϷмü걱԰\
ѸëƦ츳­ȼֿä͸Τ\
Ĺ𲱫\
첻\
Ϲ\
Ļü\
й\
Ť\
ɡ\
\
ζ\
\
"))
	(i 0))
    (while (< i (length v))
      (aset v i (char-to-string (aref v i)))
      (setq i (1+ i)))
    ;; modify char if japanese-jisx0213-1 is available
    (when (charsetp 'japanese-jisx0213-1)
      (mapcar (lambda (cell)
		(aset v (car cell)
		      (char-to-string
		       (make-char 'japanese-jisx0213-1
				  (+ 32 (nth 1 cell)) (+ 32 (nth 2 cell))))))
	      '((002 14 4) (104 88 44) (114 89 36) (162 92 51)
		(201 94 81) (203 94 82))))
    v))

;;; бʬβɽ
(defconst skk-tankan-stroke-for-radical-vector
  [0 1 1 1 1 1 1
     2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2
     3 3 3 3 3 3 3 3 3 3 3 3 3 (3 3 4) 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3
     (4 4 4 3) 4 4 (3 4 4 3) 4 4 4 4 4 4 (4 5) 4 4 4 4 4 4
     (4 4 5) 4 4 4 4 4 4 (4 5 3 3) 4 4 4 4 (3 4) 4 (5 4) 4 (4 4 3)
     5 (5 4 4) 6 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 (5 5 5 4) (4 5) 5 5 5
     6 6 6 6 (4 5 5 6) 6 6 (4 6) 6 6 6 (5 6) (6 4 4 4)
     6 6 6 (6 7) 6 (6 7) 6 6 6 (6 4 3 3) 6 6 6 6 (4 6 6 5) 6
     7 7 7 7 7 7 7 7 7 (6 7) 7 7 7 7 7 (7 3 4) (7 3) 7 7 7
     8 (8 7) 8 (8 3 3) 8 8 8 8 8
     9 9 10 9 9 9 9 9 (9 9 8 9) 9 9
     10 10 10 10 10 10 10 10
     11 (7 11 11 11) 11 (9 11 11 11) (7 11) 11
     (11 12) 12 (11 12 12) 12 13 13 13 (8 13 13)
     14 14 (12 12 15 15) (10 16) (11 16) 17])

;;; japanese-jisx0208, japanese-jisx0213-1 Ѥ󡦲ǡ
;; 1-14-1  2Byte ĻѤƤ
;; 1st byte = radical number
;; 2nd byte = (sub radical index) << 6 | strokes in radical
(defconst skk-tankan-radical-stroke-table-0213-1 "\
\011\210\001\003\001\005\002\000\002\003\002\003\007\001\011\203\
\011\204\011\204\011\204\011\204\011\205\011\205\011\205\011\205\
\011\205\011\206\011\206\011\206\011\206\011\206\011\206\011\207\
\011\207\011\207\011\210\011\210\011\210\011\210\011\210\011\210\
\011\210\011\211\011\211\011\212\011\213\011\215\011\214\011\214\
\011\214\011\214\011\215\011\215\011\216\011\221\012\004\012\005\
\012\005\012\007\014\005\016\005\017\107\017\110\017\016\020\001\
\020\106\022\000\022\003\022\104\022\004\022\107\022\110\022\110\
\022\116\023\207\023\007\023\210\023\210\023\211\023\212\023\213\
\023\015\024\002\024\002\024\003\026\003\030\006\031\003\031\005\
\032\007\033\006\033\010\033\014\036\303\036\304\036\304\036\305\
\036\305\036\305\036\305\036\305\036\305\036\306\
\036\306\036\306\036\007\036\307\036\310\036\310\036\310\036\310\
\036\311\036\011\036\311\036\311\036\311\036\312\036\313\036\313\
\036\313\036\314\036\314\036\314\036\315\036\115\036\315\036\315\
\036\315\036\317\036\017\036\320\036\320\036\221\036\323\036\023\
\037\010\040\001\040\001\040\203\040\203\040\203\040\205\040\205\
\040\205\040\206\040\207\040\107\040\207\040\207\040\207\040\207\
\040\210\040\210\040\210\040\010\040\110\040\210\040\212\040\212\
\040\212\040\213\040\213\040\213\040\214\040\114\040\214\040\215\
\040\215\040\216\040\216\040\220\040\220\040\225\043\005\043\024\
\045\110\045\014\046\204\046\204\046\204\046\205\046\205\046\206\
\046\207\046\207\046\210\046\210\046\211\046\211\046\211\046\211\
\046\211\046\212\046\215\046\215\046\216\022\110\
\007\005\036\307\046\206\252\205\036\006\075\011\100\307\046\206\
\242\207\214\311\214\306\163\313\075\107\100\311\125\311\110\002\
\214\312\214\304\303\210\113\307\040\002\104\012\100\303\050\005\
\046\205\216\303\270\305\170\206\170\210\303\205\076\004\167\106\
\221\306\050\003\065\010\100\306\110\311\113\206\251\011\261\106\
\113\103\011\003\011\204\011\205\011\206\011\212\037\004\045\003\
\046\105\046\006\051\210\075\310\075\111\075\113\110\104\113\310\
\126\305\146\104\146\106\163\306\170\210\170\212\202\205\214\310\
\221\100\225\211\242\112\242\114\027\005\007\002\010\004\040\210\
\202\204\243\106\160\214\001\000\041\004\125\312\242\110\163\311\
\214\306\214\303\303\212\012\002\032\004\036\306\036\107\037\003\
\046\206\071\101\270\204\125\310\202\105\214\313\
\252\207\252\210\252\213\264\212\036\303\036\202\050\003\126\306\
\174\000\242\203\255\000\032\003\304\307\164\013\001\003\160\210\
\206\000\125\311\036\313\036\307\113\025\214\313\303\213\046\206\
\033\014\125\307\141\000\251\004\036\314\007\002\242\111\255\104\
\214\306\270\306\035\016\036\011\046\116\073\014\110\305\111\002\
\113\205\125\001\125\305\125\306\140\210\154\004\163\013\161\013\
\214\305\220\012\225\205\247\207\125\310\150\004\154\005\273\204\
\075\307\225\210\234\105\251\007\113\312\033\014\015\002\037\012\
\040\211\045\105\050\007\066\005\075\105\100\310\100\311\125\305\
\125\313\126\104\126\207\126\211\126\314\136\212\170\211\213\015\
\214\305\214\315\242\112\247\205\304\205\040\212\106\104\125\303\
\144\007\021\003\045\002\045\211\074\005\075\003\
\100\305\110\304\113\313\114\104\117\104\140\100\174\204\221\315\
\304\205\304\304\311\000\056\005\125\304\214\307\011\215\054\006\
\075\315\202\315\113\307\135\203\005\000\011\210\032\007\075\106\
\125\311\163\313\264\000\001\002\025\002\011\204\011\205\011\205\
\011\206\011\206\023\003\036\002\036\013\043\007\046\212\050\007\
\050\013\163\304\110\311\113\204\113\205\114\112\125\305\126\000\
\140\205\161\311\163\000\163\312\166\010\214\304\214\305\214\305\
\214\307\214\307\214\310\216\311\225\210\036\312\232\104\242\205\
\242\111\255\111\216\304\011\207\056\307\076\003\134\100\146\003\
\203\102\214\305\216\307\232\105\254\205\270\207\273\105\011\102\
\011\104\224\106\037\003\040\212\040\215\066\006\075\304\075\305\
\075\306\075\306\075\315\076\003\100\305\102\203\
\302\204\110\307\113\307\125\306\126\002\146\104\152\004\170\206\
\214\304\216\215\251\004\252\211\232\000\020\012\023\206\044\002\
\036\306\050\007\056\110\075\312\113\312\125\310\160\210\214\312\
\220\006\225\206\247\212\274\006\125\307\272\013\216\306\040\206\
\113\305\216\305\247\204\022\114\036\316\036\203\065\013\100\305\
\100\314\113\306\113\306\117\107\136\215\160\212\163\315\223\105\
\224\000\233\007\237\106\243\110\251\006\252\212\261\000\047\105\
\056\205\113\211\265\111\265\111\100\310\166\005\113\313\113\315\
\113\307\303\211\125\314\022\112\036\310\075\306\100\306\125\306\
\125\310\125\312\214\311\221\310\237\112\001\004\303\213\036\302\
\113\307\113\312\261\105\113\306\012\011\164\014\214\312\247\002\
\247\212\036\314\304\305\113\306\214\305\214\311\
\167\006\022\102\214\304\142\000\005\012\011\206\016\007\050\011\
\022\103\023\211\023\213\061\006\036\311\040\211\046\006\050\004\
\050\005\050\012\063\000\063\012\075\107\075\111\075\313\075\315\
\100\311\102\210\113\305\113\306\113\310\114\110\114\113\125\303\
\125\312\125\314\125\313\140\215\143\000\154\011\155\204\166\003\
\166\010\166\014\170\211\171\000\174\012\202\303\211\016\214\307\
\223\213\225\210\232\104\242\115\247\216\251\004\251\004\251\006\
\252\207\262\010\270\210\207\012\003\002\036\204\056\105\056\121\
\140\204\150\014\155\306\056\105\174\011\232\014\254\004\265\104\
\265\111\265\112\011\104\011\204\032\004\036\211\036\114\040\110\
\045\105\046\214\050\010\056\304\062\104\064\011\075\103\100\311\
\113\302\106\112\107\105\112\010\113\310\113\211\
\113\314\062\007\117\113\124\002\125\304\146\012\161\304\047\105\
\163\307\170\203\074\016\223\204\225\203\232\105\234\103\237\102\
\237\010\270\202\273\210\302\000\325\000\011\211\011\215\046\204\
\050\005\076\113\100\304\100\316\114\110\135\215\147\011\161\204\
\173\107\216\315\225\210\225\215\100\310\214\310\261\110\036\203\
\036\303\036\311\113\306\113\314\225\206\160\205\113\304\312\000\
\032\005\050\006\202\307\215\104\242\106\001\004\004\002\011\202\
\011\204\035\001\036\303\050\007\071\000\075\105\102\207\113\302\
\125\102\125\304\125\305\126\103\140\207\164\002\164\012\166\004\
\170\203\170\203\170\206\110\001\135\000\034\003\054\005\060\002\
\100\305\100\305\100\206\125\211\215\105\225\204\235\205\247\210\
\125\313\161\114\303\000\010\005\010\006\010\006\
\011\206\011\206\011\214\012\004\165\017\014\004\021\002\030\006\
\026\004\032\012\036\303\036\011\040\213\056\306\071\110\071\115\
\075\305\075\106\075\206\100\306\102\207\113\314\125\305\136\204\
\136\206\157\114\202\306\202\206\206\111\214\314\243\110\247\213\
\264\113\270\115\273\114\011\204\017\116\012\006\110\310\113\011\
\054\004\111\002\113\310\140\000\113\306\167\203\011\213\023\212\
\040\204\062\000\247\210\105\000\114\104\114\110\140\110\161\110\
\162\010\166\006\170\110\214\304\214\310\221\304\221\315\225\212\
\242\104\247\000\036\304\247\206\005\001\011\210\036\002\027\002\
\136\205\140\203\157\105\214\305\236\004\273\204\273\205\273\205\
\014\006\075\111\215\107\036\311\164\003\011\211\050\011\242\111\
\252\211\002\006\113\317\247\203\054\007\054\005\
\100\310\164\010\125\004\261\104\237\017\164\011\126\312\252\211\
\167\103\113\206\170\215\113\206\247\211\023\015\036\204\214\315\
\225\203\173\007\237\002\243\107\031\006\221\105\161\203\011\207\
\011\213\022\104\012\003\036\210\040\103\140\206\040\106\045\206\
\073\004\074\005\075\106\075\013\075\113\075\114\100\310\100\312\
\102\210\110\110\113\306\125\310\146\306\163\312\170\101\170\205\
\170\207\170\113\172\210\214\305\214\306\216\205\225\202\225\206\
\225\114\237\105\265\105\304\310\214\304\242\104\303\210\022\115\
\076\110\100\213\125\315\252\212\113\306\011\213\114\000\125\304\
\125\314\164\000\170\206\217\000\225\204\112\000\011\204\011\210\
\011\210\011\211\014\010\022\006\022\110\036\311\037\011\040\110\
\046\212\066\006\075\114\075\120\100\206\100\310\
\113\310\113\313\135\107\136\000\136\111\160\204\160\207\170\207\
\155\004\202\104\223\000\225\212\232\110\237\103\242\112\247\211\
\252\210\265\111\273\210\305\110\012\002\033\010\033\017\064\001\
\071\105\125\311\125\312\137\000\140\207\170\205\211\005\225\000\
\225\211\252\206\004\004\011\210\036\202\036\305\037\005\046\205\
\047\206\061\000\065\007\071\106\077\000\102\205\113\305\125\311\
\136\206\167\211\221\306\202\304\202\105\214\311\215\102\225\206\
\235\206\247\205\254\004\265\114\317\000\007\002\007\002\011\204\
\030\002\036\104\036\204\046\207\074\006\074\011\075\307\113\307\
\113\314\140\211\160\110\225\207\225\207\225\215\244\211\005\002\
\303\207\010\004\011\206\011\207\011\210\011\210\012\004\014\002\
\023\203\023\206\024\002\033\007\036\000\036\003\
\036\003\036\311\040\204\040\206\046\203\047\201\047\104\050\004\
\060\000\060\002\061\006\063\005\065\002\065\005\065\010\071\102\
\075\306\075\311\100\304\100\305\100\310\102\203\110\104\110\106\
\111\003\113\304\113\306\113\307\113\312\125\303\125\306\125\307\
\125\311\125\312\146\000\152\104\160\207\163\312\167\213\170\203\
\170\204\170\206\170\210\177\004\175\002\202\204\202\304\202\310\
\202\212\211\004\214\306\220\000\220\012\225\212\232\103\232\212\
\243\106\244\207\247\205\160\205\247\210\251\006\252\207\265\103\
\272\000\275\000\304\306\022\110\023\205\036\102\036\203\040\216\
\100\306\125\316\230\107\237\016\307\010\012\005\022\106\036\204\
\037\005\163\011\244\207\304\307\313\000\136\112\125\313\202\311\
\142\214\075\104\075\310\274\000\136\205\242\102\
\115\002\265\102\011\102\037\004\040\205\040\115\046\210\075\306\
\075\115\110\204\110\104\113\306\113\307\125\310\150\006\170\205\
\212\000\302\104\007\006\011\205\035\001\036\307\056\312\060\002\
\060\007\113\105\125\304\140\212\160\204\225\205\247\212\221\107\
\040\004\065\007\100\307\011\213\011\213\015\004\111\010\036\006\
\040\112\046\105\050\007\073\010\100\000\100\310\113\006\115\011\
\125\310\126\103\127\104\135\010\160\204\160\106\161\106\103\007\
\170\205\214\310\221\106\237\006\252\213\022\110\040\003\113\303\
\172\210\232\203\017\105\040\204\252\204\040\211\113\312\202\204\
\036\306\056\310\040\210\160\210\304\215\011\205\022\107\036\305\
\100\312\110\305\112\006\113\305\164\005\166\006\170\104\247\210\
\113\306\303\206\166\005\025\011\015\003\022\106\
\050\013\100\306\100\314\100\316\113\301\117\106\214\316\254\206\
\152\106\303\210\100\307\247\210\303\206\154\000\110\306\001\002\
\011\112\034\006\056\000\075\310\100\314\102\210\113\306\126\215\
\140\205\144\006\166\010\170\116\216\204\225\217\232\110\244\207\
\270\107\105\007\110\213\116\106\011\203\011\203\011\205\011\206\
\022\106\036\202\036\002\036\012\037\002\041\000\046\205\046\205\
\046\106\047\000\054\006\062\102\062\007\075\103\075\105\100\306\
\101\000\047\204\105\010\106\105\110\202\113\304\115\000\116\002\
\123\000\136\212\161\304\163\302\170\000\170\204\170\106\202\304\
\202\306\205\000\223\204\225\205\225\206\225\206\225\207\225\211\
\232\106\232\210\254\206\270\205\323\000\006\007\011\205\011\206\
\012\005\047\103\051\103\075\111\100\306\110\306\
\114\102\125\311\125\305\131\012\140\016\150\006\160\211\161\000\
\176\000\200\000\204\000\214\312\240\006\125\303\306\100\070\003\
\225\214\304\305\166\002\237\105\050\004\255\103\001\001\036\302\
\040\010\045\002\046\212\050\006\075\107\125\311\125\313\150\005\
\232\110\050\005\214\313\166\013\011\211\113\206\214\303\054\011\
\214\314\170\212\011\106\016\003\051\207\100\310\233\004\104\007\
\126\310\161\303\170\204\175\004\225\212\237\000\242\113\216\305\
\243\105\011\210\024\001\054\001\113\303\126\203\127\115\244\203\
\245\004\247\210\214\305\050\010\071\007\075\110\003\004\035\006\
\050\003\100\100\113\002\116\106\136\206\140\206\163\311\202\311\
\234\110\244\003\271\000\011\216\035\006\036\305\051\104\100\310\
\113\314\170\210\255\106\037\002\035\003\036\005\
\050\005\053\011\057\103\011\210\075\111\100\306\125\306\163\102\
\163\304\170\205\170\213\174\105\204\003\211\000\214\312\217\006\
\221\120\225\120\235\214\237\111\242\110\244\102\244\206\254\104\
\244\212\011\202\011\205\012\004\030\000\074\007\076\002\113\205\
\125\302\125\310\136\114\170\212\246\002\247\206\035\006\044\003\
\050\010\125\310\161\305\170\213\201\006\040\113\126\313\021\003\
\220\005\242\105\011\207\056\307\110\205\155\315\165\107\210\106\
\273\207\017\110\074\011\110\002\113\311\116\106\125\310\125\212\
\125\314\155\004\170\204\057\003\242\114\244\210\265\103\020\003\
\022\005\077\004\110\110\110\315\125\310\065\010\170\210\172\210\
\111\006\214\316\214\320\225\210\023\205\035\007\046\000\065\004\
\074\007\075\106\247\207\252\207\011\213\011\217\
\023\012\026\004\030\002\036\202\036\307\036\010\036\310\036\013\
\045\212\046\105\046\210\050\007\051\007\052\000\052\001\052\005\
\065\003\065\004\065\014\073\013\100\104\100\304\100\305\100\210\
\100\310\110\104\110\104\110\305\110\110\113\304\113\307\113\313\
\113\314\125\305\125\307\125\310\125\311\126\210\126\310\126\311\
\150\005\155\204\160\207\160\214\161\306\163\305\165\006\166\004\
\167\206\170\205\202\203\214\310\214\312\214\314\220\011\221\110\
\225\204\225\205\225\205\225\206\230\105\232\110\244\112\247\205\
\247\211\247\214\252\213\261\107\001\002\001\002\001\005\004\010\
\016\002\022\111\040\206\040\211\040\215\046\215\062\110\075\310\
\100\317\113\203\113\303\125\306\136\103\146\107\163\315\214\312\
\225\215\244\215\247\210\036\314\040\210\270\205\
\100\306\113\310\116\110\126\215\170\214\200\214\213\000\224\106\
\270\000\216\011\241\003\054\002\011\205\011\207\011\207\036\207\
\046\207\050\012\050\014\075\000\075\312\100\307\105\011\110\206\
\113\110\113\312\125\307\125\310\146\000\150\005\155\005\161\305\
\163\205\170\205\203\000\214\304\214\315\223\211\225\205\236\000\
\240\000\242\110\247\202\255\107\011\000\011\202\022\001\040\013\
\041\001\051\111\143\004\054\003\202\210\225\203\242\103\252\207\
\261\103\166\005\225\210\265\103\244\205\037\004\033\012\242\207\
\036\304\040\005\062\006\100\310\125\000\126\204\155\310\167\204\
\174\110\221\204\242\111\244\204\247\210\247\210\252\211\140\211\
\274\011\056\110\056\112\102\211\113\304\234\112\254\212\100\310\
\113\303\113\310\214\310\265\105\254\003\221\310\
\125\314\100\313\051\000\001\004\125\320\146\005\110\105\017\110\
\022\106\023\113\046\205\074\005\075\305\076\002\102\205\102\114\
\110\105\110\310\113\310\113\306\115\001\125\310\135\205\144\000\
\154\006\167\210\200\007\041\004\221\110\222\000\225\206\225\107\
\225\210\242\107\244\211\256\000\256\006\103\004\163\307\202\306\
\254\102\062\007\075\310\076\007\105\001\110\204\113\304\160\000\
\163\313\166\016\170\213\202\206\232\104\233\000\235\206\235\213\
\160\211\022\002\100\305\100\310\100\312\100\304\225\204\164\004\
\166\007\225\207\255\103\170\206\207\000\216\311\011\203\012\004\
\030\001\031\003\050\006\051\106\052\003\057\100\076\111\077\006\
\100\314\113\306\113\306\125\005\125\306\125\306\125\206\125\314\
\126\311\126\212\106\107\164\004\166\011\170\211\
\170\213\173\107\202\311\210\000\211\005\214\315\225\206\232\206\
\235\206\242\114\242\114\247\206\247\206\251\002\303\206\022\107\
\036\211\125\313\126\310\013\004\161\311\170\214\202\314\167\211\
\036\314\040\112\056\305\100\310\111\010\111\007\113\111\136\205\
\147\107\147\107\160\215\161\305\163\305\167\205\170\104\170\205\
\214\320\225\205\252\205\242\212\320\100\011\213\022\112\035\002\
\035\020\011\110\036\011\041\003\045\006\131\007\050\004\054\013\
\026\003\075\110\075\111\100\307\100\310\100\307\100\310\100\315\
\110\102\111\007\113\207\113\312\113\313\125\313\126\215\006\005\
\150\007\155\004\164\006\167\213\170\210\170\210\200\210\214\306\
\214\306\214\311\214\312\214\320\221\106\234\100\242\106\242\113\
\247\212\255\111\273\210\011\214\040\213\075\313\
\202\316\214\313\232\213\242\107\011\207\011\211\022\107\032\005\
\075\106\100\307\113\003\125\311\235\000\242\107\011\207\054\011\
\232\206\106\107\170\207\030\006\221\305\014\006\100\311\047\003\
\047\207\051\111\100\312\113\303\242\212\011\203\044\003\045\001\
\125\304\225\205\036\310\040\111\046\104\075\311\100\302\113\305\
\211\005\113\311\252\205\273\204\273\211\011\205\040\210\051\204\
\176\003\056\205\062\107\074\006\075\105\075\112\076\015\111\010\
\125\105\125\312\202\305\202\312\214\305\221\105\232\105\242\106\
\242\110\252\211\313\005\303\210\011\203\036\202\045\000\166\005\
\244\211\265\011\304\115\125\312\125\320\030\006\036\307\050\003\
\100\303\100\304\100\305\125\304\125\316\140\207\225\203\247\215\
\125\315\225\210\214\306\020\103\216\307\036\102\
\036\302\011\205\242\111\241\000\045\113\202\307\014\012\165\010\
\242\203\113\310\226\000\136\207\303\213\113\314\225\210\003\003\
\030\007\036\312\040\205\100\305\100\310\110\101\114\113\125\310\
\125\311\126\005\157\107\165\111\166\011\170\210\200\204\202\305\
\216\205\225\210\247\211\037\003\040\215\071\111\105\007\110\311\
\113\315\117\105\146\102\225\210\011\210\157\103\040\203\071\103\
\075\006\110\210\125\303\150\010\163\310\172\210\205\004\216\310\
\242\111\273\203\166\012\146\205\166\000\166\006\214\312\242\107\
\163\305\164\006\214\306\046\213\155\207\002\003\011\204\050\005\
\075\104\100\305\110\005\113\305\125\305\216\000\221\005\225\205\
\244\203\247\207\273\205\113\313\125\320\136\210\214\305\214\310\
\232\205\001\001\012\004\017\110\036\311\050\020\
\062\205\062\210\065\002\071\001\071\110\073\010\074\013\075\116\
\100\306\110\012\112\010\125\314\133\011\146\302\155\306\200\213\
\202\310\202\311\216\311\225\210\225\211\234\105\235\206\247\206\
\250\000\265\102\304\100\023\207\100\307\155\003\112\106\125\304\
\140\205\232\106\247\212\252\210\125\306\040\114\113\310\113\312\
\242\106\247\212\150\007\242\107\040\211\113\305\100\310\113\313\
\011\205\125\313\113\305\242\202\214\313\170\210\247\211\113\311\
\125\314\040\205\041\010\046\216\170\205\127\000\036\103\247\203\
\304\312\010\007\011\205\011\211\011\211\022\107\232\102\036\104\
\040\211\050\005\062\106\065\005\065\007\066\004\071\004\075\307\
\100\305\100\307\100\311\113\307\125\302\160\210\161\311\163\307\
\170\211\211\007\225\202\225\211\235\211\242\107\
\243\105\243\114\247\202\316\000\125\305\100\313\100\316\102\213\
\125\313\152\203\166\005\242\113\247\213\125\312\036\207\074\014\
\100\314\237\114\242\105\247\205\014\006\040\212\045\201\054\007\
\065\005\125\310\170\217\143\006\232\205\237\104\265\112\126\305\
\011\204\117\111\125\315\146\000\255\105\012\005\036\303\040\211\
\040\112\046\205\054\011\074\007\104\000\113\303\125\311\151\007\
\214\311\232\211\242\107\243\110\247\211\160\205\160\205\023\105\
\065\006\040\000\046\202\075\105\011\210\012\010\017\003\017\110\
\022\000\036\007\040\211\040\212\045\107\050\005\056\207\056\313\
\075\310\100\304\100\311\113\004\113\306\113\307\113\310\154\006\
\125\310\125\311\125\307\126\202\126\214\072\003\150\007\161\307\
\166\006\166\006\166\006\167\212\170\206\022\106\
\214\311\214\314\214\317\225\203\225\012\227\000\235\210\242\106\
\242\107\247\214\252\210\265\107\273\012\251\012\011\213\023\211\
\036\003\040\110\051\114\075\314\100\314\125\306\155\314\165\007\
\202\306\214\310\242\111\247\206\056\306\304\304\027\010\074\010\
\074\013\125\307\135\206\155\210\163\102\166\012\120\004\136\206\
\225\207\113\305\113\314\021\003\164\003\113\311\054\005\304\203\
\214\305\050\010\244\000\125\320\036\315\055\001\075\310\102\210\
\125\304\230\004\242\211\265\104\036\204\110\114\247\204\045\105\
\243\104\015\002\004\004\020\104\214\315\225\212\125\323\100\310\
\247\211\113\311\273\203\170\211\146\310\030\007\113\311\237\104\
\254\212\125\303\007\000\054\002\070\003\242\105\024\002\232\207\
\202\000\216\303\030\002\110\000\005\107\013\000\
\046\203\054\004\263\003\011\204\046\204\075\103\225\207\125\316\
\161\216\161\305\050\013\214\311\136\210\126\313\063\003\075\104\
\100\310\100\314\126\214\167\205\004\001\066\006\004\002\040\110\
\036\017\075\307\125\315\170\204\202\106\202\307\202\315\241\006\
\223\205\216\204\061\101\100\304\100\314\222\215\113\304\125\305\
\125\306\140\110\160\205\046\110\172\212\214\304\273\000\011\210\
\065\011\100\305\100\310\102\207\113\304\154\004\133\010\202\205\
\202\305\237\010\244\203\011\210\040\210\046\211\113\306\113\311\
\126\211\136\207\232\105\041\004\232\210\252\210\242\207\216\311\
\163\305\157\104\214\311\011\205\022\110\030\012\100\305\113\305\
\125\305\152\000\166\010\167\205\211\005\214\315\242\105\110\317\
\125\312\126\217\170\212\214\307\273\204\307\000\
\021\006\166\011\160\207\166\011\201\110\166\006\113\320\062\214\
\202\302\146\004\146\205\014\000\247\205\125\311\151\004\244\211\
\276\004\011\204\172\211\100\304\166\006\251\006\304\302\036\315\
\040\212\216\306\254\102\011\205\022\105\030\003\035\002\035\007\
\062\203\100\312\103\010\113\304\125\302\125\303\133\004\136\202\
\140\206\146\305\170\112\211\004\214\317\232\204\166\011\245\000\
\126\211\265\104\270\204\100\307\110\310\146\207\154\012\160\112\
\214\314\216\206\026\010\030\007\036\204\046\203\065\004\074\005\
\075\110\077\010\100\304\100\305\103\010\121\000\125\305\150\005\
\153\000\160\211\163\305\170\210\172\212\202\304\221\305\225\210\
\232\105\242\115\257\000\267\000\113\313\166\015\011\212\054\004\
\074\012\113\304\121\005\140\110\155\004\173\103\
\321\000\113\305\163\310\027\002\147\000\276\006\073\006\202\313\
\214\310\202\303\071\111\075\001\146\106\166\006\242\211\113\306\
\046\206\046\211\170\204\152\001\225\213\011\210\073\010\113\313\
\125\001\125\313\141\013\161\106\221\004\225\205\231\003\065\014\
\100\310\150\005\163\304\214\305\247\210\247\207\214\312\216\306\
\303\212\036\106\073\010\103\010\125\307\125\320\232\104\232\110\
\265\110\102\206\142\206\001\003\011\203\040\210\045\001\046\210\
\050\011\016\011\062\102\065\005\075\305\100\304\102\213\105\004\
\110\210\125\307\130\000\166\005\202\010\202\113\214\304\225\214\
\232\102\232\210\234\102\252\000\252\205\011\206\100\314\115\004\
\210\110\214\311\214\314\243\110\051\206\113\311\266\000\214\311\
\214\315\011\204\022\111\074\011\062\211\112\104\
\161\311\202\311\221\311\222\214\125\311\071\002\100\302\125\305\
\011\202\135\204\303\205\022\002\036\304\036\314\040\214\075\314\
\100\304\126\110\045\115\167\204\167\013\170\204\255\104\103\000\
\200\010\001\004\011\206\014\005\040\211\062\114\063\002\067\014\
\113\305\001\007\214\314\251\003\252\207\167\000\265\000\011\215\
\040\115\150\015\160\111\022\105\155\214\214\313\166\010\011\211\
\042\006\133\000\166\011\170\211\242\102\242\104\242\111\011\207\
\023\010\046\207\067\002\261\111\011\207\011\115\247\207\037\007\
\100\307\115\004\145\002\221\307\237\107\163\312\023\112\040\112\
\075\212\076\001\110\212\120\001\166\015\214\310\011\210\011\210\
\024\003\036\104\040\011\045\005\050\005\056\307\056\107\056\110\
\065\005\100\305\100\310\102\204\106\000\112\104\
\125\305\125\305\126\307\160\205\170\212\202\305\214\304\214\310\
\214\313\216\307\221\211\225\204\227\106\243\104\247\207\270\205\
\304\103\304\310\004\003\010\001\011\212\022\110\040\204\046\204\
\062\211\075\103\075\303\077\004\110\113\112\007\113\205\113\310\
\155\204\170\204\202\304\202\314\225\211\231\007\232\105\247\206\
\252\204\036\304\265\106\025\003\011\214\031\000\040\113\100\314\
\113\302\135\204\155\310\163\313\247\203\023\207\125\304\116\105\
\040\210\062\212\045\105\113\001\174\314\020\001\154\004\100\113\
\160\013\302\013\310\000\040\207\046\205\110\305\113\304\120\002\
\036\307\113\312\062\112\202\312\113\304\303\206\113\305\303\214\
\113\307\010\004\011\207\035\000\100\305\113\001\125\305\242\203\
\011\206\170\014\310\007\001\002\075\313\125\311\
\125\313\214\313\036\305\113\001\302\205\061\100\166\010\056\305\
\050\010\216\210\125\311\214\312\163\310\202\306\046\204\167\204\
\123\001\155\305\023\011\044\012\126\310\135\102\156\000\255\113\
\304\310\113\310\046\211\046\207\016\010\036\203\036\005\110\304\
\154\010\242\106\247\206\304\303\046\206\135\202\125\312\012\006\
\113\310\170\210\170\211\260\000\307\011\100\312\113\312\214\305\
\046\103\047\005\122\000\136\210\155\203\170\210\177\004\214\312\
\011\220\113\000\313\004\155\000\113\103\024\002\270\306\053\001\
\077\003\167\203\232\105\036\010\075\010\170\204\251\000\024\002\
\005\102\017\105\044\005\130\011\200\203\246\004\071\105\157\000\
\033\002\074\004\170\203\214\315\225\204\235\216\256\005\113\305\
\214\315\247\216\075\311\075\111\125\305\150\015\
\225\211\237\111\036\310\011\205\011\217\023\107\035\002\050\006\
\064\006\075\107\075\013\100\311\112\002\113\305\125\311\125\307\
\136\211\136\111\146\000\161\305\221\307\225\207\242\111\243\000\
\243\110\254\204\216\012\044\000\006\003\011\105\001\002\225\106\
\237\012\265\104\011\213\064\002\046\204\050\007\065\010\100\311\
\100\311\100\315\110\316\113\311\113\312\125\306\125\312\126\212\
\145\000\164\012\173\000\174\016\214\311\214\312\222\203\225\211\
\235\207\242\111\252\211\270\106\075\113\100\304\114\107\125\304\
\125\307\174\105\174\113\125\310\172\216\216\313\221\310\113\003\
\214\307\265\107\255\105\125\306\170\206\214\311\244\206\005\106\
\032\005\056\111\113\320\125\316\214\316\214\320\223\111\022\105\
\036\003\054\014\113\103\113\207\140\207\140\212\
\150\007\221\207\221\307\246\000\254\212\252\210\074\006\137\006\
\165\000\214\311\100\310\146\306\022\115\125\307\125\312\140\207\
\146\205\160\207\167\205\252\210\324\000\324\100\011\207\075\013\
\106\106\215\107\006\001\010\007\011\214\001\005\017\110\050\014\
\104\006\113\207\125\310\136\210\150\014\155\314\163\310\167\214\
\212\001\225\210\242\114\246\005\252\210\265\105\023\000\170\210\
\011\210\033\007\113\304\125\310\126\215\140\210\203\113\237\110\
\252\215\303\215\306\115\140\212\040\111\125\307\170\105\265\111\
\011\103\011\205\011\206\017\105\023\205\056\116\075\305\140\205\
\161\301\214\305\247\205\253\010\255\105\255\107\306\110\323\105\
\110\012\115\012\022\104\023\104\126\306\221\106\065\012\075\106\
\075\315\125\313\126\211\166\015\170\210\200\213\
\214\312\242\107\247\210\036\104\303\004\113\317\126\204\232\206\
\235\206\255\115\023\105\046\110\065\011\067\004\112\006\113\311\
\113\312\125\307\125\313\135\103\136\207\166\012\175\100\200\120\
\216\310\243\106\014\002\306\110\161\310\202\302\247\210\225\210\
\011\210\036\005\225\206\115\005\232\206\202\306\075\110\113\304\
\304\214\007\004\007\004\303\211\225\206\214\316\214\314\113\310\
\125\311\160\210\202\310\036\302\046\121\047\203\047\120\050\005\
\050\012\050\013\052\002\052\011\053\200\053\104\054\003\054\013\
\054\014\055\000\056\103\056\303\056\304\056\305\056\305\056\105\
\056\105\056\306\056\306\056\306\056\307\056\310\056\110\056\310\
\056\110\056\311\056\211\056\011\056\111\056\312\056\312\056\313\
\056\314\056\114\056\315\056\316\056\122\036\204\
\070\001\001\003\001\004\002\002\002\004\003\000\003\004\004\000\
\004\001\004\007\004\011\005\114\006\000\230\011\006\006\207\006\
\070\002\007\001\007\006\007\006\010\000\010\002\010\007\010\010\
\010\013\011\002\011\202\011\002\011\202\011\202\011\203\011\203\
\011\203\011\203\011\204\011\204\011\205\011\205\011\205\011\205\
\011\205\011\205\011\206\011\206\011\206\011\206\011\206\011\206\
\011\206\011\206\011\206\011\006\011\106\011\216\011\207\011\207\
\011\007\011\207\011\207\011\207\011\207\011\207\011\207\011\207\
\011\210\011\210\011\210\011\210\011\210\011\210\011\204\011\210\
\011\210\011\210\011\210\011\210\011\210\011\210\011\210\011\211\
\011\211\011\113\011\211\011\211\011\211\011\211\011\211\011\211\
\011\211\011\212\011\212\011\212\011\213\011\213\
\011\113\011\214\011\213\011\213\011\214\011\214\011\214\011\214\
\011\214\011\214\011\215\011\215\011\215\011\214\011\215\011\216\
\011\216\011\216\011\215\011\217\011\223\011\223\011\224\011\224\
\012\000\012\001\012\006\012\005\012\006\012\014\165\021\013\006\
\013\007\014\002\014\016\015\000\015\003\015\003\015\003\015\005\
\015\007\015\010\015\011\016\000\016\010\016\010\016\010\016\014\
\016\015\017\000\017\104\017\104\017\104\017\104\017\105\017\106\
\017\110\017\110\017\115\020\000\215\105\020\104\020\006\020\111\
\021\000\021\007\022\001\022\103\022\104\022\104\022\005\022\105\
\022\106\022\106\022\106\022\007\022\107\022\107\022\107\022\110\
\022\110\022\011\022\112\022\112\022\111\022\113\022\113\022\115\
\022\016\022\016\022\011\022\015\022\116\022\116\
\240\011\023\205\023\205\023\206\023\106\023\207\023\210\023\011\
\023\112\023\213\023\213\023\013\023\213\023\216\023\216\023\221\
\024\000\024\003\024\004\024\005\024\007\024\011\024\011\025\000\
\026\000\026\005\026\013\026\014\026\015\027\000\027\011\030\002\
\030\002\001\004\030\003\030\002\017\112\031\002\032\000\032\003\
\032\003\032\007\032\006\033\000\033\007\033\011\033\012\033\012\
\033\014\033\014\034\000\034\011\034\017\254\012\035\010\035\011\
\035\017\036\302\036\302\036\302\036\302\036\303\036\304\036\304\
\036\304\036\304\036\304\036\304\036\304\036\304\036\204\036\304\
\036\305\036\305\036\205\036\305\036\306\036\305\036\206\036\105\
\036\305\036\305\036\305\036\305\036\305\036\305\036\306\036\106\
\036\006\036\306\036\306\036\306\036\306\036\206\
\036\006\036\306\036\306\036\306\036\006\036\306\036\007\036\307\
\036\307\036\307\036\307\036\307\036\107\036\307\036\307\036\310\
\036\310\036\311\036\310\036\210\036\310\036\310\036\310\036\310\
\036\310\036\307\036\310\036\311\036\311\036\306\036\311\036\311\
\036\211\036\311\036\311\036\311\036\111\036\311\036\311\036\311\
\036\311\036\311\036\312\036\312\036\312\036\312\036\312\036\312\
\036\312\036\313\036\313\036\313\036\313\036\313\036\313\036\313\
\036\314\036\114\036\016\036\315\036\314\036\314\036\314\036\315\
\036\315\036\315\036\315\036\315\036\315\036\316\036\316\036\317\
\036\317\036\316\036\320\036\020\036\321\036\121\036\122\036\322\
\036\322\036\322\036\322\036\322\036\323\036\325\036\325\037\000\
\037\004\037\005\037\006\037\006\037\007\037\010\
\037\010\037\010\037\011\037\012\037\013\037\013\037\012\037\015\
\040\202\040\203\040\203\040\204\040\204\040\204\040\204\040\205\
\040\007\040\105\040\205\040\205\040\205\040\206\040\206\040\206\
\040\206\040\206\040\206\040\207\040\207\040\207\040\207\040\207\
\040\110\040\207\040\210\040\210\040\211\040\211\040\213\040\111\
\040\212\040\112\040\112\040\012\040\212\040\211\040\113\040\113\
\040\214\040\214\040\214\040\215\040\220\040\215\040\214\040\114\
\040\115\040\016\040\116\040\216\040\217\040\117\040\221\040\220\
\040\221\040\120\041\004\041\011\041\011\041\011\041\012\041\013\
\042\000\043\000\043\013\044\003\044\010\044\013\045\001\045\201\
\045\102\045\103\045\004\165\004\045\206\045\206\045\106\045\207\
\045\207\045\111\045\211\045\212\045\213\045\113\
\046\203\046\203\046\004\046\004\046\005\046\204\046\205\046\205\
\046\206\046\106\046\204\046\206\046\206\046\207\046\207\046\107\
\046\207\046\207\046\207\046\210\046\210\046\210\046\210\046\110\
\046\210\046\110\046\211\046\212\046\212\046\212\046\211\046\212\
\046\213\046\213\046\213\046\213\046\213\046\214\046\214\046\214\
\046\214\046\115\046\016\046\212\046\216\046\216\046\220\046\221\
\046\221\046\221\047\000\047\102\047\104\047\104\047\105\047\206\
\047\010\047\111\047\013\047\115\103\003\047\216\050\000\050\002\
\050\006\050\007\050\010\050\010\050\010\050\011\050\011\050\013\
\050\013\050\013\050\012\050\013\050\014\050\015\050\021\050\020\
\051\007\051\010\051\110\051\213\052\002\052\012\053\000\053\004\
\054\000\054\001\054\004\054\005\054\006\054\007\
\054\007\054\006\054\011\054\022\055\000\005\103\056\102\056\303\
\056\104\056\104\056\204\056\104\056\305\056\305\056\305\056\305\
\056\305\056\305\056\305\056\106\056\306\056\107\056\307\056\307\
\056\307\056\113\056\307\056\107\056\310\056\110\056\111\056\110\
\056\310\056\110\056\110\056\310\056\310\056\110\056\310\056\111\
\056\211\056\311\056\311\056\112\056\112\056\312\056\313\056\113\
\056\313\056\314\056\314\056\315\056\315\056\116\056\114\056\116\
\056\315\056\321\056\122\056\123\056\223\056\124\057\000\060\004\
\061\200\061\104\062\104\062\105\062\205\062\105\062\105\062\110\
\062\210\062\211\062\211\062\211\062\212\062\213\062\213\062\214\
\062\214\062\114\062\111\063\003\063\003\064\000\064\013\065\000\
\065\006\065\011\065\011\065\012\065\013\065\013\
\065\013\065\014\065\014\065\014\065\014\065\014\065\014\065\015\
\065\015\065\020\065\022\065\026\065\021\066\000\066\005\067\000\
\067\004\067\007\067\017\072\015\070\000\070\011\071\001\071\005\
\071\106\071\110\071\112\071\114\071\116\071\023\071\006\072\000\
\072\006\072\010\072\012\073\000\073\011\074\000\074\004\074\005\
\074\005\074\005\074\006\074\006\074\007\074\006\074\010\074\010\
\074\010\074\010\074\011\074\012\074\015\075\303\075\304\075\304\
\075\304\075\304\075\204\075\110\075\104\075\305\075\306\075\305\
\075\305\075\305\075\105\075\105\075\305\075\305\075\305\075\305\
\075\305\075\305\075\106\075\106\075\306\075\106\075\306\075\306\
\075\306\075\306\075\106\075\306\075\306\075\306\075\306\075\306\
\075\106\075\307\075\307\075\310\075\307\075\307\
\075\307\075\307\075\307\075\307\075\307\075\307\075\307\075\110\
\075\310\075\110\075\310\075\310\075\304\075\310\075\310\075\310\
\075\310\075\312\075\311\075\111\075\311\075\111\075\311\075\311\
\075\311\075\311\075\311\075\311\075\311\075\111\075\311\075\112\
\075\312\075\112\075\312\075\312\075\112\075\312\075\112\075\312\
\075\312\075\112\075\312\075\313\075\313\075\313\075\113\075\313\
\075\113\075\313\075\313\075\313\075\313\075\313\075\112\075\313\
\075\313\075\114\075\114\075\113\075\314\075\314\075\314\075\114\
\075\114\075\314\075\314\075\315\075\315\075\015\075\320\075\315\
\075\115\075\315\075\315\075\115\075\315\075\315\075\316\075\116\
\075\320\075\321\075\317\075\022\075\321\075\322\075\322\075\123\
\076\000\076\001\076\002\076\002\076\004\076\007\
\076\010\076\111\076\012\076\113\076\114\076\115\076\116\077\005\
\100\301\100\303\100\303\100\303\100\303\100\303\100\304\100\304\
\100\304\100\304\100\304\100\304\100\304\100\305\100\304\100\304\
\100\305\100\305\100\305\100\205\100\206\100\305\100\315\100\305\
\100\105\100\305\100\305\100\305\100\305\100\304\100\305\100\306\
\100\306\100\306\100\306\100\306\100\206\100\306\100\306\100\307\
\100\307\100\307\100\311\100\307\100\310\100\310\100\310\100\310\
\100\310\100\210\100\310\100\310\100\310\100\310\100\310\100\307\
\100\311\100\311\100\311\100\311\100\311\100\311\100\311\100\311\
\100\311\100\312\100\212\100\312\100\312\100\312\100\312\100\322\
\100\312\100\312\100\312\100\313\100\213\100\313\100\313\100\324\
\100\314\100\314\100\314\100\314\100\314\100\315\
\100\315\100\314\100\315\100\315\100\315\100\215\100\315\100\316\
\100\215\206\111\100\316\100\316\100\305\100\316\100\316\100\325\
\100\317\100\317\100\317\100\317\100\217\100\317\100\321\100\322\
\100\317\100\323\100\223\100\324\102\000\102\100\102\202\102\203\
\102\203\146\304\102\206\102\207\102\207\102\007\102\207\102\210\
\102\210\102\012\102\213\102\215\102\116\102\123\104\007\104\011\
\105\005\105\016\106\106\106\106\106\006\106\106\106\107\106\111\
\106\116\106\114\107\000\107\000\110\103\110\104\110\104\110\104\
\110\104\110\204\110\305\110\005\110\105\110\105\110\106\110\306\
\110\206\110\106\110\307\110\007\110\307\110\307\110\107\110\106\
\110\207\110\310\110\110\110\111\110\310\110\311\110\311\110\311\
\110\312\110\014\110\014\110\314\110\314\110\214\
\110\312\110\314\110\315\110\315\110\317\110\305\110\320\110\121\
\111\000\111\003\111\005\112\105\112\107\112\010\112\115\112\120\
\112\021\113\001\113\002\113\202\113\302\113\302\113\302\113\303\
\113\303\113\303\113\303\113\303\113\303\113\304\113\104\113\104\
\113\304\113\304\113\304\113\304\113\304\113\304\113\304\113\305\
\113\305\113\305\113\005\113\305\113\305\113\305\113\305\113\305\
\113\305\113\305\113\305\113\305\113\305\113\305\113\306\113\315\
\113\206\113\306\113\306\113\207\113\306\113\306\113\306\113\307\
\113\306\113\306\113\306\113\307\113\307\113\207\113\307\113\307\
\113\307\113\007\113\307\113\307\113\316\113\307\113\307\113\107\
\113\307\113\107\113\310\113\307\113\307\113\310\113\210\113\310\
\113\010\113\310\113\310\113\310\113\310\113\310\
\113\310\113\310\113\310\113\311\113\310\113\310\113\010\113\310\
\113\310\113\310\113\210\113\310\113\310\113\310\113\310\113\310\
\113\310\113\310\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\311\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\311\113\311\113\311\113\312\113\212\113\312\113\312\
\113\312\113\312\113\312\113\312\113\212\113\212\113\312\113\312\
\113\212\113\312\113\312\113\312\113\312\113\312\113\312\113\312\
\113\312\113\313\113\213\113\313\113\313\113\321\113\313\113\313\
\113\213\113\313\113\312\113\313\113\313\113\313\113\313\113\013\
\113\313\113\316\113\313\113\313\113\314\113\313\113\314\113\314\
\113\314\113\314\113\314\113\314\113\314\113\314\113\314\113\313\
\113\315\113\315\113\214\113\315\113\315\113\315\
\113\215\214\321\113\316\113\316\113\316\113\316\113\316\113\315\
\113\317\113\317\113\317\113\315\113\317\113\320\113\321\113\321\
\214\321\113\321\113\223\113\325\113\031\113\330\114\107\114\107\
\114\010\114\110\114\111\114\111\114\111\114\112\114\113\114\114\
\114\114\114\115\114\115\114\121\115\016\116\000\116\104\116\104\
\116\105\116\105\116\107\116\110\116\110\116\112\116\113\116\114\
\116\114\116\116\116\121\116\117\117\000\117\106\117\110\117\113\
\120\000\120\012\122\104\122\307\122\107\122\010\122\310\122\013\
\122\215\123\004\124\000\124\004\124\006\124\006\125\003\125\303\
\125\303\125\304\125\304\125\304\125\304\125\304\125\304\125\304\
\125\304\125\304\125\304\125\304\125\305\125\305\125\305\125\305\
\125\305\125\305\125\305\125\305\125\305\125\305\
\125\305\125\304\125\305\125\305\125\305\125\306\125\206\125\306\
\125\306\125\306\125\306\125\306\125\306\125\306\125\306\125\306\
\125\307\125\307\125\307\125\307\125\307\125\307\125\307\125\307\
\125\316\125\307\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\311\125\311\
\125\310\125\311\125\311\125\311\125\311\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\125\311\125\313\
\125\311\125\311\125\311\125\312\125\312\125\312\125\312\125\312\
\125\312\125\312\125\312\125\312\125\312\125\112\125\312\125\312\
\125\312\125\312\125\013\125\314\125\321\125\313\125\313\125\313\
\125\013\125\313\125\313\125\313\125\313\125\313\
\125\313\125\312\125\313\125\314\125\314\125\314\125\314\125\316\
\125\314\125\314\125\320\125\314\125\314\125\314\125\314\125\314\
\125\314\125\315\125\314\125\315\125\315\125\315\125\315\125\315\
\125\314\125\315\125\316\125\316\125\316\125\316\125\316\125\316\
\125\316\125\315\125\317\125\317\125\317\125\317\125\317\125\317\
\125\317\125\320\125\320\125\314\125\320\125\320\125\320\125\321\
\125\321\125\321\125\323\125\326\126\104\126\204\126\205\126\207\
\126\205\126\205\126\205\126\205\126\206\126\306\126\306\126\206\
\126\307\126\207\126\210\126\210\126\211\126\311\126\312\126\311\
\126\011\126\211\126\211\126\211\126\312\126\216\126\212\126\212\
\126\113\126\313\126\214\126\314\126\214\126\214\126\214\126\214\
\126\214\126\215\126\215\126\215\126\215\126\216\
\126\116\126\216\126\217\126\220\126\221\126\131\127\204\127\004\
\127\205\127\210\131\000\131\005\132\100\132\104\132\115\133\010\
\133\017\135\205\135\207\135\110\135\107\135\010\135\212\135\112\
\135\217\135\220\136\204\136\203\136\204\136\204\136\204\136\205\
\136\205\136\206\136\206\136\206\136\207\136\207\136\006\136\210\
\136\210\136\210\136\210\136\210\136\211\136\211\136\211\136\211\
\136\212\136\013\136\212\136\114\136\214\136\215\136\215\136\216\
\136\117\136\217\136\120\136\220\140\205\140\205\140\205\140\205\
\140\205\140\206\140\206\140\206\140\214\140\207\140\212\140\210\
\140\207\140\210\140\210\140\211\140\211\140\111\140\211\140\211\
\140\211\140\012\140\212\140\212\140\212\140\211\140\213\140\213\
\140\214\140\015\140\216\140\220\140\221\140\206\
\141\006\141\016\142\302\142\303\142\104\142\304\142\304\142\304\
\142\306\142\106\142\211\142\111\142\311\142\213\142\213\142\112\
\142\115\142\115\143\010\144\007\145\002\146\102\146\203\146\304\
\146\304\146\304\146\305\146\004\146\205\146\306\146\306\146\106\
\146\007\146\307\146\310\146\210\146\016\146\316\146\307\146\121\
\146\121\146\113\150\002\150\003\150\003\150\004\150\004\150\005\
\150\005\150\005\150\006\150\005\150\005\150\005\150\005\150\006\
\150\006\150\006\150\007\150\007\150\007\150\010\150\010\150\010\
\150\010\150\010\150\010\150\010\150\010\150\011\150\011\150\011\
\150\012\150\012\150\012\150\012\150\012\150\012\150\013\150\013\
\150\013\150\014\150\014\150\014\150\015\150\014\150\016\150\017\
\150\020\150\020\150\020\150\020\150\021\150\022\
\150\023\151\000\151\004\151\007\152\102\152\102\152\204\152\105\
\152\206\152\207\152\207\152\010\152\212\153\205\153\107\153\111\
\153\211\153\112\154\003\154\005\154\006\154\006\154\010\154\011\
\154\013\154\013\154\014\214\321\155\304\155\304\155\304\155\304\
\155\305\155\305\155\005\155\206\155\306\155\305\155\206\155\306\
\155\307\155\310\155\310\155\310\155\310\155\310\155\211\155\111\
\155\311\155\312\155\312\155\312\155\313\155\313\155\314\155\314\
\155\315\155\015\155\315\155\215\155\315\155\315\155\017\155\023\
\155\325\156\004\157\002\157\110\160\203\160\204\160\204\160\217\
\160\205\160\216\160\206\160\210\160\207\160\110\160\210\160\210\
\160\210\160\211\160\211\160\211\160\211\160\212\160\212\160\212\
\160\213\160\212\160\212\160\212\160\012\160\113\
\160\213\160\213\160\214\160\214\160\215\160\215\160\215\160\216\
\160\117\160\217\161\203\161\205\161\205\161\105\161\205\161\205\
\161\205\161\210\161\210\161\211\161\212\161\214\161\014\161\214\
\161\215\161\221\162\104\162\104\163\003\163\304\163\305\163\305\
\163\305\163\305\163\307\163\307\163\310\163\310\163\310\163\210\
\161\110\163\311\163\312\163\212\163\312\163\312\163\314\163\314\
\163\315\163\315\163\316\163\320\163\321\164\003\164\004\164\005\
\164\007\164\006\164\007\164\007\164\011\164\020\164\012\164\013\
\164\015\164\015\164\014\164\015\164\017\164\021\165\102\165\103\
\165\104\165\104\165\105\165\105\165\105\165\106\165\107\165\107\
\165\111\165\111\166\003\166\004\166\004\166\004\166\005\166\005\
\166\005\166\005\166\005\166\005\166\005\166\006\
\166\007\166\004\166\006\166\004\166\006\166\006\166\007\166\007\
\166\007\166\007\166\007\166\007\166\006\166\007\166\010\166\010\
\166\010\166\010\166\010\166\010\166\010\166\010\166\010\166\006\
\166\010\166\011\166\011\166\011\166\011\166\011\166\011\166\012\
\166\012\166\012\166\013\166\012\166\012\166\020\166\013\166\013\
\166\013\166\013\166\013\166\013\166\013\166\013\166\014\166\014\
\166\016\166\014\166\015\166\015\166\015\166\016\166\016\166\017\
\166\016\166\015\166\017\166\020\166\020\166\021\166\017\166\021\
\166\022\167\202\167\204\167\204\167\006\167\206\167\106\167\206\
\167\206\167\206\167\207\167\107\167\107\167\207\167\210\167\210\
\167\207\167\211\167\211\167\212\167\212\167\013\167\212\301\014\
\167\216\167\216\167\020\167\023\170\201\170\203\
\170\203\170\204\170\204\170\104\170\205\170\205\170\105\170\205\
\170\205\170\205\170\205\170\206\170\206\170\206\170\206\170\206\
\170\106\170\206\170\206\170\207\170\207\170\007\170\207\170\207\
\170\207\170\210\170\110\170\210\170\210\170\210\170\210\170\210\
\170\213\170\210\170\210\170\011\170\210\170\207\170\210\170\211\
\170\211\170\211\170\211\170\212\170\211\170\211\170\211\170\212\
\170\012\170\212\170\212\170\213\170\212\170\212\170\212\170\012\
\170\213\170\214\170\013\170\213\170\213\170\213\170\213\170\213\
\170\213\170\214\170\214\170\214\170\214\170\214\170\214\170\215\
\170\215\170\215\170\216\170\216\170\216\170\210\170\216\170\016\
\170\216\170\217\170\217\170\217\170\220\170\217\170\221\170\221\
\170\221\170\217\170\022\170\225\171\203\171\204\
\171\213\171\116\171\117\171\220\171\221\172\300\172\003\172\103\
\172\204\172\205\172\205\172\210\172\210\172\210\172\212\172\215\
\172\216\172\215\172\223\172\221\173\102\173\104\173\105\173\205\
\173\205\173\007\173\211\173\112\173\115\173\111\173\215\173\015\
\173\016\174\004\174\104\174\305\174\206\174\306\174\210\174\211\
\174\311\174\213\174\014\267\014\175\104\175\104\175\106\177\000\
\177\004\177\004\177\005\177\007\177\012\200\204\200\204\200\205\
\200\205\200\206\200\207\200\010\200\110\200\210\200\211\200\113\
\200\113\200\213\200\014\200\216\200\020\201\100\201\107\201\107\
\201\010\202\303\202\203\202\303\202\304\015\006\202\304\202\305\
\202\205\202\305\202\305\202\205\202\305\202\305\202\305\202\306\
\202\306\202\307\202\107\202\207\202\307\202\310\
\202\110\202\310\202\310\202\310\202\310\202\306\202\311\202\311\
\202\311\202\311\202\311\202\312\202\312\202\312\202\312\202\212\
\202\313\202\313\202\313\202\313\202\311\202\313\202\314\202\314\
\202\313\202\315\202\315\202\315\202\215\202\215\202\115\202\315\
\202\316\202\316\202\320\202\317\202\314\202\320\202\321\202\023\
\203\010\205\010\205\012\206\102\206\003\206\005\206\007\206\106\
\206\013\207\002\207\004\207\011\211\004\211\004\211\005\211\005\
\211\007\211\012\211\012\211\013\211\013\211\014\211\015\211\015\
\211\015\211\017\211\020\211\004\212\013\213\022\214\000\214\302\
\214\303\214\303\214\304\214\304\214\004\214\304\214\305\214\305\
\214\305\214\305\214\305\214\305\214\305\214\307\214\305\214\305\
\214\305\214\305\214\305\214\305\214\305\214\305\
\214\306\214\306\214\306\214\306\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\306\214\306\214\307\214\307\214\307\
\214\307\214\307\214\307\214\307\214\307\214\307\214\307\214\307\
\214\307\214\307\214\307\214\307\214\307\214\307\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\306\214\311\
\214\313\214\310\214\311\214\311\214\311\214\314\214\311\214\311\
\214\311\214\312\214\311\214\311\214\311\214\311\214\311\214\311\
\214\311\214\311\214\312\214\311\214\312\214\312\214\312\214\312\
\214\312\214\312\214\312\214\312\214\312\214\312\214\312\214\312\
\214\313\214\313\214\313\214\313\214\313\214\314\214\313\214\313\
\214\313\214\313\214\314\214\314\214\314\214\314\
\214\314\214\320\214\314\214\314\214\315\214\315\214\315\214\315\
\214\315\214\315\214\315\214\315\214\315\214\317\214\315\214\315\
\214\315\214\315\214\315\214\316\214\316\214\316\214\316\214\316\
\214\317\214\317\214\317\214\317\214\320\214\320\214\320\214\320\
\214\320\214\320\214\320\214\320\214\321\214\321\214\323\215\000\
\004\006\215\104\215\007\215\013\216\002\216\304\216\304\216\204\
\216\304\216\304\216\304\216\305\216\305\216\305\216\305\216\305\
\216\305\216\316\216\305\216\306\216\306\216\206\216\206\216\306\
\216\306\216\306\216\307\216\307\216\307\216\007\216\207\216\307\
\216\207\216\307\216\307\216\307\216\307\216\310\216\310\216\310\
\216\310\216\310\216\310\216\210\216\311\216\311\216\311\216\311\
\216\311\216\311\216\311\216\111\216\311\216\311\
\216\311\216\311\216\311\216\315\216\212\216\312\216\312\216\213\
\216\313\216\113\216\313\216\313\216\013\216\213\216\213\216\313\
\216\212\216\312\216\313\216\314\216\114\216\314\216\315\216\315\
\216\315\216\315\216\315\216\313\216\311\216\316\216\315\216\316\
\216\117\216\117\216\121\216\124\216\122\216\120\216\223\217\004\
\217\003\220\005\220\007\220\012\220\022\221\303\221\006\221\104\
\221\205\221\304\221\304\221\306\221\304\221\304\221\305\221\305\
\221\305\221\305\221\305\221\305\221\205\221\105\221\306\221\306\
\221\306\221\306\221\107\221\107\221\307\221\107\221\210\221\310\
\221\310\221\110\221\310\221\310\221\310\221\311\221\311\221\311\
\221\213\221\312\221\312\221\312\221\312\221\313\221\213\221\213\
\221\313\221\313\221\314\221\311\221\315\221\115\
\221\316\221\316\221\317\221\316\221\320\221\321\221\321\222\100\
\222\106\222\115\222\123\223\104\223\205\223\207\223\211\223\211\
\223\212\223\212\223\213\223\115\223\116\223\217\223\221\224\106\
\224\006\224\105\224\106\224\113\224\115\225\202\225\203\225\203\
\225\203\225\204\225\204\225\204\225\205\225\205\225\205\225\205\
\225\205\225\105\225\206\225\206\225\206\225\206\225\206\225\206\
\225\206\225\207\225\207\225\207\225\207\225\207\225\207\225\207\
\225\210\225\210\225\210\225\210\225\211\225\211\225\211\225\211\
\225\212\225\212\225\211\225\211\225\211\225\211\225\210\225\212\
\225\112\225\212\225\211\225\212\225\212\225\212\225\212\225\213\
\225\013\225\113\225\213\225\213\225\212\225\212\225\214\225\214\
\225\214\225\214\225\214\225\214\225\214\225\215\
\225\215\225\115\225\215\225\216\225\115\225\217\225\220\225\020\
\225\221\225\221\225\221\225\221\225\223\226\205\226\112\226\112\
\227\103\227\210\227\110\227\113\230\000\230\106\230\211\231\000\
\231\003\231\005\231\006\231\006\231\006\231\007\231\010\231\012\
\231\004\231\012\076\107\232\004\232\104\232\205\232\106\232\005\
\232\004\232\204\232\106\232\105\232\210\232\110\232\110\232\112\
\232\212\232\212\232\113\232\113\232\114\232\114\232\015\232\215\
\232\216\232\016\232\216\232\206\232\016\232\217\233\005\233\011\
\234\000\234\103\234\105\234\107\235\204\235\204\235\204\235\205\
\235\205\235\205\235\205\235\205\235\205\235\206\235\106\235\206\
\235\206\235\207\235\207\235\207\235\207\235\210\235\210\235\210\
\235\210\235\211\235\211\235\211\235\211\235\212\
\235\112\235\212\235\212\235\212\235\212\235\113\235\213\235\213\
\235\210\235\213\235\213\235\214\235\214\235\214\235\215\235\214\
\235\215\235\115\235\216\235\216\235\217\235\217\235\217\235\220\
\235\223\235\222\236\003\236\005\236\015\236\006\236\011\236\014\
\236\021\237\101\237\104\237\004\237\105\237\105\237\105\237\106\
\237\106\237\106\237\107\237\107\237\110\237\107\237\110\237\110\
\237\110\237\106\237\010\237\111\237\111\237\111\237\112\237\012\
\237\112\237\113\237\113\237\113\237\114\237\115\237\116\237\117\
\237\120\237\120\240\005\240\006\240\007\240\014\240\016\242\201\
\242\204\242\205\242\205\242\105\242\205\242\216\242\206\242\206\
\242\206\242\206\242\207\242\207\242\207\242\207\242\207\242\207\
\242\207\242\207\242\210\242\210\242\210\242\206\
\242\211\242\211\242\211\242\211\242\207\242\211\242\211\242\211\
\242\212\242\212\242\213\242\213\242\214\242\214\242\214\242\215\
\242\215\242\214\242\215\242\217\242\215\242\223\243\104\243\105\
\243\105\243\105\243\107\243\107\077\007\243\107\243\111\243\112\
\243\113\243\114\243\114\244\202\244\204\244\204\244\205\244\205\
\244\206\244\207\244\207\244\210\244\210\244\210\244\212\244\113\
\244\214\244\213\244\215\244\215\244\216\244\221\244\022\245\005\
\245\015\246\013\247\202\247\202\247\102\247\202\247\203\247\203\
\247\203\247\204\247\204\247\204\247\204\247\204\247\204\247\205\
\247\205\247\205\247\205\247\205\247\205\247\206\247\205\247\205\
\247\205\247\006\247\206\247\206\247\206\247\205\247\207\247\207\
\247\207\247\206\247\210\247\210\247\210\247\210\
\247\210\247\210\247\210\247\210\247\207\247\207\247\210\247\211\
\247\211\247\211\247\211\247\211\247\212\247\212\247\212\247\212\
\247\212\247\013\247\213\247\113\247\213\247\213\247\213\247\213\
\247\213\247\213\247\213\247\214\247\214\247\214\247\214\247\214\
\247\214\247\215\247\214\247\215\247\214\247\215\247\215\247\116\
\247\216\247\217\247\217\247\217\247\217\247\220\247\204\247\221\
\247\221\247\222\247\223\247\217\247\223\247\123\247\224\247\124\
\251\001\251\003\251\003\251\004\251\004\251\005\251\005\251\005\
\251\006\251\006\251\007\251\010\251\010\251\010\251\010\251\011\
\125\316\251\011\251\011\251\011\251\012\251\012\251\012\251\013\
\251\014\251\015\251\015\252\203\252\204\252\204\252\204\252\205\
\252\206\252\206\252\206\252\210\252\207\252\207\
\252\207\252\207\252\207\252\210\252\210\252\211\252\212\252\212\
\252\212\252\215\252\215\252\216\252\216\252\216\252\220\253\000\
\253\011\254\000\254\205\254\104\254\205\254\005\221\314\254\212\
\255\110\254\210\255\105\255\107\255\107\255\107\255\110\255\110\
\255\110\255\110\255\110\255\110\255\112\255\113\255\114\255\115\
\255\116\255\116\255\120\255\020\255\120\255\120\255\021\256\010\
\257\007\260\005\260\007\260\016\261\102\261\103\261\103\261\104\
\261\105\261\105\261\105\261\105\261\105\261\106\261\006\261\106\
\261\110\261\111\261\111\261\111\261\111\261\112\261\115\261\117\
\261\116\262\000\262\112\263\000\322\011\263\012\264\002\264\205\
\264\204\265\104\265\104\265\107\265\106\265\106\265\107\265\107\
\265\110\265\111\265\111\265\115\265\116\265\017\
\265\120\265\121\265\122\266\103\266\205\266\305\266\310\266\213\
\266\313\266\214\270\304\270\304\270\306\270\306\270\307\270\307\
\270\307\270\310\270\307\270\310\270\310\270\310\270\311\270\111\
\270\312\270\312\270\312\270\313\270\313\270\314\270\314\270\314\
\270\314\270\314\270\115\271\002\271\010\272\111\273\202\273\002\
\273\204\273\205\273\205\273\205\273\205\273\105\273\206\273\206\
\273\206\273\206\273\207\273\207\273\207\273\210\273\210\273\206\
\273\211\273\112\273\212\273\213\273\213\273\112\273\213\273\213\
\273\214\273\214\273\215\273\215\273\216\273\220\273\220\273\221\
\273\221\273\024\273\223\274\003\274\004\274\006\274\010\274\013\
\274\015\274\015\274\015\275\015\276\000\276\003\276\004\276\004\
\276\005\276\005\276\005\276\005\276\005\276\006\
\276\006\276\010\276\013\276\014\276\015\276\016\276\017\277\000\
\277\005\277\006\277\010\277\012\277\020\300\000\301\000\302\105\
\302\205\302\110\302\210\302\210\302\212\302\016\303\204\303\205\
\303\205\303\205\303\205\303\205\303\206\303\206\303\206\303\206\
\303\207\303\107\303\207\303\207\303\207\303\207\303\207\303\210\
\303\210\303\210\303\210\303\210\303\213\303\210\303\210\303\210\
\303\211\303\211\303\211\303\211\303\211\303\211\303\211\303\211\
\303\211\303\211\303\212\303\211\303\212\303\212\303\212\303\212\
\303\213\303\113\303\213\303\213\303\214\303\215\303\215\303\217\
\303\220\304\102\304\002\304\302\304\304\304\104\304\102\304\104\
\304\304\304\305\304\205\304\212\304\305\304\305\304\306\304\105\
\304\305\304\306\304\306\304\306\304\106\304\306\
\304\307\304\207\304\307\304\307\304\307\304\307\304\310\304\310\
\304\310\304\311\304\310\304\310\304\311\304\311\304\211\304\312\
\304\312\304\312\304\312\304\312\304\312\304\312\304\312\304\312\
\304\213\304\313\304\314\304\314\304\314\304\314\304\215\304\321\
\304\321\304\223\305\000\305\111\305\015\306\102\306\305\306\206\
\306\207\306\110\306\310\306\210\306\312\307\100\307\104\307\004\
\307\104\307\105\310\010\311\115\312\003\312\005\312\012\313\204\
\313\205\313\205\313\205\313\206\313\210\313\110\313\211\313\113\
\313\116\313\217\314\000\314\005\314\007\315\000\315\113\315\114\
\153\111\317\005\320\000\320\205\321\003\322\000\323\200\323\302\
\323\305\323\305\323\305\323\305\323\306\323\206\323\307\323\307\
\323\311\323\311\323\311\324\106\325\100\326\000\
\040\011\113\312\242\212\140\212\017\115\126\312\036\314\057\010\
\062\205\062\105\062\213\062\214\065\010\065\012\065\012\066\005\
\067\001\067\003\067\006\071\104\071\105\071\110\071\110\071\111\
\071\012\071\113\072\005\072\011\073\004\073\007\074\005\074\006\
\074\010\074\011\074\012\074\014\074\014\075\302\075\104\075\304\
\075\104\075\305\075\305\075\105\075\305\075\305\075\306\075\307\
\075\307\075\307\075\310\075\310\075\310\075\310\075\311\075\311\
\075\312\075\312\075\312\075\314\075\314\075\314\075\114\075\315\
\075\117\076\111\077\004\077\005\100\302\100\303\100\304\100\304\
\100\305\100\305\100\306\100\306\100\306\100\307\100\307\100\310\
\100\310\100\311\100\311\100\311\100\312\100\312\100\312\100\212\
\100\313\100\313\100\313\100\214\100\315\100\315\
\100\315\100\215\100\315\100\317\100\317\100\323\100\324\102\207\
\102\010\104\010\107\107\110\304\110\304\110\304\110\305\110\105\
\110\305\110\305\110\305\110\105\110\105\110\305\110\107\110\306\
\110\306\110\107\110\307\110\307\110\307\110\307\110\210\110\110\
\110\111\110\311\110\111\110\112\110\313\110\314\110\014\110\314\
\110\315\110\316\110\320\111\006\112\106\112\007\113\302\113\303\
\113\303\113\303\113\304\113\304\113\304\113\304\113\304\113\305\
\113\304\113\305\113\305\113\305\113\305\113\205\113\306\113\306\
\113\306\113\306\113\307\113\307\113\307\113\307\113\207\113\307\
\113\310\113\210\113\210\113\310\113\310\113\310\113\110\113\310\
\113\310\113\311\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\312\113\312\113\312\113\312\113\312\
\113\313\113\313\113\214\113\314\113\313\113\313\113\313\113\313\
\113\314\113\314\113\314\113\314\113\214\113\314\113\314\113\314\
\113\314\113\116\113\315\113\315\113\315\113\315\113\315\113\317\
\113\320\113\320\113\321\113\325\113\330\114\106\114\107\114\111\
\114\114\114\117\115\003\115\004\115\014\116\105\116\115\116\115\
\117\107\120\003\121\005\121\005\122\213\122\114\123\001\124\012\
\125\303\125\303\125\304\125\304\125\304\125\304\125\304\125\304\
\125\304\125\305\125\305\125\305\125\305\125\305\125\305\125\106\
\125\306\125\306\125\306\125\306\125\306\125\306\125\307\125\307\
\125\307\125\307\125\307\125\307\125\307\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\010\125\311\125\311\
\125\311\125\311\125\311\125\312\125\312\125\312\
\125\312\125\012\125\013\125\313\125\313\125\313\125\313\125\313\
\125\314\125\314\125\315\125\314\125\314\125\315\125\314\125\314\
\125\314\125\314\125\315\125\315\125\315\125\315\125\315\125\315\
\125\317\125\316\125\316\125\317\125\317\125\320\125\322\125\325\
\125\325\125\327\125\327\126\103\126\104\126\205\126\205\126\205\
\126\206\126\206\126\206\126\307\126\207\126\210\126\210\126\210\
\126\210\126\211\126\211\126\111\126\311\126\212\126\211\126\211\
\126\211\126\312\126\212\126\212\126\112\126\212\126\214\126\014\
\126\316\126\216\126\117\133\013\133\013\135\207\135\211\135\013\
\136\204\136\104\136\207\136\211\136\211\136\211\136\211\136\213\
\136\214\136\221\140\203\140\204\140\204\140\204\140\204\140\204\
\140\205\140\205\140\206\140\206\140\206\140\206\
\140\207\140\210\140\210\140\210\140\210\140\210\140\210\140\210\
\140\210\140\210\140\210\140\210\140\210\140\211\140\211\140\211\
\140\212\140\211\140\212\140\212\140\212\140\213\140\213\140\213\
\140\215\140\214\140\214\140\214\140\215\140\215\140\215\140\215\
\140\215\140\216\140\217\140\217\140\223\142\210\142\210\142\220\
\145\007\146\307\146\310\150\000\150\002\150\006\150\007\150\010\
\150\010\150\011\150\011\150\011\150\012\150\012\150\013\150\013\
\150\014\150\014\150\017\150\017\150\021\150\022\150\023\152\102\
\152\112\152\012\152\212\152\215\152\217\153\111\154\004\154\005\
\154\005\154\006\154\013\155\303\155\304\155\304\155\305\155\306\
\155\306\155\307\155\307\155\307\155\310\155\310\155\310\155\311\
\155\211\155\313\155\314\156\010\160\204\160\206\
\160\206\160\206\160\206\160\206\160\207\160\207\160\210\160\211\
\160\211\160\211\160\212\160\214\160\214\160\215\160\115\160\220\
\160\120\160\220\161\203\161\204\161\204\161\204\161\204\161\205\
\161\205\161\205\161\205\161\205\161\206\161\210\161\211\161\211\
\161\211\161\211\161\216\162\000\163\303\163\103\163\304\163\304\
\163\305\163\305\163\304\163\307\163\012\163\312\163\314\163\317\
\164\004\164\005\164\010\164\011\164\014\164\013\165\003\165\110\
\166\003\166\004\166\005\166\005\166\006\166\006\166\007\166\007\
\166\007\166\007\166\010\166\011\166\012\166\012\166\013\166\014\
\166\014\166\014\166\015\166\015\166\015\166\017\166\020\166\023\
\167\203\167\204\167\205\167\206\167\011\167\212\167\213\167\213\
\170\203\170\203\170\204\170\204\170\204\170\205\
\170\205\170\205\170\206\170\106\170\207\170\207\170\207\170\210\
\170\110\170\210\170\210\170\211\170\211\170\211\170\212\170\112\
\170\212\170\212\170\113\170\013\170\214\170\215\170\217\170\117\
\171\214\172\211\173\103\173\104\174\103\174\305\174\007\174\110\
\174\111\174\312\174\314\175\005\177\003\177\011\200\202\200\103\
\200\204\202\305\202\305\202\305\202\306\202\307\202\310\202\311\
\202\311\202\311\202\311\202\315\202\315\202\316\202\316\204\004\
\205\007\207\005\211\014\213\005\214\302\214\303\214\304\214\304\
\214\304\214\304\214\304\214\304\214\304\214\304\214\304\214\305\
\214\306\214\305\214\305\214\305\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\306\214\307\214\307\214\307\214\307\
\214\307\214\307\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\311\214\311\
\214\311\214\311\214\311\214\311\214\312\214\212\214\312\214\312\
\214\312\214\312\214\313\214\313\214\313\214\313\214\313\214\314\
\214\314\214\315\214\315\214\315\214\315\214\315\214\315\214\316\
\214\316\214\316\214\317\214\320\214\320\214\320\214\320\214\320\
\214\321\214\321\214\321\214\323\215\105\215\106\215\107\215\011\
\216\201\216\301\216\303\216\304\216\305\216\307\216\307\216\307\
\216\307\216\111\216\312\216\312\216\313\216\312\216\313\216\013\
\216\314\216\314\216\214\216\315\216\316\216\316\216\317\221\305\
\221\305\221\107\221\307\221\307\221\210\221\111\221\311\221\312\
\221\311\221\311\221\112\221\112\221\312\221\313\221\313\223\104\
\223\205\224\102\224\106\224\114\225\203\225\203\
\225\204\225\205\225\205\225\205\225\205\225\206\225\206\225\006\
\225\207\225\110\225\211\225\211\225\211\225\211\225\211\225\213\
\225\214\225\214\225\214\225\215\225\224\227\204\230\207\232\107\
\232\010\232\011\232\012\232\012\232\214\232\116\232\021\234\116\
\235\205\235\205\235\205\235\210\235\210\235\211\235\214\235\214\
\236\012\236\013\237\102\237\105\237\110\237\111\237\111\237\115\
\237\116\240\011\242\000\242\205\242\205\242\205\242\206\242\210\
\242\210\242\216\243\003\243\103\243\103\243\103\243\104\243\105\
\243\106\243\106\243\106\243\106\243\107\243\107\243\107\243\110\
\243\110\243\111\243\112\243\112\243\112\243\113\243\113\243\114\
\243\114\243\114\243\115\243\117\243\123\244\204\244\210\244\212\
\244\113\244\214\244\220\247\202\247\203\247\203\
\247\203\247\203\247\203\247\204\247\204\247\205\247\205\247\205\
\247\205\247\205\247\205\247\205\247\206\247\206\247\207\247\207\
\247\207\247\207\247\207\247\210\247\210\247\210\247\210\247\210\
\247\210\247\211\247\211\247\211\247\211\247\111\247\211\247\212\
\247\112\247\212\247\213\247\213\247\213\247\214\247\215\247\215\
\247\215\247\217\247\020\247\221\247\221\251\004\251\005\251\006\
\251\006\251\007\251\010\251\010\251\011\251\012\251\012\251\013\
\251\013\251\014\252\207\252\211\252\211\252\213\252\214\252\214\
\254\206\254\212\254\213\255\103\255\104\255\114\255\115\255\123\
\255\123\255\125\256\007\261\103\261\104\261\107\261\111\261\113\
\261\115\261\120\262\112\262\112\264\204\264\115\265\104\265\106\
\265\106\265\107\265\107\265\111\265\111\265\112\
\265\112\265\112\265\112\265\112\265\114\265\116\266\311\266\314\
\270\003\270\315\272\107\273\207\273\207\273\211\273\112\273\212\
\273\212\273\212\273\214\273\214\274\005\274\010\274\011\274\013\
\274\016\276\006\276\007\276\010\276\015\277\013\277\017\303\202\
\303\204\303\204\303\204\303\204\303\205\303\205\303\205\303\206\
\303\206\303\207\303\206\303\210\303\211\303\211\303\211\303\212\
\303\213\303\214\303\215\303\214\303\215\303\215\303\220\304\305\
\304\305\304\306\304\306\304\307\304\307\304\310\304\310\304\310\
\304\211\304\311\304\312\304\312\304\313\304\314\304\314\304\315\
\304\320\305\115\306\213\306\226\307\105\307\106\307\110\307\111\
\311\100\313\100\316\002\320\212\323\304\324\103\324\106\324\121\
\326\005\046\206\054\010\063\005\150\012\170\115\
")

;;; japanese-jisx0213-2 Ѥ󡦲ǡ
;; 2-1-1  2Byte Ļ(skk-tankan-radical-stroke-table-0213-1 Ʊ)
;; ̤ѤζϤȤФƤ
(defconst skk-tankan-radical-stroke-table-0213-2 "\
\001\001\001\001\001\003\001\003\002\002\002\002\002\003\004\000\
\004\002\004\002\004\005\004\005\004\005\004\005\005\100\005\105\
\007\006\010\005\010\013\010\024\011\200\011\100\011\001\011\202\
\011\202\011\102\011\203\011\103\011\204\011\204\011\204\011\204\
\011\205\011\205\011\205\011\205\011\105\011\206\011\206\011\206\
\011\206\011\206\011\206\011\206\011\206\011\206\011\207\011\207\
\011\207\011\207\011\207\011\207\011\207\011\210\011\210\011\210\
\011\210\011\210\011\210\011\210\011\210\011\210\011\211\011\211\
\011\211\011\211\011\211\011\211\011\211\011\211\011\211\011\212\
\011\212\011\212\011\212\011\212\011\212\011\212\011\213\011\213\
\011\213\011\213\011\213\011\213\011\213\011\214\011\214\011\214\
\011\214\011\214\011\214\011\214\011\214\011\215\
\011\215\011\216\011\216\011\217\011\221\012\012\014\004\014\004\
\015\002\015\003\015\011\016\002\016\010\017\003\017\104\017\106\
\017\107\020\100\020\014\020\014\022\100\022\104\022\104\022\010\
\022\110\022\110\022\111\022\113\022\114\022\114\022\115\022\123\
\023\004\023\204\023\004\023\205\023\206\023\206\023\007\023\110\
\023\210\023\217\023\221\024\006\024\006\026\005\026\017\027\011\
\030\001\030\002\030\006\031\006\032\002\032\006\033\012\033\021\
\034\002\034\002\034\006\035\002\035\005\035\006\035\006\035\007\
\036\202\036\202\036\002\036\304\036\304\036\304\036\304\036\304\
\036\305\036\305\036\305\036\305\036\305\036\305\036\106\036\306\
\036\306\036\306\036\306\036\306\036\306\036\306\036\307\036\307\
\036\307\036\307\036\307\036\307\036\307\036\307\
\036\310\036\310\036\310\036\010\036\310\036\310\036\210\036\310\
\036\310\036\211\036\311\036\311\036\311\036\311\036\311\036\311\
\036\312\036\312\036\112\036\312\036\312\036\312\036\312\036\312\
\036\312\036\312\036\312\036\313\036\313\036\313\036\313\036\314\
\036\314\036\314\036\314\036\314\036\314\036\314\036\315\036\315\
\036\315\036\316\036\316\036\316\036\317\036\117\036\317\036\320\
\036\020\036\021\036\023\036\025\037\003\037\004\037\005\037\005\
\037\011\037\012\040\102\040\203\040\203\040\204\040\204\040\204\
\040\104\040\204\040\204\040\205\040\205\040\205\040\105\040\205\
\040\205\040\206\040\206\040\206\040\006\040\206\040\206\040\206\
\040\207\040\207\040\207\040\210\040\210\040\210\040\210\040\210\
\040\210\040\210\040\210\040\210\040\210\040\211\
\040\211\040\211\040\111\040\211\040\112\040\212\040\212\040\212\
\040\113\040\213\040\114\040\113\040\213\040\213\040\214\040\114\
\040\214\040\215\040\215\040\116\040\220\041\005\041\006\042\004\
\042\004\043\004\043\006\043\022\044\013\045\002\045\203\045\104\
\045\205\045\105\045\205\045\007\045\110\045\110\045\011\046\202\
\046\202\046\203\046\104\046\205\046\205\046\205\046\205\046\206\
\046\206\046\206\046\006\046\206\046\206\046\207\046\207\046\207\
\046\206\046\207\046\207\046\207\046\210\046\210\046\111\046\211\
\046\211\046\211\046\211\046\211\046\212\046\212\046\012\046\212\
\046\212\046\213\046\213\046\013\046\213\046\213\046\213\046\214\
\046\214\046\214\046\215\046\015\046\216\046\123\047\000\047\006\
\047\110\047\120\047\123\050\002\050\002\050\003\
\050\005\050\006\050\010\050\010\050\011\050\011\050\012\050\013\
\050\014\050\016\051\104\051\105\051\107\053\204\053\011\054\006\
\054\011\054\013\054\014\054\016\054\017\055\003\056\301\056\103\
\056\303\056\304\056\104\056\305\056\204\056\305\056\305\056\305\
\056\305\056\105\056\105\056\105\056\305\056\305\056\305\056\107\
\056\106\056\107\056\310\056\310\056\310\056\110\056\310\056\310\
\056\310\056\310\056\111\056\311\056\111\056\311\056\112\056\312\
\056\312\056\312\056\113\056\313\056\113\056\213\056\314\056\114\
\056\314\056\315\056\315\056\114\056\215\056\316\056\316\056\323\
\056\324\056\324\057\004\057\006\057\014\060\003\061\102\062\101\
\062\203\062\105\062\205\062\005\062\106\062\107\062\211\062\211\
\062\213\062\213\062\214\062\116\062\216\062\216\
\062\217\062\222\065\006\065\007\065\007\065\010\065\010\065\012\
\065\013\065\013\066\005\066\007\067\006\070\003\071\103\071\103\
\071\104\071\115\073\004\073\023\074\005\074\007\074\010\074\011\
\074\014\075\300\075\200\075\302\075\303\075\003\075\303\075\303\
\075\104\075\304\075\304\075\304\075\304\075\205\075\305\075\305\
\075\105\075\306\075\306\075\107\075\107\075\307\075\107\075\110\
\075\310\075\310\075\310\075\310\075\310\075\310\075\311\075\311\
\075\311\075\311\075\311\075\311\075\111\075\311\075\311\075\112\
\075\112\075\312\075\313\075\113\075\114\075\314\075\314\075\114\
\075\314\075\114\075\114\075\314\075\115\075\116\075\316\075\116\
\075\317\076\002\076\104\076\111\076\112\077\006\100\300\100\302\
\100\302\100\303\100\303\100\304\100\304\100\304\
\100\304\100\305\100\305\100\205\100\306\100\306\100\306\100\206\
\100\307\100\307\100\207\100\307\100\307\100\307\100\307\100\307\
\100\307\100\307\100\307\100\310\100\310\100\310\100\310\100\310\
\100\311\100\210\100\311\100\311\100\311\100\311\100\311\100\311\
\100\211\100\311\100\311\100\312\100\312\100\312\100\313\100\312\
\100\313\100\312\100\313\100\313\100\313\100\314\100\314\100\314\
\100\314\100\315\100\315\100\314\100\315\100\316\100\316\100\216\
\100\317\100\317\100\321\100\320\100\321\100\321\100\322\100\323\
\101\010\102\205\102\207\102\211\102\013\102\215\102\117\102\020\
\103\006\105\013\105\015\105\025\106\105\106\106\106\007\106\111\
\110\203\110\103\110\204\110\304\110\304\110\304\110\305\110\105\
\110\306\110\106\110\306\110\006\110\007\110\307\
\110\307\110\307\110\110\110\010\110\310\110\310\110\310\110\310\
\110\310\110\310\110\312\110\311\110\311\110\112\110\313\110\312\
\110\313\110\314\110\314\110\214\110\323\111\003\111\012\111\012\
\112\106\112\107\112\007\113\303\113\303\113\303\113\303\113\303\
\113\303\113\303\113\304\113\304\113\304\113\304\113\304\113\305\
\113\004\113\205\113\305\113\305\113\205\113\305\113\305\113\205\
\113\305\113\305\113\105\113\305\113\306\113\306\113\306\113\306\
\113\306\113\306\113\306\113\306\113\306\113\206\113\306\113\306\
\113\306\113\206\113\306\113\306\113\307\113\307\113\307\113\307\
\113\107\113\307\113\307\113\307\113\307\113\307\113\307\113\307\
\113\307\113\307\113\307\113\307\113\307\113\207\113\310\113\310\
\113\310\113\210\113\310\113\310\113\310\113\310\
\113\310\113\310\113\310\113\310\113\310\113\310\113\310\113\310\
\113\310\113\311\113\311\113\211\113\311\113\311\113\311\113\311\
\113\311\113\311\113\312\113\212\113\012\113\212\113\012\113\312\
\113\312\113\012\113\312\113\212\113\012\113\212\113\313\113\213\
\113\313\113\313\113\313\113\313\113\313\113\313\113\213\113\313\
\113\313\113\313\113\313\113\313\113\313\113\314\113\314\113\314\
\113\314\113\314\113\014\113\314\113\314\113\314\113\314\113\214\
\113\315\113\315\113\215\113\315\113\315\113\315\113\315\113\315\
\113\316\113\316\113\316\113\316\113\316\113\217\113\217\113\317\
\113\320\113\320\113\320\113\220\113\320\113\320\113\221\113\322\
\113\322\113\323\113\323\113\323\113\323\113\324\114\105\114\106\
\114\112\114\114\115\006\115\013\116\200\116\104\
\116\110\116\115\117\107\117\110\117\111\117\114\117\114\117\016\
\121\015\122\206\122\306\122\007\122\310\122\013\122\315\122\226\
\125\200\125\001\125\100\125\302\125\302\125\303\125\303\125\304\
\125\304\125\304\125\304\125\304\125\304\125\104\125\305\125\305\
\125\305\125\305\125\305\125\306\125\305\125\305\125\305\125\305\
\125\306\125\306\125\306\125\306\125\306\125\306\125\306\125\006\
\125\306\125\307\125\307\125\307\125\307\125\307\125\307\125\307\
\125\307\125\307\125\307\125\307\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\
\125\312\125\312\125\312\125\312\125\312\125\312\125\312\125\313\
\125\313\125\313\125\313\125\313\125\313\125\313\125\313\125\313\
\125\313\125\314\125\314\125\314\125\315\125\314\125\314\125\314\
\125\314\125\314\125\314\125\315\125\315\125\315\125\315\125\315\
\125\315\125\315\125\315\125\316\125\316\125\315\125\317\125\317\
\125\317\125\317\125\317\125\320\125\321\125\321\125\321\125\321\
\125\322\125\322\125\322\125\323\125\323\125\027\125\334\126\300\
\126\002\126\203\126\103\126\305\126\204\126\204\126\104\126\205\
\126\205\126\205\126\105\126\006\126\206\126\206\126\206\126\206\
\126\206\126\207\126\307\126\207\126\207\126\107\126\207\126\007\
\126\210\126\010\126\210\126\211\126\211\126\311\126\211\126\212\
\126\212\126\213\126\213\126\213\126\213\126\213\
\126\213\126\114\126\214\126\114\126\114\126\214\126\316\126\217\
\127\100\127\200\127\013\130\004\130\006\132\000\132\106\133\012\
\133\013\135\203\135\104\135\105\135\205\135\206\135\207\135\111\
\135\011\136\200\136\001\136\202\136\203\136\204\136\204\136\205\
\136\205\136\205\136\207\136\207\136\210\136\110\136\210\136\210\
\136\210\136\211\136\211\136\211\136\211\136\212\136\013\136\214\
\136\215\136\215\136\215\136\216\136\216\136\216\136\217\136\224\
\137\004\140\101\140\203\140\203\140\204\140\204\140\204\140\204\
\140\205\140\205\140\205\140\206\140\205\140\205\140\205\140\106\
\140\206\140\206\140\207\140\207\140\207\140\210\140\210\140\110\
\140\211\140\211\140\211\140\211\140\211\140\211\140\212\140\213\
\140\213\140\213\140\114\140\214\140\014\140\214\
\140\214\140\214\140\214\140\215\140\215\140\216\140\216\140\016\
\140\221\140\221\141\005\142\204\142\104\142\307\142\207\142\311\
\144\004\144\007\145\001\146\302\146\302\146\303\146\203\146\103\
\146\304\146\304\146\204\146\004\146\207\146\207\146\207\146\010\
\146\311\146\112\146\313\147\100\147\003\150\003\150\004\150\004\
\150\005\150\005\150\005\150\005\150\005\150\006\150\006\150\007\
\150\007\150\007\150\007\150\010\150\010\150\010\150\010\150\010\
\150\011\150\011\150\011\150\011\150\011\150\011\150\012\150\012\
\150\012\150\012\150\012\150\012\150\013\150\013\150\014\150\014\
\150\014\150\014\150\015\150\020\150\021\152\007\152\212\152\213\
\152\213\152\215\152\115\153\203\154\004\154\005\154\005\154\014\
\154\015\155\304\155\305\155\205\155\306\155\306\
\155\307\155\307\155\310\155\310\155\110\155\310\155\110\155\311\
\155\311\155\311\155\311\155\311\155\312\155\313\155\313\155\212\
\155\314\155\314\156\007\156\007\157\003\157\004\157\106\157\107\
\157\107\157\114\160\202\160\203\160\204\160\204\160\204\160\104\
\160\204\160\205\160\205\160\205\160\206\160\207\160\207\160\110\
\160\210\160\210\160\210\160\211\160\111\160\211\160\212\160\212\
\160\212\160\212\160\212\160\213\160\213\160\213\160\214\160\214\
\160\214\160\214\160\215\160\115\160\216\160\220\160\217\161\300\
\161\204\161\205\161\205\161\106\161\206\161\207\161\211\161\212\
\161\211\161\212\161\212\161\213\161\221\162\006\163\102\163\303\
\163\004\163\304\163\304\163\206\163\306\163\307\163\307\163\307\
\163\310\163\310\163\310\163\310\163\311\163\311\
\163\312\163\313\163\013\163\314\163\314\163\314\163\315\163\315\
\163\316\163\316\164\001\164\003\164\004\164\006\164\006\164\010\
\164\011\164\012\164\013\164\013\164\013\164\014\164\016\165\102\
\165\104\165\107\165\110\165\114\166\003\166\003\166\004\166\004\
\166\005\166\005\166\005\166\005\166\005\166\005\166\005\166\006\
\166\007\166\006\166\006\166\006\166\007\166\007\166\007\166\007\
\166\007\166\010\166\010\166\010\166\010\166\011\166\011\166\011\
\166\011\166\011\166\011\166\011\166\012\166\012\166\012\166\012\
\166\012\166\012\166\013\166\013\166\013\166\013\166\013\166\014\
\166\015\166\016\166\017\166\020\166\021\166\020\166\023\166\023\
\166\024\166\024\167\103\167\205\167\206\167\007\167\006\167\210\
\167\210\167\210\167\011\167\211\167\211\167\211\
\167\211\167\212\167\212\167\214\167\214\167\215\167\217\167\120\
\170\203\170\203\170\204\170\204\170\204\170\205\170\205\170\205\
\170\205\170\205\170\205\170\206\170\206\170\206\170\206\170\206\
\170\206\170\206\170\206\170\207\170\207\170\207\170\207\170\207\
\170\207\170\210\170\210\170\210\170\210\170\210\170\210\170\210\
\170\211\170\211\170\211\170\211\170\211\170\211\170\212\170\212\
\170\212\170\212\170\212\170\012\170\213\170\213\170\213\170\215\
\170\215\170\216\170\217\170\017\170\220\170\220\170\223\170\223\
\171\104\171\204\171\205\171\206\171\112\171\113\171\220\172\000\
\172\100\172\200\172\204\172\205\172\206\172\207\172\210\172\214\
\172\214\173\100\214\106\173\104\173\104\173\204\173\205\173\211\
\174\004\174\304\174\105\174\110\174\211\174\112\
\174\313\175\000\175\006\175\105\176\003\176\003\177\004\177\010\
\177\013\177\017\200\205\200\211\200\113\200\214\200\116\202\203\
\202\303\202\304\202\304\202\304\202\305\202\305\202\305\202\305\
\202\305\202\306\202\306\202\306\202\306\202\306\202\307\202\307\
\202\307\202\307\202\307\202\307\202\307\202\310\202\310\202\310\
\202\311\202\311\202\312\202\312\202\312\202\312\202\312\202\313\
\202\314\202\315\202\315\202\217\202\320\203\000\203\102\203\112\
\204\004\206\100\206\002\206\003\206\106\206\006\207\007\207\014\
\211\003\211\003\211\004\211\005\211\005\211\006\211\007\211\007\
\211\007\211\010\211\010\211\010\211\011\211\011\211\012\211\013\
\211\013\211\015\211\017\214\100\214\100\214\200\214\200\214\302\
\214\302\214\303\214\303\214\303\214\304\214\304\
\214\304\214\304\214\304\214\304\214\305\214\305\214\305\214\305\
\214\306\214\305\214\306\214\306\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\307\214\306\214\307\214\307\214\307\
\214\307\214\307\214\310\214\110\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\210\214\310\214\311\214\311\214\311\
\214\311\214\311\214\311\214\311\214\311\214\311\214\311\214\311\
\214\311\214\311\214\211\214\312\214\312\214\312\214\312\214\312\
\214\312\214\312\214\314\214\312\214\313\214\313\214\313\214\313\
\214\313\214\313\214\313\214\313\214\313\214\313\214\313\214\313\
\214\313\214\313\214\314\214\314\214\313\214\314\214\314\214\314\
\214\314\214\314\214\314\214\314\214\315\214\315\214\315\214\315\
\214\315\214\315\214\315\214\315\214\315\214\316\
\214\316\214\316\214\316\214\316\214\315\214\316\214\317\214\317\
\214\317\214\317\214\317\214\320\214\320\214\320\214\321\214\321\
\214\321\214\321\214\322\214\323\214\323\214\323\214\323\214\325\
\215\004\215\105\216\303\216\303\216\003\216\304\216\204\216\304\
\216\304\216\305\216\304\216\304\216\305\216\305\216\305\216\305\
\216\305\216\306\216\306\216\206\216\306\216\306\216\207\216\307\
\216\207\216\307\216\307\216\307\216\310\216\310\216\310\216\310\
\216\310\216\310\216\310\216\310\216\310\216\311\216\311\216\311\
\216\211\216\311\216\311\216\212\216\012\216\312\216\312\216\312\
\216\312\216\312\216\212\216\313\216\313\216\313\216\113\216\313\
\216\314\216\314\216\114\216\314\216\314\216\314\216\314\216\314\
\216\314\216\215\216\015\216\315\216\315\216\320\
\216\321\216\021\216\324\217\003\217\016\220\007\220\012\221\300\
\221\303\221\303\221\303\221\304\221\304\221\205\221\306\221\306\
\221\306\221\306\221\207\221\307\221\307\221\307\221\207\221\310\
\221\310\221\310\221\010\221\312\221\313\221\313\221\313\221\313\
\221\314\221\314\221\315\221\315\222\200\222\121\223\004\223\207\
\223\213\223\214\224\104\224\104\224\107\224\111\224\011\224\012\
\224\117\224\122\225\202\225\203\225\103\225\204\225\204\225\205\
\225\106\225\205\225\205\225\205\225\207\225\207\225\210\225\010\
\225\210\225\211\225\211\225\211\225\212\225\112\225\212\225\212\
\225\213\225\214\225\014\225\214\225\215\225\016\225\217\225\217\
\225\120\225\221\225\221\225\224\225\224\226\204\226\205\226\207\
\226\110\226\212\226\220\227\203\227\212\227\025\
\230\003\230\207\230\211\230\012\231\005\231\010\231\011\231\013\
\231\014\231\021\232\203\232\207\232\207\232\210\232\110\232\211\
\232\211\232\214\232\214\232\214\233\011\234\105\234\107\234\111\
\235\200\235\205\235\205\235\205\235\206\235\207\235\207\235\207\
\235\207\235\210\235\210\235\210\235\210\235\210\235\210\235\211\
\235\211\235\211\235\211\235\212\235\113\235\213\235\214\235\214\
\235\214\235\220\235\221\236\004\236\007\236\007\236\010\236\010\
\236\014\237\103\237\103\237\104\237\105\237\106\237\106\237\106\
\237\110\237\110\237\112\237\113\237\115\240\001\240\010\241\014\
\242\100\242\200\242\103\242\203\242\203\242\204\242\204\242\204\
\242\205\242\204\242\205\242\205\242\206\242\206\242\206\242\207\
\242\210\242\111\242\211\242\211\242\212\242\214\
\242\214\242\215\242\217\242\223\243\100\243\104\243\104\243\105\
\243\105\243\106\243\106\243\107\243\107\243\107\243\110\243\010\
\243\110\243\110\243\110\243\111\243\111\243\111\243\111\243\113\
\243\113\243\113\243\115\243\116\243\117\243\122\243\123\244\204\
\244\204\244\205\244\205\244\207\244\207\244\210\244\211\244\212\
\244\214\244\215\244\215\244\223\244\223\247\202\247\203\247\203\
\247\203\247\203\247\204\247\204\247\204\247\204\247\105\247\205\
\247\205\247\205\247\205\247\205\247\205\247\205\247\205\247\205\
\247\205\247\205\247\205\247\205\247\206\247\206\247\206\247\206\
\247\206\247\206\247\206\247\206\247\206\247\206\247\206\247\206\
\247\207\247\207\247\207\247\207\247\207\247\107\247\207\247\207\
\247\207\247\207\247\207\247\207\247\210\247\210\
\247\210\247\210\247\210\247\110\247\210\247\210\247\210\247\210\
\247\210\247\210\247\210\247\211\247\211\247\211\247\211\247\211\
\247\211\247\111\247\211\247\111\247\211\247\212\247\212\247\212\
\247\212\247\112\247\212\247\212\247\213\247\213\247\213\247\213\
\247\213\247\213\247\213\247\113\247\214\247\214\247\214\247\214\
\247\215\247\215\247\215\247\215\247\216\247\217\247\217\247\221\
\247\221\250\100\250\103\251\003\251\004\251\004\251\006\251\007\
\251\007\251\011\251\012\251\023\252\204\252\204\252\204\252\204\
\252\205\252\205\252\205\252\207\252\210\252\211\252\212\252\213\
\252\214\252\215\252\215\252\216\252\117\254\002\254\102\254\205\
\254\210\254\011\254\011\254\212\254\213\255\110\255\112\255\112\
\255\115\255\117\255\120\256\005\256\006\256\010\
\261\102\261\106\261\107\261\107\261\110\261\110\261\111\261\112\
\261\112\261\112\262\103\262\006\262\110\262\111\262\011\262\112\
\263\010\265\102\265\104\265\104\265\105\265\105\265\105\265\106\
\265\106\265\107\265\107\265\107\265\110\265\114\266\304\266\305\
\266\305\266\106\266\310\266\311\266\212\266\312\266\212\266\313\
\266\314\266\315\270\200\270\300\270\002\270\302\270\303\270\304\
\270\304\270\004\270\305\270\106\270\206\270\107\270\307\270\307\
\270\210\270\310\270\310\270\310\270\311\270\311\270\311\270\311\
\270\312\270\312\270\312\270\312\270\312\270\313\270\314\270\314\
\270\116\270\321\270\323\272\110\272\112\273\204\273\004\273\204\
\273\204\273\205\273\205\273\205\273\205\273\206\273\206\273\207\
\273\207\273\210\273\210\273\111\273\211\273\211\
\273\212\273\212\273\213\273\215\273\015\273\030\274\004\274\005\
\274\005\274\006\274\006\274\011\274\012\274\014\274\014\274\016\
\275\003\275\010\276\002\276\004\276\004\276\010\276\011\276\012\
\276\012\276\013\276\014\277\014\301\006\302\203\302\205\302\210\
\303\204\303\204\303\204\303\204\303\204\303\204\303\204\303\206\
\303\206\303\206\303\207\303\207\303\206\303\207\303\207\303\207\
\303\210\303\210\303\210\303\210\303\210\303\210\303\210\303\210\
\303\210\303\211\303\211\303\211\303\211\303\211\303\211\303\210\
\303\211\303\212\303\212\303\012\303\212\303\212\303\213\303\213\
\303\213\303\213\303\213\303\215\303\214\303\114\303\214\303\214\
\303\214\303\214\303\214\303\214\303\115\303\215\303\215\303\215\
\303\216\303\215\303\216\303\217\303\217\303\223\
\304\101\304\303\304\304\304\304\304\304\304\205\304\305\304\305\
\304\306\304\306\304\106\304\306\304\306\304\306\304\307\304\207\
\304\307\304\207\304\310\304\310\304\310\304\310\304\310\304\310\
\304\310\304\310\304\310\304\311\304\311\304\211\304\312\304\312\
\304\312\304\312\304\112\304\312\304\213\304\313\304\213\304\313\
\304\314\304\314\304\315\304\315\304\315\304\316\304\321\304\322\
\304\323\305\112\306\000\306\302\306\205\306\311\307\104\307\007\
\310\003\313\205\313\206\313\110\313\211\315\104\315\105\315\006\
\315\106\317\006\317\010\320\207\320\212\320\117\321\002\321\005\
\321\012\321\012\323\301\323\303\323\304\323\105\323\305\323\006\
\323\306\323\107\323\310\323\310\323\311\325\004\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\
")


;;; get/set char's annotation
(defun skk-tankan-get-char-annotation (char)
  (and skk-tankan-annotation-table
       (aref skk-tankan-annotation-table char)))

(defun skk-tankan-set-char-annotaion (char annotation)
  (aset skk-tankan-annotation-table char annotation))

;;; get stroke for radical part
(defun skk-tankan-stroke-for-radical (radical dat)
  (let ((v (aref skk-tankan-stroke-for-radical-vector radical)))
    (if (integerp v)
	v
      (nth (lsh dat -6) v))))

;;; get char's radical, strokes in radical, total strokes
(defun skk-tankan-get-char-data (char)
  (let ((fun (cdr (assq (char-charset char)
			skk-tankan-get-char-data-functions))))
    (or (and fun (funcall fun char))
	(list 0 0 0))))

(defun skk-tankan-get-char-data-0213-1 (char)
  (skk-tankan-get-char-data-internal char (function skk-tankan-encode-0213-1)
				     skk-tankan-radical-stroke-table-0213-1))

(defun skk-tankan-get-char-data-0213-2 (char)
  (skk-tankan-get-char-data-internal char (function skk-tankan-encode-0213-2)
				     skk-tankan-radical-stroke-table-0213-2))

(defun skk-tankan-get-char-data-internal (char encoder table)
  (let* ((n (funcall encoder char))
	 radical dat stroke)
    (if (null n)
	nil
      (setq n (* 2 n)
	    radical (aref table n)
	    dat (aref table (1+ n))
	    stroke (logand 63 dat))
      (list radical stroke
	    (+ stroke (skk-tankan-stroke-for-radical radical dat))))))

(defun skk-tankan-encode-0213-1 (char)
  (let* ((l (split-char char))
	 (n (+ (* 94 (- (nth 1 l) ?! 13)) (- (nth 2 l) ?!))))
    (and (>= n 0) n)))

(defun skk-tankan-encode-0213-2 (char)
  (let* ((l (split-char char))
	 (ku (- (nth 1 l) ?!))
	 (tmp (if (>= ku 77)
		  (- ku 68)
		(cdr (assq ku '((0 . 0) (2 . 1) (3 . 2) (4 . 3) (7 . 4)
				(11 . 5) (12 . 6) (13 . 7) (14 . 8)))))))
    (and tmp
	 (+ (* 94 tmp) (- (nth 2 l) ?!)))))

(defun skk-tankan-search (func &rest args)
  (when (string-match (format "%s$" (regexp-quote
				     (char-to-string skk-tankan-search-key)))
		      skk-henkan-key)
    (let ((skk-henkan-key (substring skk-henkan-key 0 (match-beginning 0)))
	  lis top tmp)
      ;; get KOUHO list
      (setq lis (cons nil (apply func args))
	    top lis)
      ;; select TANKANJI KOUHO
      (while (cdr lis)
	;; remove annotation
	(setq tmp (nth 1 lis))
	(if (string-match ";" tmp)
	    (setq tmp (substring tmp 0 (match-beginning 0))))
	(if (not (string-match "^.$" tmp))
	    (setcdr lis (cdr (cdr lis)))
	  (setq lis (cdr lis))
	  (setq tmp (string-to-char tmp)
		tmp (cons tmp (cons (skk-tankan-get-char-annotation tmp)
				    (skk-tankan-get-char-data tmp))))
	  (setcar lis tmp)))
      ;; sort KOUHO by KAKUSUU(or BUSYU)
      (setq lis  (sort (cdr top)
		       (lambda (x y)
			 (let ((xa (nth 2 x)) (xb (nth 3 x)) (xc (nth 4 x))
			       (ya (nth 2 y)) (yb (nth 3 y)) (yc (nth 4 y)))
			   (if (= xc yc)
			       (if (= xa ya)
				   (if (= xb yb)
				       (< (car x) (car y))
				     (< xb yb))
				 (< xa ya))
			     (< xc yc))))))
      ;; return list with annotation
      (mapcar (lambda (cell)
		(let ((anno (if (= 0 (nth 2 cell))
				(nth 1 cell)
			      (format "%d(%s%d)%s"
				      (nth 4 cell)
				      (aref skk-tankan-radical-vector
					    (nth 2 cell))
				      (nth 3 cell)
				      (or (nth 1 cell) "")
				      ))))
		  (if (= 0 (length anno))
		      (char-to-string (car cell))
		    (concat (char-to-string (car cell)) ";" anno))))
	      lis))))


;;; annotation data for japanese-jisx0208
(when skk-tankan-annotation-table
  (let ((l '(

(? "»ֳ,IDEOGRAPHIC SPACE")
(? ",IDEOGRAPHIC COMMA")
(? ",IDEOGRAPHIC FULL STOP")
(? ",COMMA")
(? "ԥꥪ,FULL STOP")
(? ",KATAKANA MIDDLE DOT")
(? ",COLON")
(? "ߥ,SEMICOLON")
(? ",QUESTION MARK")
(? "ò,EXCLAMATION MARK")
(? ",KATAKANA-HIRAGANA VOICED SOUND MARK")
(? "Ⱦ,KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK")
(? "ƥ,塼ȥ,ץ饤൭,ACUTE ACCENT")
(? "󥰥顼,졼֥,GRAVE ACCENT")
(? "饦,쥷,DIAERESIS")
(? "󥷥륳եå,եå,CIRCUMFLEX ACCENT")
(? "С饤,국,OVERLINE")
(? "饤,LOW LINE")
(? "Ҳ֤̾,KATAKANA ITERATION MARK")
(? "Ҳ֤̾(),KATAKANA VOICED ITERATION MARK")
(? "ʿ֤̾,HIRAGANA ITERATION MARK")
(? "ʿ֤̾(),HIRAGANA VOICED ITERATION MARK")
(? "Ʊ,DITTO MARK")
(? "Ʊ嵭,CJK UNIFIED IDEOGRAPH-4EDD")
(? "֤,IDEOGRAPHIC ITERATION MARK")
(? ",IDEOGRAPHIC CLOSING MARK")
(? ",IDEOGRAPHIC NUMBER ZERO")
(? "Ĺ,KATAKANA-HIRAGANA PROLONGED SOUND MARK")
(? "å(),EM DASH")
(? "ϥե(ʬ),HYPHEN")
(? ",SOLIDUS")
(? "ռ,REVERSE SOLIDUS")
(? "ȥå,WAVE DASH")
(? ",DOUBLE VERTICAL LINE")
(? ",VERTICAL LINE")
(? "꡼,HORIZONTAL ELLIPSIS")
(? "꡼,TWO DOT LEADER")
(? "󥰥,󥰥륯ơޡ,LEFT SINGLE QUOTATION MARK")
(? "󥰥,󥰥륯ơޡ,RIGHT SINGLE QUOTATION MARK")
(? "֥,֥륯ơޡ,LEFT DOUBLE QUOTATION MARK")
(? "֥,֥륯ơޡ,RIGHT DOUBLE QUOTATION MARK")
(? "Ϥᾮ,Ϥݳ,LEFT PARENTHESIS")
(? "꾮,ݳ,RIGHT PARENTHESIS")
(? "Ϥ᤭ä(),LEFT TORTOISE SHELL BRACKET")
(? "꤭ä(),RIGHT TORTOISE SHELL BRACKET")
(? "Ϥ,Ϥѳ,LEFT SQUARE BRACKET")
(? ",ѳ,RIGHT SQUARE BRACKET")
(? "Ϥ,Ϥȳ,LEFT CURLY BRACKET")
(? ",ȳ,RIGHT CURLY BRACKET")
(? "Ϥỳ,LEFT ANGLE BRACKET")
(? "껳,RIGHT ANGLE BRACKET")
(? "ϤŻ,LEFT DOUBLE ANGLE BRACKET")
(? "Ż,RIGHT DOUBLE ANGLE BRACKET")
(? "Ϥᤫ,LEFT CORNER BRACKET")
(? "꤫,RIGHT CORNER BRACKET")
(? "ϤŤ,LEFT WHITE CORNER BRACKET")
(? "Ť,RIGHT WHITE CORNER BRACKET")
(? "Ϥ᤹դ,LEFT BLACK LENTICULAR BRACKET")
(? "ꤹդ,RIGHT BLACK LENTICULAR BRACKET")
(? ",û,PLUS SIGN")
(? ",,MINUS SIGN")
(? ",PLUS-MINUS SIGN")
(? "軻,MULTIPLICATION SIGN")
(? ",DIVISION SIGN")
(? ",EQUALS SIGN")
(? ",NOT EQUAL TO")
(? "(꾮),LESS-THAN SIGN")
(? "(),GREATER-THAN SIGN")
(? "꾮,LESS-THAN OVER EQUAL TO")
(? "礭,GREATER-THAN OVER EQUAL TO")
(? "̵,INFINITY")
(? "椨,THEREFORE")
(? "ͺ,MALE SIGN")
(? "󵭹,FEMALE SIGN")
(? ",DEGREE SIGN")
(? "ʬ,PRIME")
(? ",DOUBLE PRIME")
(? "ٵ,DEGREE CELSIUS")
(? "ߵ,YEN SIGN")
(? "ɥ뵭,DOLLAR SIGN")
(? "ȵ,CENT SIGN")
(? "ݥɵ,POUND SIGN")
(? "ѡȵ,PERCENT SIGN")
(? "ֹ浭,椲,NUMBER SIGN")
(? "ѥ,AMPERSAND")
(? ",ƥꥹ,ASTERISK")
(? "ñ,COMMERCIAL AT")
(? "ᵭ,SECTION SIGN")
(? ",WHITE STAR")
(? ",BLACK STAR")
(? "ݰ,,WHITE CIRCLE")
(? ",BLACK CIRCLE")
(? "Ŵ,BULLSEYE")
(? "Ҥ,WHITE DIAMOND")
(? "Ҥ,BLACK DIAMOND")
(? "ͳ,WHITE SQUARE")
(? "ͳ,BLACK SQUARE")
(? ",WHITE UP-POINTING TRIANGLE")
(? ",BLACK UP-POINTING TRIANGLE")
(? "ջ,WHITE DOWN-POINTING TRIANGLE")
(? "չ,BLACK DOWN-POINTING TRIANGLE")
(? "ư,REFERENCE MARK")
(? "͹ص,POSTAL MARK")
(? ",RIGHTWARDS ARROW")
(? ",LEFTWARDS ARROW")
(? ",UPWARDS ARROW")
(? ",DOWNWARDS ARROW")
(? ",GETA MARK")
(? "°,ELEMENT OF")
(? "Ȥƴޤ,CONTAINS AS MEMBER")
(? "ʬ,SUBSET OF OR EQUAL TO")
(? "ʬ(),SUPERSET OF OR EQUAL TO")
(? "ʬ,SUBSET OF")
(? "ʬ(),SUPERSET OF")
(? "ʻ,UNION")
(? "̽,INTERSECTION")
(? "ڤ(),LOGICAL AND")
(? "(Υ),LOGICAL OR")
(? ",NOT SIGN")
(? "ʤ(ް),RIGHTWARDS DOUBLE ARROW")
(? "Ʊ,LEFT RIGHT DOUBLE ARROW")
(? "٤Ƥ(̸),FOR ALL")
(? "¸ߤ(¸߸),THERE EXISTS")
(? ",ANGLE")
(? "ľ,UP TACK")
(? ",ARC")
(? "ǥ,饦ɥǥ,PARTIAL DIFFERENTIAL")
(? "ʥ֥,NABLA")
(? ",Ʊ,IDENTICAL TO")
(? "ۤȤ,APPROXIMATELY EQUAL TO OR THE IMAGE OF")
(? "˾,MUCH LESS-THAN")
(? "礭,MUCH GREATER-THAN")
(? ",SQUARE ROOT")
(? ",REVERSED TILDE")
(? ",PROPORTIONAL TO")
(? "ʤʤ,BECAUSE")
(? "ʬ,INTEGRAL")
(? "2ʬ,DOUBLE INTEGRAL")
(? "󥰥ȥ,ANGSTROM SIGN")
(? "ѡߥ,PER MILLE SIGN")
(? "㡼,MUSIC SHARP SIGN")
(? "եå,MUSIC FLAT SIGN")
(? ",EIGHTH NOTE")
(? ",DAGGER")
(? "֥,DOUBLE DAGGER")
(? ",PILCROW SIGN")
(? "礭ʴ,LARGE CIRCLE")
(? "0,DIGIT ZERO")
(? "1,DIGIT ONE")
(? "2,DIGIT TWO")
(? "3,DIGIT THREE")
(? "4,DIGIT FOUR")
(? "5,DIGIT FIVE")
(? "6,DIGIT SIX")
(? "7,DIGIT SEVEN")
(? "8,DIGIT EIGHT")
(? "9,DIGIT NINE")
(? "ƥʸA,LATIN CAPITAL LETTER A")
(? "ƥʸB,LATIN CAPITAL LETTER B")
(? "ƥʸC,LATIN CAPITAL LETTER C")
(? "ƥʸD,LATIN CAPITAL LETTER D")
(? "ƥʸE,LATIN CAPITAL LETTER E")
(? "ƥʸF,LATIN CAPITAL LETTER F")
(? "ƥʸG,LATIN CAPITAL LETTER G")
(? "ƥʸH,LATIN CAPITAL LETTER H")
(? "ƥʸI,LATIN CAPITAL LETTER I")
(? "ƥʸJ,LATIN CAPITAL LETTER J")
(? "ƥʸK,LATIN CAPITAL LETTER K")
(? "ƥʸL,LATIN CAPITAL LETTER L")
(? "ƥʸM,LATIN CAPITAL LETTER M")
(? "ƥʸN,LATIN CAPITAL LETTER N")
(? "ƥʸO,LATIN CAPITAL LETTER O")
(? "ƥʸP,LATIN CAPITAL LETTER P")
(? "ƥʸQ,LATIN CAPITAL LETTER Q")
(? "ƥʸR,LATIN CAPITAL LETTER R")
(? "ƥʸS,LATIN CAPITAL LETTER S")
(? "ƥʸT,LATIN CAPITAL LETTER T")
(? "ƥʸU,LATIN CAPITAL LETTER U")
(? "ƥʸV,LATIN CAPITAL LETTER V")
(? "ƥʸW,LATIN CAPITAL LETTER W")
(? "ƥʸX,LATIN CAPITAL LETTER X")
(? "ƥʸY,LATIN CAPITAL LETTER Y")
(? "ƥʸZ,LATIN CAPITAL LETTER Z")
(? "ƥʸA,LATIN SMALL LETTER A")
(? "ƥʸB,LATIN SMALL LETTER B")
(? "ƥʸC,LATIN SMALL LETTER C")
(? "ƥʸD,LATIN SMALL LETTER D")
(? "ƥʸE,LATIN SMALL LETTER E")
(? "ƥʸF,LATIN SMALL LETTER F")
(? "ƥʸG,LATIN SMALL LETTER G")
(? "ƥʸH,LATIN SMALL LETTER H")
(? "ƥʸI,LATIN SMALL LETTER I")
(? "ƥʸJ,LATIN SMALL LETTER J")
(? "ƥʸK,LATIN SMALL LETTER K")
(? "ƥʸL,LATIN SMALL LETTER L")
(? "ƥʸM,LATIN SMALL LETTER M")
(? "ƥʸN,LATIN SMALL LETTER N")
(? "ƥʸO,LATIN SMALL LETTER O")
(? "ƥʸP,LATIN SMALL LETTER P")
(? "ƥʸQ,LATIN SMALL LETTER Q")
(? "ƥʸR,LATIN SMALL LETTER R")
(? "ƥʸS,LATIN SMALL LETTER S")
(? "ƥʸT,LATIN SMALL LETTER T")
(? "ƥʸU,LATIN SMALL LETTER U")
(? "ƥʸV,LATIN SMALL LETTER V")
(? "ƥʸW,LATIN SMALL LETTER W")
(? "ƥʸX,LATIN SMALL LETTER X")
(? "ƥʸY,LATIN SMALL LETTER Y")
(? "ƥʸZ,LATIN SMALL LETTER Z")
(? "ʿ̾,HIRAGANA LETTER SMALL A")
(? "ʿ̾,HIRAGANA LETTER A")
(? "ʿ̾,HIRAGANA LETTER SMALL I")
(? "ʿ̾,HIRAGANA LETTER I")
(? "ʿ̾,HIRAGANA LETTER SMALL U")
(? "ʿ̾,HIRAGANA LETTER U")
(? "ʿ̾,HIRAGANA LETTER SMALL E")
(? "ʿ̾,HIRAGANA LETTER E")
(? "ʿ̾,HIRAGANA LETTER SMALL O")
(? "ʿ̾,HIRAGANA LETTER O")
(? "ʿ̾,HIRAGANA LETTER KA")
(? "դʿ̾,HIRAGANA LETTER GA")
(? "ʿ̾,HIRAGANA LETTER KI")
(? "դʿ̾,HIRAGANA LETTER GI")
(? "ʿ̾,HIRAGANA LETTER KU")
(? "դʿ̾,HIRAGANA LETTER GU")
(? "ʿ̾,HIRAGANA LETTER KE")
(? "դʿ̾,HIRAGANA LETTER GE")
(? "ʿ̾,HIRAGANA LETTER KO")
(? "դʿ̾,HIRAGANA LETTER GO")
(? "ʿ̾,HIRAGANA LETTER SA")
(? "դʿ̾,HIRAGANA LETTER ZA")
(? "ʿ̾,HIRAGANA LETTER SI")
(? "դʿ̾,HIRAGANA LETTER ZI")
(? "ʿ̾,HIRAGANA LETTER SU")
(? "դʿ̾,HIRAGANA LETTER ZU")
(? "ʿ̾,HIRAGANA LETTER SE")
(? "դʿ̾,HIRAGANA LETTER ZE")
(? "ʿ̾,HIRAGANA LETTER SO")
(? "դʿ̾,HIRAGANA LETTER ZO")
(? "ʿ̾,HIRAGANA LETTER TA")
(? "դʿ̾,HIRAGANA LETTER DA")
(? "ʿ̾,HIRAGANA LETTER TI")
(? "դʿ̾,HIRAGANA LETTER DI")
(? "ʿ̾,HIRAGANA LETTER SMALL TU")
(? "ʿ̾,HIRAGANA LETTER TU")
(? "դʿ̾,HIRAGANA LETTER DU")
(? "ʿ̾,HIRAGANA LETTER TE")
(? "դʿ̾,HIRAGANA LETTER DE")
(? "ʿ̾,HIRAGANA LETTER TO")
(? "դʿ̾,HIRAGANA LETTER DO")
(? "ʿ̾,HIRAGANA LETTER NA")
(? "ʿ̾,HIRAGANA LETTER NI")
(? "ʿ̾,HIRAGANA LETTER NU")
(? "ʿ̾,HIRAGANA LETTER NE")
(? "ʿ̾,HIRAGANA LETTER NO")
(? "ʿ̾,HIRAGANA LETTER HA")
(? "դʿ̾,HIRAGANA LETTER BA")
(? "Ⱦդʿ̾,HIRAGANA LETTER PA")
(? "ʿ̾,HIRAGANA LETTER HI")
(? "դʿ̾,HIRAGANA LETTER BI")
(? "Ⱦդʿ̾,HIRAGANA LETTER PI")
(? "ʿ̾,HIRAGANA LETTER HU")
(? "դʿ̾,HIRAGANA LETTER BU")
(? "Ⱦդʿ̾,HIRAGANA LETTER PU")
(? "ʿ̾,HIRAGANA LETTER HE")
(? "դʿ̾,HIRAGANA LETTER BE")
(? "Ⱦդʿ̾,HIRAGANA LETTER PE")
(? "ʿ̾,HIRAGANA LETTER HO")
(? "դʿ̾,HIRAGANA LETTER BO")
(? "Ⱦդʿ̾,HIRAGANA LETTER PO")
(? "ʿ̾,HIRAGANA LETTER MA")
(? "ʿ̾,HIRAGANA LETTER MI")
(? "ʿ̾,HIRAGANA LETTER MU")
(? "ʿ̾,HIRAGANA LETTER ME")
(? "ʿ̾,HIRAGANA LETTER MO")
(? "ʿ̾,HIRAGANA LETTER SMALL YA")
(? "ʿ̾,HIRAGANA LETTER YA")
(? "ʿ̾,HIRAGANA LETTER SMALL YU")
(? "ʿ̾,HIRAGANA LETTER YU")
(? "ʿ̾,HIRAGANA LETTER SMALL YO")
(? "ʿ̾,HIRAGANA LETTER YO")
(? "ʿ̾,HIRAGANA LETTER RA")
(? "ʿ̾,HIRAGANA LETTER RI")
(? "ʿ̾,HIRAGANA LETTER RU")
(? "ʿ̾,HIRAGANA LETTER RE")
(? "ʿ̾,HIRAGANA LETTER RO")
(? "ʿ̾,HIRAGANA LETTER SMALL WA")
(? "ʿ̾,HIRAGANA LETTER WA")
(? "ʿ̾,HIRAGANA LETTER WI")
(? "ʿ̾,HIRAGANA LETTER WE")
(? "ʿ̾,HIRAGANA LETTER WO")
(? "ʿ̾,HIRAGANA LETTER N")
(? "Ҳ̾,KATAKANA LETTER SMALL A")
(? "Ҳ̾,KATAKANA LETTER A")
(? "Ҳ̾,KATAKANA LETTER SMALL I")
(? "Ҳ̾,KATAKANA LETTER I")
(? "Ҳ̾,KATAKANA LETTER SMALL U")
(? "Ҳ̾,KATAKANA LETTER U")
(? "Ҳ̾,KATAKANA LETTER SMALL E")
(? "Ҳ̾,KATAKANA LETTER E")
(? "Ҳ̾,KATAKANA LETTER SMALL O")
(? "Ҳ̾,KATAKANA LETTER O")
(? "Ҳ̾,KATAKANA LETTER KA")
(? "դҲ̾,KATAKANA LETTER GA")
(? "Ҳ̾,KATAKANA LETTER KI")
(? "դҲ̾,KATAKANA LETTER GI")
(? "Ҳ̾,KATAKANA LETTER KU")
(? "դҲ̾,KATAKANA LETTER GU")
(? "Ҳ̾,KATAKANA LETTER KE")
(? "դҲ̾,KATAKANA LETTER GE")
(? "Ҳ̾,KATAKANA LETTER KO")
(? "դҲ̾,KATAKANA LETTER GO")
(? "Ҳ̾,KATAKANA LETTER SA")
(? "դҲ̾,KATAKANA LETTER ZA")
(? "Ҳ̾,KATAKANA LETTER SI")
(? "դҲ̾,KATAKANA LETTER ZI")
(? "Ҳ̾,KATAKANA LETTER SU")
(? "դҲ̾,KATAKANA LETTER ZU")
(? "Ҳ̾,KATAKANA LETTER SE")
(? "դҲ̾,KATAKANA LETTER ZE")
(? "Ҳ̾,KATAKANA LETTER SO")
(? "դҲ̾,KATAKANA LETTER ZO")
(? "Ҳ̾,KATAKANA LETTER TA")
(? "դҲ̾,KATAKANA LETTER DA")
(? "Ҳ̾,KATAKANA LETTER TI")
(? "դҲ̾,KATAKANA LETTER DI")
(? "Ҳ̾,KATAKANA LETTER SMALL TU")
(? "Ҳ̾,KATAKANA LETTER TU")
(? "դҲ̾,KATAKANA LETTER DU")
(? "Ҳ̾,KATAKANA LETTER TE")
(? "դҲ̾,KATAKANA LETTER DE")
(? "Ҳ̾,KATAKANA LETTER TO")
(? "դҲ̾,KATAKANA LETTER DO")
(? "Ҳ̾,KATAKANA LETTER NA")
(? "Ҳ̾,KATAKANA LETTER NI")
(? "Ҳ̾,KATAKANA LETTER NU")
(? "Ҳ̾,KATAKANA LETTER NE")
(? "Ҳ̾,KATAKANA LETTER NO")
(? "Ҳ̾,KATAKANA LETTER HA")
(? "դҲ̾,KATAKANA LETTER BA")
(? "ȾդҲ̾,KATAKANA LETTER PA")
(? "Ҳ̾,KATAKANA LETTER HI")
(? "դҲ̾,KATAKANA LETTER BI")
(? "ȾդҲ̾,KATAKANA LETTER PI")
(? "Ҳ̾,KATAKANA LETTER HU")
(? "դҲ̾,KATAKANA LETTER BU")
(? "ȾդҲ̾,KATAKANA LETTER PU")
(? "Ҳ̾,KATAKANA LETTER HE")
(? "դҲ̾,KATAKANA LETTER BE")
(? "ȾդҲ̾,KATAKANA LETTER PE")
(? "Ҳ̾,KATAKANA LETTER HO")
(? "դҲ̾,KATAKANA LETTER BO")
(? "ȾդҲ̾,KATAKANA LETTER PO")
(? "Ҳ̾,KATAKANA LETTER MA")
(? "Ҳ̾,KATAKANA LETTER MI")
(? "Ҳ̾,KATAKANA LETTER MU")
(? "Ҳ̾,KATAKANA LETTER ME")
(? "Ҳ̾,KATAKANA LETTER MO")
(? "Ҳ̾,KATAKANA LETTER SMALL YA")
(? "Ҳ̾,KATAKANA LETTER YA")
(? "Ҳ̾,KATAKANA LETTER SMALL YU")
(? "Ҳ̾,KATAKANA LETTER YU")
(? "Ҳ̾,KATAKANA LETTER SMALL YO")
(? "Ҳ̾,KATAKANA LETTER YO")
(? "Ҳ̾,KATAKANA LETTER RA")
(? "Ҳ̾,KATAKANA LETTER RI")
(? "Ҳ̾,KATAKANA LETTER RU")
(? "Ҳ̾,KATAKANA LETTER RE")
(? "Ҳ̾,KATAKANA LETTER RO")
(? "Ҳ̾,KATAKANA LETTER SMALL WA")
(? "Ҳ̾,KATAKANA LETTER WA")
(? "Ҳ̾,KATAKANA LETTER WI")
(? "Ҳ̾,KATAKANA LETTER WE")
(? "Ҳ̾,KATAKANA LETTER WO")
(? "Ҳ̾,KATAKANA LETTER N")
(? "դҲ̾,KATAKANA LETTER VU")
(? "Ҳ̾,KATAKANA LETTER SMALL KA")
(? "Ҳ̾,KATAKANA LETTER SMALL KE")
(? "ꥷʸALPHA,GREEK CAPITAL LETTER ALPHA")
(? "ꥷʸBETA,GREEK CAPITAL LETTER BETA")
(? "ꥷʸGAMMA,GREEK CAPITAL LETTER GAMMA")
(? "ꥷʸDELTA,GREEK CAPITAL LETTER DELTA")
(? "ꥷʸEPSILON,GREEK CAPITAL LETTER EPSILON")
(? "ꥷʸZETA,GREEK CAPITAL LETTER ZETA")
(? "ꥷʸETA,GREEK CAPITAL LETTER ETA")
(? "ꥷʸTHETA,GREEK CAPITAL LETTER THETA")
(? "ꥷʸIOTA,GREEK CAPITAL LETTER IOTA")
(? "ꥷʸKAPPA,GREEK CAPITAL LETTER KAPPA")
(? "ꥷʸLAMBDA,GREEK CAPITAL LETTER LAMBDA")
(? "ꥷʸMU,GREEK CAPITAL LETTER MU")
(? "ꥷʸNU,GREEK CAPITAL LETTER NU")
(? "ꥷʸXI,GREEK CAPITAL LETTER XI")
(? "ꥷʸOMICRON,GREEK CAPITAL LETTER OMICRON")
(? "ꥷʸPI,GREEK CAPITAL LETTER PI")
(? "ꥷʸRHO,GREEK CAPITAL LETTER RHO")
(? "ꥷʸSIGMA,GREEK CAPITAL LETTER SIGMA")
(? "ꥷʸTAU,GREEK CAPITAL LETTER TAU")
(? "ꥷʸUPSILON,GREEK CAPITAL LETTER UPSILON")
(? "ꥷʸPHI,GREEK CAPITAL LETTER PHI")
(? "ꥷʸCHI,GREEK CAPITAL LETTER CHI")
(? "ꥷʸPSI,GREEK CAPITAL LETTER PSI")
(? "ꥷʸOMEGA,GREEK CAPITAL LETTER OMEGA")
(? "ꥷʸALPHA,GREEK SMALL LETTER ALPHA")
(? "ꥷʸBETA,GREEK SMALL LETTER BETA")
(? "ꥷʸGAMMA,GREEK SMALL LETTER GAMMA")
(? "ꥷʸDELTA,GREEK SMALL LETTER DELTA")
(? "ꥷʸEPSILON,GREEK SMALL LETTER EPSILON")
(? "ꥷʸZETA,GREEK SMALL LETTER ZETA")
(? "ꥷʸETA,GREEK SMALL LETTER ETA")
(? "ꥷʸTHETA,GREEK SMALL LETTER THETA")
(? "ꥷʸIOTA,GREEK SMALL LETTER IOTA")
(? "ꥷʸKAPPA,GREEK SMALL LETTER KAPPA")
(? "ꥷʸLAMBDA,GREEK SMALL LETTER LAMBDA")
(? "ꥷʸMU,GREEK SMALL LETTER MU")
(? "ꥷʸNU,GREEK SMALL LETTER NU")
(? "ꥷʸXI,GREEK SMALL LETTER XI")
(? "ꥷʸOMICRON,GREEK SMALL LETTER OMICRON")
(? "ꥷʸPI,GREEK SMALL LETTER PI")
(? "ꥷʸRHO,GREEK SMALL LETTER RHO")
(? "ꥷʸSIGMA,GREEK SMALL LETTER SIGMA")
(? "ꥷʸTAU,GREEK SMALL LETTER TAU")
(? "ꥷʸUPSILON,GREEK SMALL LETTER UPSILON")
(? "ꥷʸPHI,GREEK SMALL LETTER PHI")
(? "ꥷʸCHI,GREEK SMALL LETTER CHI")
(? "ꥷʸPSI,GREEK SMALL LETTER PSI")
(? "ꥷʸOMEGA,GREEK SMALL LETTER OMEGA")
(? "꡼ʸA,CYRILLIC CAPITAL LETTER A")
(? "꡼ʸBE,CYRILLIC CAPITAL LETTER BE")
(? "꡼ʸVE,CYRILLIC CAPITAL LETTER VE")
(? "꡼ʸGHE,CYRILLIC CAPITAL LETTER GHE")
(? "꡼ʸDE,CYRILLIC CAPITAL LETTER DE")
(? "꡼ʸIE,CYRILLIC CAPITAL LETTER IE")
(? "꡼ʸIO,CYRILLIC CAPITAL LETTER IO")
(? "꡼ʸZHE,CYRILLIC CAPITAL LETTER ZHE")
(? "꡼ʸZE,CYRILLIC CAPITAL LETTER ZE")
(? "꡼ʸI,CYRILLIC CAPITAL LETTER I")
(? "꡼ʸSHORT I,CYRILLIC CAPITAL LETTER SHORT I")
(? "꡼ʸKA,CYRILLIC CAPITAL LETTER KA")
(? "꡼ʸEL,CYRILLIC CAPITAL LETTER EL")
(? "꡼ʸEM,CYRILLIC CAPITAL LETTER EM")
(? "꡼ʸEN,CYRILLIC CAPITAL LETTER EN")
(? "꡼ʸO,CYRILLIC CAPITAL LETTER O")
(? "꡼ʸPE,CYRILLIC CAPITAL LETTER PE")
(? "꡼ʸER,CYRILLIC CAPITAL LETTER ER")
(? "꡼ʸES,CYRILLIC CAPITAL LETTER ES")
(? "꡼ʸTE,CYRILLIC CAPITAL LETTER TE")
(? "꡼ʸU,CYRILLIC CAPITAL LETTER U")
(? "꡼ʸEF,CYRILLIC CAPITAL LETTER EF")
(? "꡼ʸHA,CYRILLIC CAPITAL LETTER HA")
(? "꡼ʸTSE,CYRILLIC CAPITAL LETTER TSE")
(? "꡼ʸCHE,CYRILLIC CAPITAL LETTER CHE")
(? "꡼ʸSHA,CYRILLIC CAPITAL LETTER SHA")
(? "꡼ʸSHCHA,CYRILLIC CAPITAL LETTER SHCHA")
(? "꡼ʸHARD SIGN,CYRILLIC CAPITAL LETTER HARD SIGN")
(? "꡼ʸYERU,CYRILLIC CAPITAL LETTER YERU")
(? "꡼ʸSOFT SIGN,CYRILLIC CAPITAL LETTER SOFT SIGN")
(? "꡼ʸE,CYRILLIC CAPITAL LETTER E")
(? "꡼ʸYU,CYRILLIC CAPITAL LETTER YU")
(? "꡼ʸYA,CYRILLIC CAPITAL LETTER YA")
(? "꡼뾮ʸA,CYRILLIC SMALL LETTER A")
(? "꡼뾮ʸBE,CYRILLIC SMALL LETTER BE")
(? "꡼뾮ʸVE,CYRILLIC SMALL LETTER VE")
(? "꡼뾮ʸGHE,CYRILLIC SMALL LETTER GHE")
(? "꡼뾮ʸDE,CYRILLIC SMALL LETTER DE")
(? "꡼뾮ʸIE,CYRILLIC SMALL LETTER IE")
(? "꡼뾮ʸIO,CYRILLIC SMALL LETTER IO")
(? "꡼뾮ʸZHE,CYRILLIC SMALL LETTER ZHE")
(? "꡼뾮ʸZE,CYRILLIC SMALL LETTER ZE")
(? "꡼뾮ʸI,CYRILLIC SMALL LETTER I")
(? "꡼뾮ʸSHORT I,CYRILLIC SMALL LETTER SHORT I")
(? "꡼뾮ʸKA,CYRILLIC SMALL LETTER KA")
(? "꡼뾮ʸEL,CYRILLIC SMALL LETTER EL")
(? "꡼뾮ʸEM,CYRILLIC SMALL LETTER EM")
(? "꡼뾮ʸEN,CYRILLIC SMALL LETTER EN")
(? "꡼뾮ʸO,CYRILLIC SMALL LETTER O")
(? "꡼뾮ʸPE,CYRILLIC SMALL LETTER PE")
(? "꡼뾮ʸER,CYRILLIC SMALL LETTER ER")
(? "꡼뾮ʸES,CYRILLIC SMALL LETTER ES")
(? "꡼뾮ʸTE,CYRILLIC SMALL LETTER TE")
(? "꡼뾮ʸU,CYRILLIC SMALL LETTER U")
(? "꡼뾮ʸEF,CYRILLIC SMALL LETTER EF")
(? "꡼뾮ʸHA,CYRILLIC SMALL LETTER HA")
(? "꡼뾮ʸTSE,CYRILLIC SMALL LETTER TSE")
(? "꡼뾮ʸCHE,CYRILLIC SMALL LETTER CHE")
(? "꡼뾮ʸSHA,CYRILLIC SMALL LETTER SHA")
(? "꡼뾮ʸSHCHA,CYRILLIC SMALL LETTER SHCHA")
(? "꡼뾮ʸHARD SIGN,CYRILLIC SMALL LETTER HARD SIGN")
(? "꡼뾮ʸYERU,CYRILLIC SMALL LETTER YERU")
(? "꡼뾮ʸSOFT SIGN,CYRILLIC SMALL LETTER SOFT SIGN")
(? "꡼뾮ʸE,CYRILLIC SMALL LETTER E")
(? "꡼뾮ʸYU,CYRILLIC SMALL LETTER YU")
(? "꡼뾮ʸYA,CYRILLIC SMALL LETTER YA")
(? ",BOX DRAWINGS LIGHT HORIZONTAL")
(? "ĺ,BOX DRAWINGS LIGHT VERTICAL")
(? "Һ,BOX DRAWINGS LIGHT DOWN AND RIGHT")
(? "ұ,BOX DRAWINGS LIGHT DOWN AND LEFT")
(? "ұ,BOX DRAWINGS LIGHT UP AND LEFT")
(? "Һ,BOX DRAWINGS LIGHT UP AND RIGHT")
(? "Һ,BOX DRAWINGS LIGHT VERTICAL AND RIGHT")
(? "Ҿ,BOX DRAWINGS LIGHT DOWN AND HORIZONTAL")
(? "ұ,BOX DRAWINGS LIGHT VERTICAL AND LEFT")
(? "Ҳ,BOX DRAWINGS LIGHT UP AND HORIZONTAL")
(? ",BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL")
(? ",BOX DRAWINGS HEAVY HORIZONTAL")
(? ",BOX DRAWINGS HEAVY VERTICAL")
(? "Һ,BOX DRAWINGS HEAVY DOWN AND RIGHT")
(? "ұ,BOX DRAWINGS HEAVY DOWN AND LEFT")
(? "ұ,BOX DRAWINGS HEAVY UP AND LEFT")
(? "Һ,BOX DRAWINGS HEAVY UP AND RIGHT")
(? "Һ,BOX DRAWINGS HEAVY VERTICAL AND RIGHT")
(? "Ҿ,BOX DRAWINGS HEAVY DOWN AND HORIZONTAL")
(? "ұ,BOX DRAWINGS HEAVY VERTICAL AND LEFT")
(? "Ҳ,BOX DRAWINGS HEAVY UP AND HORIZONTAL")
(? ",BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL")
(? "Һ,BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT")
(? "ĺҾ,BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY")
(? "ұ,BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT")
(? "ĺҲ,BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY")
(? "ĺ,BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY")
(? "ĺҺ,BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY")
(? "Ҿ,BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT")
(? "ĺұ,BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY")
(? "Ҳ,BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT")
(? ",BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT")
(? "83ѹ")
(? "83ؤ()")
(? "뤦(ŵԾ)̻")
(? "83ѹ")
(? "83ؤ()()ά()̻")
(? "83ѹ")
(? "졣19 29() 30() 31()")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ()")
(? "83ѹ")
(? "83ؤ()")
(? "83ؤ()")
(? "83ѹ")
(? "83ɲؤ()")
(? "83ѹ")
(? "83ؤ()")
(? "83ѹ")
(? "83ؤ()")
(? "83ѹ")
(? "83ѹ")
(? "83ؤ()")
(? "83ѹ")
(? "83ѹ")
(? "83ѹ")
(? "83ؤ()")
(? "83ѹ")
(? "83ؤ()")
(? "83ѹ")
(? "83ѹ")
(?ý "83ѹ")
(? "83ѹ")
(? "83ؤ()(Ĥ)ά()̻")
(?Ŷ "83ѹ")
(?ſ "83ѹ")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ(޹)")
(? "83ѹ")
(? "83ѹ")
(? "83ؤ()")
(?Ǫ "ǩ()ά(ŵԾ)̻")
(?ǹ "83ѹ")
(? "83ؤ()")
(?Ȯ "83ѹ")
(?Ȱ "83ѹ")
(?ɰ "83ؤ()")
(? "ĤΤ(ޤ)̻")
(? "83ѹ")
(? "83ɲؤ()")
(? "83ؤ()")
(? "83ѹ")
(? "83ؤ()")
(? "83ɲؤ()")
(? "83ѹ")
(? "ʡ()̻")
(?϶ "83ؤ()")
(?Ϲ "83ѹ")
(? "ʩ(ۤȤ)ε(ե)̻")
(? "83ؤ()")
(? "֤ȡ(奦)̻")
(?ҹ "ϤޤҾ(ޤ)̻")
(?Ҿ "ޤҹ(Ϥޤ)̻")
(? "ŵ")
(? "ŵ")
(? "83ؤ()Ĥܡ()̻")
(? "(Ĥ)̻")
(? "()̻Ʊ")
(? "()̻Ʊ")
(?֬ "ŵԾܡӤθ")
(?׻ "Ʊǽ")
(? "եġ(ۤȤ)̻")
(? "ޤꡣ(ĤΤ)̻")
(? "ޤ롣()̻")
(? "̡(ޤ)̻")
(? "ŵԾ")
(? "83ؤ()")
(?ڹ "83ѹ")
(? "祦(إ)̻")
(? "إ(祦)̻")
(? "(Ҥ)ε()̻")
(? "ŵԾ")
(?۶ "۷(ȥ)̻")
(?۷ "ȥ۶()̻")
(? "83ؤ(ɰ)")
(? "83ؤ()")
(? "ŵԾܡ̤Τ̤Ǥθ")
(? "ŵԾ")
(?޹ "83ؤ()")
(? "83ؤ()")
(? "83ɲؤ()")
(? "()ε(Ҥ)̻")
(? "ޡ()̻")
(? "()̻")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ(϶)")
(? "()̻")
(? "奦(֤)̻")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ()")
(? "Ȥ(ȥ)̻")
(? "ȥ(Ȥ)̻")
(? "83ؤ()")
(? "ŵԾ")
(? "ŵԾܡǪ()̻")
(? "83ؤ()")
(? "83ؤ()")
(? "83ؤ()")
(? "ʤ(奦)̻")
(? "(奦)ΰλ(ʤ)̻")
(? "ʡ()̻")
(? "()̻")
(? "䤹ꡣ()̻")
(? "(䤹)̻")
(? "ŵԾܡ(뤦)̻")
(? "祦()̻")
(? "(祦)̻")
(? "83ؤ()")
(? "83ؤ()")
(? "ŵԾ")
(? "83ؤ()")
(? "83ؤ()()̻")
(? "()̻")
(? "83ɲؤ()")
(? "83ɲؤ()")
(? "83ɲؤ()")
(? "83ɲؤ()")
(? "90ɲ")
(? "90ɲ")

)))
    (mapcar (lambda (x) (skk-tankan-set-char-annotaion (car x) (nth 1 x)))
            l)))

;;; annotation data for japanese-jisx0213-1
(when (and skk-tankan-annotation-table
	   (charsetp 'japanese-jisx0213-1))
  (let ((l '(

(2 15 "ݥȥե,APOSTROPHE")
(2 16 ",ơޡ,QUOTATION MARK")
(2 17 "ϥեޥʥ,HYPHEN-MINUS")
(2 18 ",TILDE")
(2 19 "λ,VERTICAL KANA REPEAT MARK UPPER HALF")
(2 20 "λ(),VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF")
(2 21 "λ,VERTICAL KANA REPEAT MARK LOWER HALF")
(2 22 "λ,椹,VERTICAL IDEOGRAPHIC ITERATION MARK")
(2 23 "ޤ,MASU MARK")
(2 24 ",KATAKANA DIGRAPH KOTO")
(2 25 ",HIRAGANA DIGRAPH YORI")
(2 34 "ʬ,NOT A SUBSET OF")
(2 35 "ʬ(),NOT A SUPERSET OF")
(2 36 "ʬ2,SUBSET OF WITH NOT EQUAL TO")
(2 37 "ʬ2(),SUPERSET OF WITH NOT EQUAL TO")
(2 38 "Ǥ,,NOT AN ELEMENT OF")
(2 39 ",EMPTY SET")
(2 40 "ͱŪط,PROJECTIVE")
(2 41 "طŪط,PERSPECTIVE")
(2 49 "ľ,CIRCLED PLUS")
(2 50 "դޥʥ,CIRCLED MINUS")
(2 51 "ƥ󥽥,CIRCLED TIMES")
(2 52 "ʿ,PARALLEL TO")
(2 53 "ʿԤ,NOT PARALLEL TO")
(2 54 "Ϥťѡ,Ϥų,FULLWIDTH LEFT WHITE PARENTHESIS")
(2 55 "ťѡ,ų,FULLWIDTH RIGHT WHITE PARENTHESIS")
(2 56 "ϤŤä(),LEFT WHITE TORTOISE SHELL BRACKET")
(2 57 "Ťä(),RIGHT WHITE TORTOISE SHELL BRACKET")
(2 58 "Ϥ᤹դ(),LEFT WHITE LENTICULAR BRACKET")
(2 59 "ꤹդ(),RIGHT WHITE LENTICULAR BRACKET")
(2 75 "Ʊ,NOT IDENTICAL TO")
(2 76 "Ū,ۥȡ,ASYMPTOTICALLY EQUAL TO")
(2 77 "Ʊ,APPROXIMATELY EQUAL TO")
(2 78 "Ū,Ʊ,ALMOST EQUAL TO")
(2 79 "礭,LESS-THAN OR GREATER-THAN")
(2 80 "礭,GREATER-THAN OR LESS-THAN")
(2 81 "Ʊ,LEFT RIGHT ARROW")
(2 90 "ʥ,MUSIC NATURAL SIGN")
(2 91 "Ϣ()դȬʬ,BEAMED EIGHTH NOTES")
(2 92 "Ϣ()դϻʬ,BEAMED SIXTEENTH NOTES")
(2 93 "ʬ,QUARTER NOTE")
(3 1 ",WHITE RIGHT-POINTING TRIANGLE")
(3 2 ",BLACK RIGHT-POINTING TRIANGLE")
(3 3 ",WHITE LEFT-POINTING TRIANGLE")
(3 4 ",BLACK LEFT-POINTING TRIANGLE")
(3 5 ",NORTH EAST ARROW")
(3 6 ",SOUTH EAST ARROW")
(3 7 ",NORTH WEST ARROW")
(3 8 ",SOUTH WEST ARROW")
(3 9 ",RIGHTWARDS ARROW OVER LEFTWARDS ARROW")
(3 10 ",RIGHTWARDS WHITE ARROW")
(3 11 ",LEFTWARDS WHITE ARROW")
(3 12 ",UPWARDS WHITE ARROW")
(3 13 ",DOWNWARDS WHITE ARROW")
(3 14 "ʤ夬,ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS")
(3 15 "ʤ,ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS")
(3 26 ",CIRCLED BULLET")
(3 27 "ؤ,FISHEYE")
(3 28 "ε,(),PART ALTERNATION MARK")
(3 29 "򥴥,WHITE SESAME DOT")
(3 30 ",SESAME DOT")
(3 31 "ӥå,WHITE BULLET")
(3 32 "ӥå,BULLET")
(3 59 ",MINUS-OR-PLUS SIGN")
(3 60 ",ALEF SYMBOL")
(3 61 "С,PLANCK CONSTANT OVER TWO PI")
(3 62 "HP,ۡѥ(),SQUARE HP")
(3 63 "åȥ,SCRIPT SMALL L")
(3 64 "⡼,INVERTED OHM SIGN")
(3 91 "ťϥե,ʬťå,KATAKANA-HIRAGANA DOUBLE HYPHEN")
(3 92 "ʬ,å(ʬ),EN DASH")
(3 93 "2ץ饹,DOUBLE PLUS")
(3 94 "3ץ饹,TRIPLE PLUS")
(4 84 "դʿ̾,HIRAGANA LETTER VU")
(4 85 "ʿ̾,HIRAGANA LETTER SMALL KA")
(4 86 "ʿ̾,HIRAGANA LETTER SMALL KE")
(4 87 "Ⱦդʿ̾,[HIRAGANA LETTER BIDAKUON NGA]")
(4 88 "Ⱦդʿ̾,[HIRAGANA LETTER BIDAKUON NGI]")
(4 89 "Ⱦդʿ̾,[HIRAGANA LETTER BIDAKUON NGU]")
(4 90 "Ⱦդʿ̾,[HIRAGANA LETTER BIDAKUON NGE]")
(4 91 "Ⱦդʿ̾,[HIRAGANA LETTER BIDAKUON NGO]")
(5 87 "ȾդҲ̾,[KATAKANA LETTER BIDAKUON NGA]")
(5 88 "ȾդҲ̾,[KATAKANA LETTER BIDAKUON NGI]")
(5 89 "ȾդҲ̾,[KATAKANA LETTER BIDAKUON NGU]")
(5 90 "ȾդҲ̾,[KATAKANA LETTER BIDAKUON NGE]")
(5 91 "ȾդҲ̾,[KATAKANA LETTER BIDAKUON NGO]")
(5 92 "ȾդҲ̾,[KATAKANA LETTER AINU CE]")
(5 93 "ȾդҲ̾,[KATAKANA LETTER AINU TU]")
(5 94 "ȾդҲ̾,[KATAKANA LETTER AINU TO]")
(6 25 "ڡ(),WHITE SPADE SUIT")
(6 26 "ڡ,BLACK SPADE SUIT")
(6 27 "(),WHITE DIAMOND SUIT")
(6 28 ",BLACK DIAMOND SUIT")
(6 29 "ϡ(),WHITE HEART SUIT")
(6 30 "ϡ,BLACK HEART SUIT")
(6 31 "(),WHITE CLUB SUIT")
(6 32 ",BLACK CLUB SUIT")
(6 57 "ꥷʸեʥSIGMA,GREEK SMALL LETTER FINAL SIGMA")
(6 58 "Ŵ1,DOUBLE CIRCLED DIGIT ONE")
(6 59 "Ŵ2,DOUBLE CIRCLED DIGIT TWO")
(6 60 "Ŵ3,DOUBLE CIRCLED DIGIT THREE")
(6 61 "Ŵ4,DOUBLE CIRCLED DIGIT FOUR")
(6 62 "Ŵ5,DOUBLE CIRCLED DIGIT FIVE")
(6 63 "Ŵ6,DOUBLE CIRCLED DIGIT SIX")
(6 64 "Ŵ7,DOUBLE CIRCLED DIGIT SEVEN")
(6 65 "Ŵ8,DOUBLE CIRCLED DIGIT EIGHT")
(6 66 "Ŵ9,DOUBLE CIRCLED DIGIT NINE")
(6 67 "Ŵ10,DOUBLE CIRCLED NUMBER TEN")
(6 68 "򾭴,WHITE SHOGI PIECE")
(6 69 ",BLACK SHOGI PIECE")
(6 70 "͹إޡ,POSTAL MARK FACE")
(6 71 "åޡ,BLACK TELEPHONE")
(6 72 "ޡ,BLACK SUN WITH RAYS")
(6 73 "ޥޡ,CLOUD")
(6 74 "ޡ,UMBRELLA")
(6 75 "ޡ,SNOWMAN")
(6 76 "ޡ,HOT SPRINGS")
(6 77 "ʿԻշ,WHITE PARALLELOGRAM")
(6 78 "Ҳ̾,KATAKANA LETTER SMALL KU")
(6 79 "Ҳ̾,KATAKANA LETTER SMALL SI")
(6 80 "Ҳ̾,KATAKANA LETTER SMALL SU")
(6 81 "Ҳ̾,KATAKANA LETTER SMALL TO")
(6 82 "Ҳ̾,KATAKANA LETTER SMALL NU")
(6 83 "Ҳ̾,KATAKANA LETTER SMALL HA")
(6 84 "Ҳ̾,KATAKANA LETTER SMALL HI")
(6 85 "Ҳ̾,KATAKANA LETTER SMALL HU")
(6 86 "Ҳ̾,KATAKANA LETTER SMALL HE")
(6 87 "Ҳ̾,KATAKANA LETTER SMALL HO")
(6 88 "ȾդҲ̾,[KATAKANA LETTER AINU P]")
(6 89 "Ҳ̾,KATAKANA LETTER SMALL MU")
(6 90 "Ҳ̾,KATAKANA LETTER SMALL RA")
(6 91 "Ҳ̾,KATAKANA LETTER SMALL RI")
(6 92 "Ҳ̾,KATAKANA LETTER SMALL RU")
(6 93 "Ҳ̾,KATAKANA LETTER SMALL RE")
(6 94 "Ҳ̾,KATAKANA LETTER SMALL RO")
(7 34 ",DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT")
(7 35 ",DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT")
(7 36 "դ,DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE")
(7 37 "դ岣,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE")
(7 38 "դ,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE")
(7 39 "դ,DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE")
(7 40 "դ岣,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE")
(7 41 "դ,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE")
(7 42 "դ,DENTISTRY SYMBOL LIGHT VERTICAL WITH WAVE")
(7 43 "դ岣,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE")
(7 44 "դ,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE")
(7 45 "岣,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL")
(7 46 ",DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL")
(7 47 ",DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT")
(7 48 ",DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT")
(7 82 "դҲ̾,KATAKANA LETTER VA")
(7 83 "դҲ̾,KATAKANA LETTER VI")
(7 84 "դҲ̾,KATAKANA LETTER VE")
(7 85 "դҲ̾,KATAKANA LETTER VO")
(7 86 "礭,LESS-THAN EQUAL TO OR GREATER-THAN")
(7 87 "礭,GREATER-THAN EQUAL TO OR LESS-THAN")
(7 88 "3ʬ1,VULGAR FRACTION ONE THIRD")
(7 89 "3ʬ2,VULGAR FRACTION TWO THIRDS")
(7 90 "5ʬ1,VULGAR FRACTION ONE FIFTH")
(7 91 "åޡ,CHECK MARK")
(7 92 "ޥɵ,PLACE OF INTEREST SIGN")
(7 93 "򵭹,OPEN BOX")
(7 94 "꥿󵭹,RETURN SYMBOL")
(8 33 "21,CIRCLED NUMBER TWENTY ONE")
(8 34 "22,CIRCLED NUMBER TWENTY TWO")
(8 35 "23,CIRCLED NUMBER TWENTY THREE")
(8 36 "24,CIRCLED NUMBER TWENTY FOUR")
(8 37 "25,CIRCLED NUMBER TWENTY FIVE")
(8 38 "26,CIRCLED NUMBER TWENTY SIX")
(8 39 "27,CIRCLED NUMBER TWENTY SEVEN")
(8 40 "28,CIRCLED NUMBER TWENTY EIGHT")
(8 41 "29,CIRCLED NUMBER TWENTY NINE")
(8 42 "30,CIRCLED NUMBER THIRTY")
(8 43 "31,CIRCLED NUMBER THIRTY ONE")
(8 44 "32,CIRCLED NUMBER THIRTY TWO")
(8 45 "33,CIRCLED NUMBER THIRTY THREE")
(8 46 "34,CIRCLED NUMBER THIRTY FOUR")
(8 47 "35,CIRCLED NUMBER THIRTY FIVE")
(8 48 "36,CIRCLED NUMBER THIRTY SIX")
(8 49 "37,CIRCLED NUMBER THIRTY SEVEN")
(8 50 "38,CIRCLED NUMBER THIRTY EIGHT")
(8 51 "39,CIRCLED NUMBER THIRTY NINE")
(8 52 "40,CIRCLED NUMBER FORTY")
(8 53 "41,CIRCLED NUMBER FORTY ONE")
(8 54 "42,CIRCLED NUMBER FORTY TWO")
(8 55 "43,CIRCLED NUMBER FORTY THREE")
(8 56 "44,CIRCLED NUMBER FORTY FOUR")
(8 57 "45,CIRCLED NUMBER FORTY FIVE")
(8 58 "46,CIRCLED NUMBER FORTY SIX")
(8 59 "47,CIRCLED NUMBER FORTY SEVEN")
(8 60 "48,CIRCLED NUMBER FORTY EIGHT")
(8 61 "49,CIRCLED NUMBER FORTY NINE")
(8 62 "50,CIRCLED NUMBER FIFTY")
(8 71 "Ⱦ,CIRCLE WITH LEFT HALF BLACK")
(8 72 "Ⱦ,CIRCLE WITH RIGHT HALF BLACK")
(8 73 "Ⱦ,CIRCLE WITH LOWER HALF BLACK")
(8 74 "Ⱦ,CIRCLE WITH UPPER HALF BLACK")
(8 75 "ò,DOUBLE EXCLAMATION MARK")
(8 76 ",DOUBLE QUESTION MARK")
(8 77 "䴶ò,QUESTION EXCLAMATION MARK")
(8 78 "ò䵿,EXCLAMATION QUESTION MARK")
(8 79 "դA,LATIN CAPITAL LETTER A WITH CARON")
(8 80 "դAʸ,LATIN SMALL LETTER A WITH CARON")
(8 81 "դIʸ,LATIN SMALL LETTER I WITH CARON")
(8 82 "塼ȥդM,LATIN CAPITAL LETTER M WITH ACUTE")
(8 83 "塼ȥդMʸ,LATIN SMALL LETTER M WITH ACUTE")
(8 84 "졼֥դN,LATIN CAPITAL LETTER N WITH GRAVE")
(8 85 "졼֥դNʸ,LATIN SMALL LETTER N WITH GRAVE")
(8 86 "դO,LATIN CAPITAL LETTER O WITH CARON")
(8 87 "դOʸ,LATIN SMALL LETTER O WITH CARON")
(8 88 "դUʸ,LATIN SMALL LETTER U WITH CARON")
(8 89 "ޥȥ쥷դUʸ,LATIN SMALL LETTER U WITH DIAERESIS AND MACRON")
(8 90 "塼ȥȤȥ쥷դUʸ,LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE")
(8 91 "ȥ쥷դUʸ,LATIN SMALL LETTER U WITH DIAERESIS AND CARON")
(8 92 "졼֥Ȥȥ쥷դUʸ,LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE")
(9 1 "桼,EURO SIGN")
(9 2 "Ρ֥졼ڡ,NO-BREAK SPACE")
(9 3 "մò,INVERTED EXCLAMATION MARK")
(9 4 "̲ߵ,CURRENCY SIGN")
(9 5 ",BROKEN BAR")
(9 6 "ɽ,COPYRIGHT SIGN")
(9 7 "ɸ,FEMININE ORDINAL INDICATOR")
(9 8 "ϤŻ̰ѵ,Ϥ᥮,LEFT-POINTING DOUBLE ANGLE QUOTATION MARK")
(9 9 "եȥϥե,SOFT HYPHEN")
(9 10 "Ͽɸ,REGISTERED SIGN")
(9 11 "ޥ,MACRON")
(9 12 "դ2,SUPERSCRIPT TWO")
(9 13 "դ3,SUPERSCRIPT THREE")
(9 14 "(ƥ),MIDDLE DOT")
(9 15 "ǥ,CEDILLA")
(9 16 "դ1,SUPERSCRIPT ONE")
(9 17 "ɸ,MASCULINE ORDINAL INDICATOR")
(9 18 "Ż̰ѵ,ꥮ,RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK")
(9 19 "4ʬ1,VULGAR FRACTION ONE QUARTER")
(9 20 "2ʬ1,VULGAR FRACTION ONE HALF")
(9 21 "4ʬ3,VULGAR FRACTION THREE QUARTERS")
(9 22 "յ,INVERTED QUESTION MARK")
(9 23 "졼֥դA,LATIN CAPITAL LETTER A WITH GRAVE")
(9 24 "塼ȥդA,LATIN CAPITAL LETTER A WITH ACUTE")
(9 25 "եåդA,LATIN CAPITAL LETTER A WITH CIRCUMFLEX")
(9 26 "դA,LATIN CAPITAL LETTER A WITH TILDE")
(9 27 "쥷դA,LATIN CAPITAL LETTER A WITH DIAERESIS")
(9 28 "դA,LATIN CAPITAL LETTER A WITH RING ABOVE")
(9 29 "AE,LATIN CAPITAL LETTER AE")
(9 30 "ǥդC,LATIN CAPITAL LETTER C WITH CEDILLA")
(9 31 "졼֥դE,LATIN CAPITAL LETTER E WITH GRAVE")
(9 32 "塼ȥդE,LATIN CAPITAL LETTER E WITH ACUTE")
(9 33 "եåդE,LATIN CAPITAL LETTER E WITH CIRCUMFLEX")
(9 34 "쥷դE,LATIN CAPITAL LETTER E WITH DIAERESIS")
(9 35 "졼֥դI,LATIN CAPITAL LETTER I WITH GRAVE")
(9 36 "塼ȥդI,LATIN CAPITAL LETTER I WITH ACUTE")
(9 37 "եåդI,LATIN CAPITAL LETTER I WITH CIRCUMFLEX")
(9 38 "쥷դI,LATIN CAPITAL LETTER I WITH DIAERESIS")
(9 39 "ɸETH,LATIN CAPITAL LETTER ETH(Icelandic)")
(9 40 "դN,LATIN CAPITAL LETTER N WITH TILDE")
(9 41 "졼֥դO,LATIN CAPITAL LETTER O WITH GRAVE")
(9 42 "塼ȥդO,LATIN CAPITAL LETTER O WITH ACUTE")
(9 43 "եåդO,LATIN CAPITAL LETTER O WITH CIRCUMFLEX")
(9 44 "դO,LATIN CAPITAL LETTER O WITH TILDE")
(9 45 "쥷դO,LATIN CAPITAL LETTER O WITH DIAERESIS")
(9 46 "ȥդO,LATIN CAPITAL LETTER O WITH STROKE")
(9 47 "졼֥դU,LATIN CAPITAL LETTER U WITH GRAVE")
(9 48 "塼ȥդU,LATIN CAPITAL LETTER U WITH ACUTE")
(9 49 "եåդU,LATIN CAPITAL LETTER U WITH CIRCUMFLEX")
(9 50 "쥷դU,LATIN CAPITAL LETTER U WITH DIAERESIS")
(9 51 "塼ȥդY,LATIN CAPITAL LETTER Y WITH ACUTE")
(9 52 "ɸTHORN,LATIN CAPITAL LETTER THORN(Icelandic)")
(9 53 "ɥĸ쥨ĥå,LATIN SMALL LETTER SHARP S(German)")
(9 54 "졼֥դAʸ,LATIN SMALL LETTER A WITH GRAVE")
(9 55 "塼ȥդAʸ,LATIN SMALL LETTER A WITH ACUTE")
(9 56 "եåդAʸ,LATIN SMALL LETTER A WITH CIRCUMFLEX")
(9 57 "դAʸ,LATIN SMALL LETTER A WITH TILDE")
(9 58 "쥷դAʸ,LATIN SMALL LETTER A WITH DIAERESIS")
(9 59 "դAʸ,LATIN SMALL LETTER A WITH RING ABOVE")
(9 60 "AEʸ,LATIN SMALL LETTER AE")
(9 61 "ǥդCʸ,LATIN SMALL LETTER C WITH CEDILLA")
(9 62 "졼֥դEʸ,LATIN SMALL LETTER E WITH GRAVE")
(9 63 "塼ȥդEʸ,LATIN SMALL LETTER E WITH ACUTE")
(9 64 "եåդEʸ,LATIN SMALL LETTER E WITH CIRCUMFLEX")
(9 65 "쥷դEʸ,LATIN SMALL LETTER E WITH DIAERESIS")
(9 66 "졼֥դIʸ,LATIN SMALL LETTER I WITH GRAVE")
(9 67 "塼ȥդIʸ,LATIN SMALL LETTER I WITH ACUTE")
(9 68 "եåդIʸ,LATIN SMALL LETTER I WITH CIRCUMFLEX")
(9 69 "쥷դIʸ,LATIN SMALL LETTER I WITH DIAERESIS")
(9 70 "ɸETHʸ,LATIN SMALL LETTER ETH(Icelandic)")
(9 71 "դNʸ,LATIN SMALL LETTER N WITH TILDE")
(9 72 "졼֥դOʸ,LATIN SMALL LETTER O WITH GRAVE")
(9 73 "塼ȥդOʸ,LATIN SMALL LETTER O WITH ACUTE")
(9 74 "եåդOʸ,LATIN SMALL LETTER O WITH CIRCUMFLEX")
(9 75 "դOʸ,LATIN SMALL LETTER O WITH TILDE")
(9 76 "쥷դOʸ,LATIN SMALL LETTER O WITH DIAERESIS")
(9 77 "ȥդOʸ,LATIN SMALL LETTER O WITH STROKE")
(9 78 "졼֥դUʸ,LATIN SMALL LETTER U WITH GRAVE")
(9 79 "塼ȥդUʸ,LATIN SMALL LETTER U WITH ACUTE")
(9 80 "եåդUʸ,LATIN SMALL LETTER U WITH CIRCUMFLEX")
(9 81 "쥷դUʸ,LATIN SMALL LETTER U WITH DIAERESIS")
(9 82 "塼ȥդYʸ,LATIN SMALL LETTER Y WITH ACUTE")
(9 83 "ɸTHORNʸ,LATIN SMALL LETTER THORN(Icelandic)")
(9 84 "쥷դYʸ,LATIN SMALL LETTER Y WITH DIAERESIS")
(9 85 "ޥդA,LATIN CAPITAL LETTER A WITH MACRON")
(9 86 "ޥդI,LATIN CAPITAL LETTER I WITH MACRON")
(9 87 "ޥդU,LATIN CAPITAL LETTER U WITH MACRON")
(9 88 "ޥդE,LATIN CAPITAL LETTER E WITH MACRON")
(9 89 "ޥդO,LATIN CAPITAL LETTER O WITH MACRON")
(9 90 "ޥդAʸ,LATIN SMALL LETTER A WITH MACRON")
(9 91 "ޥդIʸ,LATIN SMALL LETTER I WITH MACRON")
(9 92 "ޥդUʸ,LATIN SMALL LETTER U WITH MACRON")
(9 93 "ޥդEʸ,LATIN SMALL LETTER E WITH MACRON")
(9 94 "ޥդOʸ,LATIN SMALL LETTER O WITH MACRON")
(10 1 "ͥդA,LATIN CAPITAL LETTER A WITH OGONEK")
(10 2 "֥꡼,BREVE")
(10 3 "ȥդL,LATIN CAPITAL LETTER L WITH STROKE")
(10 4 "դL,LATIN CAPITAL LETTER L WITH CARON")
(10 5 "塼ȥդS,LATIN CAPITAL LETTER S WITH ACUTE")
(10 6 "դS,LATIN CAPITAL LETTER S WITH CARON")
(10 7 "ǥդS,LATIN CAPITAL LETTER S WITH CEDILLA")
(10 8 "դT,LATIN CAPITAL LETTER T WITH CARON")
(10 9 "塼ȥդZ,LATIN CAPITAL LETTER Z WITH ACUTE")
(10 10 "դZ,LATIN CAPITAL LETTER Z WITH CARON")
(10 11 "ɥåդZ,LATIN CAPITAL LETTER Z WITH DOT ABOVE")
(10 12 "ͥդAʸ,LATIN SMALL LETTER A WITH OGONEK")
(10 13 "ͥ,OGONEK")
(10 14 "ȥդLʸ,LATIN SMALL LETTER L WITH STROKE")
(10 15 "դLʸ,LATIN SMALL LETTER L WITH CARON")
(10 16 "塼ȥդSʸ,LATIN SMALL LETTER S WITH ACUTE")
(10 17 ",CARON(Mandarin Chinese third tone)")
(10 18 "դSʸ,LATIN SMALL LETTER S WITH CARON")
(10 19 "ǥդSʸ,LATIN SMALL LETTER S WITH CEDILLA")
(10 20 "դTʸ,LATIN SMALL LETTER T WITH CARON")
(10 21 "塼ȥդZʸ,LATIN SMALL LETTER Z WITH ACUTE")
(10 22 "֥륢塼ȥ,DOUBLE ACUTE ACCENT")
(10 23 "դZʸ,LATIN SMALL LETTER Z WITH CARON")
(10 24 "ɥåդZʸ,LATIN SMALL LETTER Z WITH DOT ABOVE")
(10 25 "塼ȥդR,LATIN CAPITAL LETTER R WITH ACUTE")
(10 26 "֥꡼դA,LATIN CAPITAL LETTER A WITH BREVE")
(10 27 "塼ȥդL,LATIN CAPITAL LETTER L WITH ACUTE")
(10 28 "塼ȥդC,LATIN CAPITAL LETTER C WITH ACUTE")
(10 29 "դC,LATIN CAPITAL LETTER C WITH CARON")
(10 30 "ͥդE,LATIN CAPITAL LETTER E WITH OGONEK")
(10 31 "դE,LATIN CAPITAL LETTER E WITH CARON")
(10 32 "դD,LATIN CAPITAL LETTER D WITH CARON")
(10 33 "塼ȥդN,LATIN CAPITAL LETTER N WITH ACUTE")
(10 34 "դN,LATIN CAPITAL LETTER N WITH CARON")
(10 35 "֥륢塼ȥդO,LATIN CAPITAL LETTER O WITH DOUBLE ACUTE")
(10 36 "դR,LATIN CAPITAL LETTER R WITH CARON")
(10 37 "դU,LATIN CAPITAL LETTER U WITH RING ABOVE")
(10 38 "֥륢塼ȥդU,LATIN CAPITAL LETTER U WITH DOUBLE ACUTE")
(10 39 "ǥդT,LATIN CAPITAL LETTER T WITH CEDILLA")
(10 40 "塼ȥդRʸ,LATIN SMALL LETTER R WITH ACUTE")
(10 41 "֥꡼դAʸ,LATIN SMALL LETTER A WITH BREVE")
(10 42 "塼ȥդLʸ,LATIN SMALL LETTER L WITH ACUTE")
(10 43 "塼ȥդCʸ,LATIN SMALL LETTER C WITH ACUTE")
(10 44 "դCʸ,LATIN SMALL LETTER C WITH CARON")
(10 45 "ͥդEʸ,LATIN SMALL LETTER E WITH OGONEK")
(10 46 "դEʸ,LATIN SMALL LETTER E WITH CARON")
(10 47 "դDʸ,LATIN SMALL LETTER D WITH CARON")
(10 48 "ȥդDʸ,LATIN SMALL LETTER D WITH STROKE")
(10 49 "塼ȥդNʸ,LATIN SMALL LETTER N WITH ACUTE")
(10 50 "դNʸ,LATIN SMALL LETTER N WITH CARON")
(10 51 "֥륢塼ȥդOʸ,LATIN SMALL LETTER O WITH DOUBLE ACUTE")
(10 52 "դRʸ,LATIN SMALL LETTER R WITH CARON")
(10 53 "դUʸ,LATIN SMALL LETTER U WITH RING ABOVE")
(10 54 "֥륢塼ȥդUʸ,LATIN SMALL LETTER U WITH DOUBLE ACUTE")
(10 55 "ǥդTʸ,LATIN SMALL LETTER T WITH CEDILLA")
(10 56 "ɥå,DOT ABOVE(Mandarin Chinese light tone)")
(10 57 "եåդC,LATIN CAPITAL LETTER C WITH CIRCUMFLEX")
(10 58 "եåդG,LATIN CAPITAL LETTER G WITH CIRCUMFLEX")
(10 59 "եåդH,LATIN CAPITAL LETTER H WITH CIRCUMFLEX")
(10 60 "եåդJ,LATIN CAPITAL LETTER J WITH CIRCUMFLEX")
(10 61 "եåդS,LATIN CAPITAL LETTER S WITH CIRCUMFLEX")
(10 62 "֥꡼դU,LATIN CAPITAL LETTER U WITH BREVE")
(10 63 "եåդCʸ,LATIN SMALL LETTER C WITH CIRCUMFLEX")
(10 64 "եåդGʸ,LATIN SMALL LETTER G WITH CIRCUMFLEX")
(10 65 "եåդHʸ,LATIN SMALL LETTER H WITH CIRCUMFLEX")
(10 66 "եåդJʸ,LATIN SMALL LETTER J WITH CIRCUMFLEX")
(10 67 "եåդSʸ,LATIN SMALL LETTER S WITH CIRCUMFLEX")
(10 68 "֥꡼դUʸ,LATIN SMALL LETTER U WITH BREVE")
(10 69 "եåդMʸ,ͭɡ,LATIN SMALL LETTER M WITH HOOK")
(10 70 "եåդVʸ,ͭܶ᲻,LATIN SMALL LETTER V WITH HOOK")
(10 71 "եåեåդRʸ,ͭƤ,LATIN SMALL LETTER R WITH FISHHOOK")
(10 72 "ESHʸ,̵໤,LATIN SMALL LETTER ESH")
(10 73 "EZHʸ,ͭ໤,LATIN SMALL LETTER EZH")
(10 74 "٥դLʸ,̵¦໤,LATIN SMALL LETTER L WITH BELT")
(10 75 "LEZHʸ,ͭ¦໤,LATIN SMALL LETTER LEZH")
(10 76 "Rʸ,̵ܶ᲻,LATIN SMALL LETTER TURNED R")
(10 77 "ȥեåեåդTʸ,̵,LATIN SMALL LETTER T WITH RETROFLEX HOOK")
(10 78 "ơդDʸ,ͭ,LATIN SMALL LETTER D WITH TAIL")
(10 79 "ȥեåեåդNʸ,ͭɡ,LATIN SMALL LETTER N WITH RETROFLEX HOOK")
(10 80 "ơդRʸ,ͭƤ,LATIN SMALL LETTER R WITH TAIL")
(10 81 "եåդSʸ,̵໤,LATIN SMALL LETTER S WITH HOOK")
(10 82 "ȥեåեåդZʸ,ͭ໤,LATIN SMALL LETTER Z WITH RETROFLEX HOOK")
(10 83 "եåդRʸ,ͭܶ᲻,LATIN SMALL LETTER TURNED R WITH HOOK")
(10 84 "ȥեåեåդLʸ,ͭ¦ܶ᲻,LATIN SMALL LETTER L WITH RETROFLEX HOOK")
(10 85 "ȥդɥåȤʤJʸ,ͭŸ,LATIN SMALL LETTER DOTLESS J WITH STROKE")
(10 86 "եåդNʸ,ͭŸɡ,LATIN SMALL LETTER N WITH LEFT HOOK")
(10 87 "ɥơդJʸ,ͭŸ໤,LATIN SMALL LETTER J WITH CROSSED-TAIL")
(10 88 "Yʸ,ͭŸ¦ܶ᲻,LATIN SMALL LETTER TURNED Y")
(10 89 "ץGʸ,ͭ,LATIN SMALL LETTER SCRIPT G")
(10 90 "ENGʸ,ͭɡ,LATIN SMALL LETTER ENG(Sami)")
(10 91 "󥰥åդMʸ,ͭܶ᲻,LATIN SMALL LETTER TURNED M WITH LONG LEG")
(10 92 "СƥåR⡼륭ԥ,ͭ໤,LATIN LETTER SMALL CAPITAL INVERTED R")
(10 93 "ȥդHʸ,̵Ƭ໤,LATIN SMALL LETTER H WITH STROKE")
(10 94 "Сɥå륹ȥå,ͭƬ໤,LATIN LETTER PHARYNGEAL VOICED FRICATIVE")
(11 1 "å륹ȥå,̵,LATIN LETTER GLOTTAL STOP")
(11 2 "եåդHʸ,ͭ໤,LATIN SMALL LETTER H WITH HOOK")
(11 3 "ξ岻,LATIN LETTER BILABIAL CLICK")
(11 4 "ŸԵ岻,LATIN LETTER ALVEOLAR CLICK")
(11 5 "եåդBʸ,ͭξ˲,LATIN SMALL LETTER B WITH HOOK")
(11 6 "եåդDʸ,ͭ˲,LATIN SMALL LETTER D WITH HOOK")
(11 7 "եåȥȥդɥåȤʤJʸ,ͭŸ˲,LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK")
(11 8 "եåդGʸ,ͭ˲,LATIN SMALL LETTER G WITH HOOK")
(11 9 "եåդGʸ,ͭ˲,LATIN CAPITAL LETTER G WITH HOOK")
(11 10 "ꥬOEʸ,߿幭첻,LATIN SMALL LIGATURE OE")
(11 11 "ꥬOEʸ,߿幭첻,LATIN CAPITAL LIGATURE OE")
(11 12 "ȥդIʸ,߿嶹첻,LATIN SMALL LETTER I WITH STROKE")
(11 13 "СդUʸ,߿嶹첻,LATIN SMALL LETTER U BAR")
(11 14 "СEʸ,߿嶹첻,LATIN SMALL LETTER REVERSED E")
(11 15 "СդOʸ,߿嶹첻,LATIN SMALL LETTER BARRED O")
(11 16 "SCHWAʸ,߿첻,LATIN SMALL LETTER SCHWA")
(11 17 "СɥץEʸ,߿幭첻,LATIN SMALL LETTER REVERSED OPEN E")
(11 18 "ɥСɥץEʸ,߿幭첻,LATIN SMALL LETTER CLOSED REVERSED OPEN E")
(11 19 "Aʸ,߿嶹ι첻,LATIN SMALL LETTER TURNED A")
(11 20 "Mʸ,߿嶹첻,LATIN SMALL LETTER TURNED M")
(11 21 "UPSILONʸ,߿幭ζ첻,LATIN SMALL LETTER UPSILON")
(11 22 "٥ӡ,߿嶹첻,LATIN SMALL LETTER RAMS HORN")
(11 23 "Vʸ,߿幭첻,LATIN SMALL LETTER TURNED V")
(11 24 "ץOʸ,߿幭첻,LATIN SMALL LETTER OPEN O")
(11 25 "ץAʸ,߿幭첻,LATIN SMALL LETTER ALPHA")
(11 26 "ALPHAʸ,߿幭첻,LATIN SMALL LETTER TURNED ALPHA")
(11 27 "Wʸ,̵ξ໤,LATIN SMALL LETTER TURNED W")
(11 28 "Hʸ,ͭξŸܶ᲻,LATIN SMALL LETTER TURNED H")
(11 29 "ȥդСɥå륹ȥå,ͭƬ໤,LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE")
(11 30 "ȥդå륹ȥå,Ƭ,LATIN LETTER GLOTTAL STOP WITH STROKE")
(11 31 "դCʸ,ԡŸ໤,LATIN SMALL LETTER C WITH CURL")
(11 32 "դZʸ,ԡŸ໤,LATIN SMALL LETTER Z WITH CURL")
(11 33 "󥰥åդRʸ,¦Ƥ,LATIN SMALL LETTER TURNED R WITH LONG LEG")
(11 34 "եåդHENGʸ,̵໤,LATIN SMALL LETTER HENG WITH HOOK")
(11 35 "եåդSCHWA,LATIN SMALL LETTER SCHWA WITH HOOK")
(11 36 "졼֥դAEʸ,[LATIN SMALL LETTER AE WITH GRAVE]")
(11 37 "塼ȥդAEʸ,LATIN SMALL LETTER AE WITH ACUTE")
(11 38 "졼֥դץAʸ,GREEK SMALL LETTER ALPHA WITH VARIA")
(11 39 "塼ȥդץAʸ,GREEK SMALL LETTER ALPHA WITH OXIA")
(11 40 "졼֥դץOʸ,[LATIN SMALL LETTER OPEN O WITH GRAVE]")
(11 41 "塼ȥդץOʸ,[LATIN SMALL LETTER OPEN O WITH ACUTE]")
(11 42 "졼֥դVʸ,[LATIN SMALL LETTER TURNED V WITH GRAVE]")
(11 43 "塼ȥդVʸ,[LATIN SMALL LETTER TURNED V WITH ACUTE]")
(11 44 "졼֥դSCHWAʸ,[LATIN SMALL LETTER SCHWA WITH GRAVE]")
(11 45 "塼ȥդSCHWAʸ,[LATIN SMALL LETTER SCHWA WITH ACUTE]")
(11 46 "졼֥ȤȥեåդSCHWAʸ,[LATIN SMALL LETTER HOOKED SCHWA WITH GRAVE]")
(11 47 "塼ȥȤȥեåդSCHWAʸ,[LATIN SMALL LETTER HOOKED SCHWA WITH ACUTE]")
(11 48 "졼֥դEPSILONʸ,GREEK SMALL LETTER EPSILON WITH VARIA")
(11 49 "塼ȥդEPSILONʸ,GREEK SMALL LETTER EPSILON WITH OXIA")
(11 50 "֥륤Сƥåɥ֥꡼(ǽ),˻Ĵ,COMBINING DOUBLE INVERTED BREVE")
(11 51 ",춯,MODIFIER LETTER VERTICAL LINE")
(11 52 ",,MODIFIER LETTER LOW VERTICAL LINE")
(11 53 "Ĺ,MODIFIER LETTER TRIANGULAR COLON")
(11 54 "ȾĹ,MODIFIER LETTER HALF TRIANGULAR COLON")
(11 55 "֥꡼(ǽ),Ķû,COMBINING BREVE(Vrachy)")
(11 56 "Ϣ뤷Ƥ,UNDERTIE(Enotikon)")
(11 57 "֥륢塼ȥ(ǽ),ĴĶ,COMBINING DOUBLE ACUTE ACCENT")
(11 58 "塼ȥ(ǽ),Ĵ,COMBINING ACUTE ACCENT(Oxia)")
(11 59 "ޥ(ǽ),Ĵ,COMBINING MACRON")
(11 60 "졼֥(ǽ),Ĵ,COMBINING GRAVE ACCENT(Varia)")
(11 61 "֥륰졼֥(ǽ),ĴĶ,COMBINING DOUBLE GRAVE ACCENT")
(11 62 "(ǽ),Ĵ徺Ĵ,COMBINING CARON")
(11 63 "եå(ǽ),ĴĴ,COMBINING CIRCUMFLEX ACCENT")
(11 64 "ĴĶ,MODIFIER LETTER EXTRA-HIGH TONE BAR")
(11 65 "Ĵ,MODIFIER LETTER HIGH TONE BAR")
(11 66 "Ĵ,MODIFIER LETTER MID TONE BAR")
(11 67 "Ĵ,MODIFIER LETTER LOW TONE BAR")
(11 68 "ĴĶ,MODIFIER LETTER EXTRA-LOW TONE BAR")
(11 69 "Ĵ徺Ĵ,[RISING SYMBOL]")
(11 70 "Ĵ沼Ĵ,[FALLING SYMBOL]")
(11 71 "(ǽ),̵,COMBINING RING BELOW")
(11 72 "(ǽ),ͭ,COMBINING CARON BELOW")
(11 73 "饤ȥϡե(ǽ),߿ζ,COMBINING RIGHT HALF RING BELOW")
(11 74 "եȥϡե(ǽ),߿μ夤,COMBINING LEFT HALF RING BELOW")
(11 75 "ץ饹(ǽ),,COMBINING PLUS SIGN BELOW")
(11 76 "ޥʥ(ǽ),,COMBINING MINUS SIGN BELOW")
(11 77 "쥷(ǽ),첻,COMBINING DIAERESIS(Dialytika)")
(11 78 "X(ǽ),첻,COMBINING X ABOVE")
(11 79 "(ǽ),粻Ū,COMBINING VERTICAL LINE BELOW")
(11 80 "Сƥåɥ֥꡼(ǽ),Ū,COMBINING INVERTED BREVE BELOW")
(11 81 "rβ,MODIFIER LETTER RHOTIC HOOK")
(11 82 "쥷(ǽ),첻,COMBINING DIAERESIS BELOW")
(11 83 "(ǽ),߲,COMBINING TILDE BELOW")
(11 84 "(ǽ),ü,COMBINING SEAGULL BELOW")
(11 85 "ɥХ쥤(ǽ),뤤ϰƬ,COMBINING TILDE OVERLAY")
(11 86 "åץå(ǽ),,COMBINING UP TACK BELOW")
(11 87 "󥿥å(ǽ),,COMBINING DOWN TACK BELOW")
(11 88 "եȥå(ǽ),庬,COMBINING LEFT TACK BELOW")
(11 89 "饤ȥå(ǽ),庬,COMBINING RIGHT TACK BELOW")
(11 90 "֥å(ǽ),,COMBINING BRIDGE BELOW")
(11 91 "Сƥåɥ֥å(ǽ),Ū,COMBINING INVERTED BRIDGE BELOW")
(11 92 "(ǽ),üŪ,COMBINING SQUARE BELOW")
(11 93 "(ǽ),ɡ,COMBINING TILDE")
(11 94 "եȥ󥰥(ǽ),ʹʤ,COMBINING LEFT ANGLE ABOVE")
(12 1 "1,DINGBAT NEGATIVE CIRCLED DIGIT ONE")
(12 2 "2,DINGBAT NEGATIVE CIRCLED DIGIT TWO")
(12 3 "3,DINGBAT NEGATIVE CIRCLED DIGIT THREE")
(12 4 "4,DINGBAT NEGATIVE CIRCLED DIGIT FOUR")
(12 5 "5,DINGBAT NEGATIVE CIRCLED DIGIT FIVE")
(12 6 "6,DINGBAT NEGATIVE CIRCLED DIGIT SIX")
(12 7 "7,DINGBAT NEGATIVE CIRCLED DIGIT SEVEN")
(12 8 "8,DINGBAT NEGATIVE CIRCLED DIGIT EIGHT")
(12 9 "9,DINGBAT NEGATIVE CIRCLED DIGIT NINE")
(12 10 "10,DINGBAT NEGATIVE CIRCLED NUMBER TEN")
(12 11 "11,NEGATIVE CIRCLED NUMBER ELEVEN")
(12 12 "12,NEGATIVE CIRCLED NUMBER TWELVE")
(12 13 "13,NEGATIVE CIRCLED NUMBER THIRTEEN")
(12 14 "14,NEGATIVE CIRCLED NUMBER FOURTEEN")
(12 15 "15,NEGATIVE CIRCLED NUMBER FIFTEEN")
(12 16 "16,NEGATIVE CIRCLED NUMBER SIXTEEN")
(12 17 "17,NEGATIVE CIRCLED NUMBER SEVENTEEN")
(12 18 "18,NEGATIVE CIRCLED NUMBER EIGHTEEN")
(12 19 "19,NEGATIVE CIRCLED NUMBER NINETEEN")
(12 20 "20,NEGATIVE CIRCLED NUMBER TWENTY")
(12 21 "޿1ʸ,SMALL ROMAN NUMERAL ONE")
(12 22 "޿2ʸ,SMALL ROMAN NUMERAL TWO")
(12 23 "޿3ʸ,SMALL ROMAN NUMERAL THREE")
(12 24 "޿4ʸ,SMALL ROMAN NUMERAL FOUR")
(12 25 "޿5ʸ,SMALL ROMAN NUMERAL FIVE")
(12 26 "޿6ʸ,SMALL ROMAN NUMERAL SIX")
(12 27 "޿7ʸ,SMALL ROMAN NUMERAL SEVEN")
(12 28 "޿8ʸ,SMALL ROMAN NUMERAL EIGHT")
(12 29 "޿9ʸ,SMALL ROMAN NUMERAL NINE")
(12 30 "޿10ʸ,SMALL ROMAN NUMERAL TEN")
(12 31 "޿11ʸ,SMALL ROMAN NUMERAL ELEVEN")
(12 32 "޿12ʸ,SMALL ROMAN NUMERAL TWELVE")
(12 33 "Aʸ,CIRCLED LATIN SMALL LETTER A")
(12 34 "Bʸ,CIRCLED LATIN SMALL LETTER B")
(12 35 "Cʸ,CIRCLED LATIN SMALL LETTER C")
(12 36 "Dʸ,CIRCLED LATIN SMALL LETTER D")
(12 37 "Eʸ,CIRCLED LATIN SMALL LETTER E")
(12 38 "Fʸ,CIRCLED LATIN SMALL LETTER F")
(12 39 "Gʸ,CIRCLED LATIN SMALL LETTER G")
(12 40 "Hʸ,CIRCLED LATIN SMALL LETTER H")
(12 41 "Iʸ,CIRCLED LATIN SMALL LETTER I")
(12 42 "Jʸ,CIRCLED LATIN SMALL LETTER J")
(12 43 "Kʸ,CIRCLED LATIN SMALL LETTER K")
(12 44 "Lʸ,CIRCLED LATIN SMALL LETTER L")
(12 45 "Mʸ,CIRCLED LATIN SMALL LETTER M")
(12 46 "Nʸ,CIRCLED LATIN SMALL LETTER N")
(12 47 "Oʸ,CIRCLED LATIN SMALL LETTER O")
(12 48 "Pʸ,CIRCLED LATIN SMALL LETTER P")
(12 49 "Qʸ,CIRCLED LATIN SMALL LETTER Q")
(12 50 "Rʸ,CIRCLED LATIN SMALL LETTER R")
(12 51 "Sʸ,CIRCLED LATIN SMALL LETTER S")
(12 52 "Tʸ,CIRCLED LATIN SMALL LETTER T")
(12 53 "Uʸ,CIRCLED LATIN SMALL LETTER U")
(12 54 "Vʸ,CIRCLED LATIN SMALL LETTER V")
(12 55 "Wʸ,CIRCLED LATIN SMALL LETTER W")
(12 56 "Xʸ,CIRCLED LATIN SMALL LETTER X")
(12 57 "Yʸ,CIRCLED LATIN SMALL LETTER Y")
(12 58 "Zʸ,CIRCLED LATIN SMALL LETTER Z")
(12 59 "ݥ,CIRCLED KATAKANA A")
(12 60 "ݥ,CIRCLED KATAKANA I")
(12 61 "ݥ,CIRCLED KATAKANA U")
(12 62 "ݥ,CIRCLED KATAKANA E")
(12 63 "ݥ,CIRCLED KATAKANA O")
(12 64 "ݥ,CIRCLED KATAKANA KA")
(12 65 "ݥ,CIRCLED KATAKANA KI")
(12 66 "ݥ,CIRCLED KATAKANA KU")
(12 67 "ݥ,CIRCLED KATAKANA KE")
(12 68 "ݥ,CIRCLED KATAKANA KO")
(12 69 "ݥ,CIRCLED KATAKANA SA")
(12 70 "ݥ,CIRCLED KATAKANA SI")
(12 71 "ݥ,CIRCLED KATAKANA SU")
(12 72 "ݥ,CIRCLED KATAKANA SE")
(12 73 "ݥ,CIRCLED KATAKANA SO")
(12 74 "ݥ,CIRCLED KATAKANA TA")
(12 75 "ݥ,CIRCLED KATAKANA TI")
(12 76 "ݥ,CIRCLED KATAKANA TU")
(12 77 "ݥ,CIRCLED KATAKANA TE")
(12 78 "ݥ,CIRCLED KATAKANA TO")
(12 79 "ݥ,CIRCLED KATAKANA RO")
(12 80 "ݥ,CIRCLED KATAKANA HA")
(12 81 "ݥ,CIRCLED KATAKANA NI")
(12 82 "ݥ,CIRCLED KATAKANA HO")
(12 83 "ݥ,CIRCLED KATAKANA HE")
(12 93 "֥륢,TWO ASTERISKS ALIGNED VERTICALLY")
(12 94 "ƥꥺ,ASTERISM")
(13 1 "1,CIRCLED DIGIT ONE")
(13 2 "2,CIRCLED DIGIT TWO")
(13 3 "3,CIRCLED DIGIT THREE")
(13 4 "4,CIRCLED DIGIT FOUR")
(13 5 "5,CIRCLED DIGIT FIVE")
(13 6 "6,CIRCLED DIGIT SIX")
(13 7 "7,CIRCLED DIGIT SEVEN")
(13 8 "8,CIRCLED DIGIT EIGHT")
(13 9 "9,CIRCLED DIGIT NINE")
(13 10 "10,CIRCLED NUMBER TEN")
(13 11 "11,CIRCLED NUMBER ELEVEN")
(13 12 "12,CIRCLED NUMBER TWELVE")
(13 13 "13,CIRCLED NUMBER THIRTEEN")
(13 14 "14,CIRCLED NUMBER FOURTEEN")
(13 15 "15,CIRCLED NUMBER FIFTEEN")
(13 16 "16,CIRCLED NUMBER SIXTEEN")
(13 17 "17,CIRCLED NUMBER SEVENTEEN")
(13 18 "18,CIRCLED NUMBER EIGHTEEN")
(13 19 "19,CIRCLED NUMBER NINETEEN")
(13 20 "20,CIRCLED NUMBER TWENTY")
(13 21 "޿1,ROMAN NUMERAL ONE")
(13 22 "޿2,ROMAN NUMERAL TWO")
(13 23 "޿3,ROMAN NUMERAL THREE")
(13 24 "޿4,ROMAN NUMERAL FOUR")
(13 25 "޿5,ROMAN NUMERAL FIVE")
(13 26 "޿6,ROMAN NUMERAL SIX")
(13 27 "޿7,ROMAN NUMERAL SEVEN")
(13 28 "޿8,ROMAN NUMERAL EIGHT")
(13 29 "޿9,ROMAN NUMERAL NINE")
(13 30 "޿10,ROMAN NUMERAL TEN")
(13 31 "޿11,ROMAN NUMERAL ELEVEN")
(13 32 "ѥߥ,SQUARE MIRI")
(13 33 "ѥ,SQUARE KIRO")
(13 34 "ѥ,SQUARE SENTI")
(13 35 "ѥ᡼ȥ,SQUARE MEETORU")
(13 36 "ѥ,SQUARE GURAMU")
(13 37 "ѥȥ,SQUARE TON")
(13 38 "ѥ,SQUARE AARU")
(13 39 "ѥإ,SQUARE HEKUTAARU")
(13 40 "ѥåȥ,SQUARE RITTORU")
(13 41 "ѥå,SQUARE WATTO")
(13 42 "ѥ꡼,SQUARE KARORII")
(13 43 "ѥɥ,SQUARE DORU")
(13 44 "ѥ,SQUARE SENTO")
(13 45 "ѥѡ,SQUARE PAASENTO")
(13 46 "ѥߥС,SQUARE MIRIBAARU")
(13 47 "ѥڡ,SQUARE PEEZI")
(13 48 "MM,SQUARE MM")
(13 49 "CM,SQUARE CM")
(13 50 "KM,SQUARE KM")
(13 51 "MG,SQUARE MG")
(13 52 "KG,SQUARE KG")
(13 53 "CC,SQUARE CC")
(13 54 "M2,SQUARE M SQUARED")
(13 55 "޿12,ROMAN NUMERAL TWELVE")
(13 63 "Ѹʿ,SQUARE ERA NAME HEISEI")
(13 64 "Ϥ֥ߥ˥塼,REVERSED DOUBLE PRIME QUOTATION MARK")
(13 65 "֥ߥ˥塼,LOW DOUBLE PRIME QUOTATION MARK")
(13 66 "NO,NUMERO SIGN")
(13 67 "KK,SQUARE KK")
(13 68 "TEL,TELEPHONE SIGN")
(13 69 "դ,CIRCLED IDEOGRAPH HIGH")
(13 70 "դ,CIRCLED IDEOGRAPH CENTRE")
(13 71 "դ,CIRCLED IDEOGRAPH LOW")
(13 72 "դ,CIRCLED IDEOGRAPH LEFT")
(13 73 "դ,CIRCLED IDEOGRAPH RIGHT")
(13 74 "ѳդ,PARENTHESIZED IDEOGRAPH STOCK")
(13 75 "ѳդͭ,PARENTHESIZED IDEOGRAPH HAVE")
(13 76 "ѳդ,PARENTHESIZED IDEOGRAPH REPRESENT")
(13 77 "Ѹ,SQUARE ERA NAME MEIZI")
(13 78 "Ѹ,SQUARE ERA NAME TAISYOU")
(13 79 "Ѹ澼,SQUARE ERA NAME SYOUWA")
(13 83 "ϩʬ,CONTOUR INTEGRAL")
(13 88 "եȥꥢ,ľ,RIGHT ANGLE")
(13 89 "ľѻ,RIGHT TRIANGLE")
(13 93 "ͤɩ,BLACK DIAMOND MINUS WHITE X")
(13 94 "ؼޡ,WHITE RIGHT POINTING INDEX")

(14 1 "2003")
(15 94 "2003ɲ")
(47 52 "2003ɲ")
(47 94 "2003ɲ")
(84 7 "2003ɲ")
(94 90 "2003ɲ")
(94 91 "2003ɲ")
(94 92 "2003ɲ")
(94 93 "2003ɲ")
(94 94 "2003ɲ")

)))
    (mapcar (lambda (x) (skk-tankan-set-char-annotaion
                         (make-char 'japanese-jisx0213-1
				    (+ 32 (car x)) (+ 32 (nth 1 x)))
                         (nth 2 x)))
            l)))

(provide 'skk-tankan)
;;; skk-tankan.el ends here
