/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * user_manage.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: user_manage.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __USER_MANAGE_H__
#define __USER_MANAGE_H__

extern GPtrArray *hub_user_list;    /* list of all users connected to the hub */
extern GPtrArray *hub_op_list;      /* list of all ops connected to the hub (ops are also in the user_list) */

extern GPtrArray *hub_user_xtra_info;			/* array of extra data stored for each hub user */
                                    /* the nth pointer of this array is for the nth user of the hub_user_list */
												/* a user having no extra info has a null pointer as extra info */

extern GPtrArray *hub_user_uinfo;     /* it is the result of /UINFO command for each user */

typedef enum
{
	UNDEFINED=0,
	ACTIVE,
	PASSIVE
} UCNX;

typedef struct
{
	UCNX cnx_type;				/* what type of connection the remote user has */
	char *cnx_addr;			/* address of the remote user (NULL for UNDEFINED and PASSIVE, !=NULL for ACTIVE) */
} XTRA_INFO;

/*******************************************************/
/* check if the given username is inside the user_list */
/*******************************************************/
/* output: 0=no, 1=yes */
/***********************/
int user_in_list(GPtrArray *user_list, char *username);

/****************************************************/
/* empty the hub_user_list array                    */
/* (hub_user_xtra_info is cleared at the same time) */
/****************************************************/
void reset_hub_user_list(void);

/**********************************************************************/
/* add the given nick to the hub user list                            */
/* (an empty xtra_info is initialized for this user at the same time) */
/**********************************************************************/
void add_user_to_user_list(char *nick);

/*****************************************/
/* add the given nick to the hub op list */
/*****************************************/
void add_user_to_op_list(char *nick);

/************************************************/
/* remove the given nick to the hub user list   */
/* (user xtra_info is deleted at the same time) */
/**************************************************/
void remove_user_to_user_list(char *nick);

/******************************/
/* set user extra information */
/******************************/
void set_xtra_information_cnx(char *nick, UCNX type, char *addr);

/******************************/
/* get user extra information */
/*************************************************************/
/* output: *type is set to UNDEFINED, PASSIVE or ACTIVE      */
/*         the returned g_string (if not NULL) must be freed */
/*         when useless.                                     */
/*************************************************************/
GString *get_xtra_information_cnx(char *nick, UCNX *type);

/******************/
/* set user UINFO */
/******************/
void set_cached_user_uinfo(char *nick, char *uinfo);

/******************/
/* get user UINFO */
/*************************************************************/
/* output: the returned g_string (if not NULL) must be freed */
/*         when useless.                                     */
/*************************************************************/
GString *get_cached_user_uinfo(char *nick);

/**************************************************/
/* check if the given user has the following flag */
/**************************************************/
/* output: 1= yes, the user has this flag */
/*         0= no                          */
/******************************************/
int user_has_flag(char *nickname,const char *flag);

#endif
