#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>

#include "main.h"
#include "misc_gtk.h"
#include "bookmark.h"
#include "gui_layout.h"

/**************************************************************/
/* colorize entry of favorite clist existing in running clist */
/**************************************************************/
void colorize_favorite(GtkCList *fav_clst, GtkCList *running_clst)
{
	int i;
	char *t;
	int fnd;

	gtk_clist_freeze(fav_clst);
	for(i=0;i<fav_clst->rows;i++)
	{
		fnd=0;
		gtk_clist_get_text(fav_clst,i,2,&t);
		if(t!=NULL)
		{
			char *u;
			int j;

			for(j=0;j<running_clst->rows;j++)
			{
				gtk_clist_get_text(running_clst,j,0,&u);
				if((u!=NULL)&&(!strcmp(t,u)))
				{
					fnd=1;
					break;
				}
			}
		}

		if(fnd)
		{
			gtk_clist_set_background(fav_clst,i,&green);
		}
		else
		{
			gtk_clist_set_background(fav_clst,i,&white);
		}
	}

	gtk_clist_thaw(fav_clst);
}

/********************************************************************/
/* this function reloads the bookmark into the 'hub_favorite_clist' */
/********************************************************************/
void reload_bookmark(void)
{
	GtkWidget *w;
	GtkCList *clst;
	int nb_entry;
	gchar **entry_list;
	int added=0;

	w=get_widget_by_widget_name("hub_favorite_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

	gtk_clist_freeze(clst);

	gnome_config_get_vector("/" PROGNAME "/Bookmark/Content",&nb_entry,&entry_list);

	if((nb_entry==0)||(entry_list==NULL))
	{
		gtk_clist_clear(clst);
	}
	else
	{
		/* for each clist entry, there is 3 vector entries (hubname,description,address) */
		int fnd;
		int i,j;

		/* remove the clist entry not in the vector entry */
		/* and the vector entry in the clist entry */
		for(i=clst->rows-1;i>=0;i--)
		{
			char *hn,*ds,*ad;

			fnd=0;

			gtk_clist_get_text(clst,i,0,&hn);
			gtk_clist_get_text(clst,i,1,&ds);
			gtk_clist_get_text(clst,i,2,&ad);

			if((hn!=NULL)&&(ds!=NULL)&&(ad!=NULL))
			{
				for(j=0;j<nb_entry;j+=3)
				{
					if(entry_list[j+1][0]=='\001')		/* deleted entry ? (we use the address to avoid problem) */
						continue;
	
					if( (!strcmp(hn,entry_list[j])) &&
						 (!strcmp(ds,entry_list[j+1])) &&
						 (!strcmp(ad,entry_list[j+2])) )
					{
						entry_list[j+1][0]='\001';
						fnd=1;
						break;
					}
				}
			}

			if(!fnd)
			{
				gtk_clist_remove(clst,i);
			}
		}

		/* now, entry_list contains only missing clist entry */
		for(j=0;j<nb_entry;j+=3)
		{
			if(entry_list[j+1][0]=='\001')		/* deleted entry ? (we use the address to avoid problem) */
				continue;

			added=1;
			gtk_clist_append(clst,&(entry_list[j]));
		}
	}

	if(added)
		gtk_clist_sort(clst);

	colorize_favorite(clst,GTK_CLIST(get_widget_by_widget_name("running_hub_clist")));
	gtk_clist_thaw(clst);

	if(entry_list!=NULL)
		g_strfreev(entry_list);
}

/***********************************/
/* add a new entry to the bookmark */
/************************************************************************************************/
/* to avoid conflict with other running dc_gui, we reload the bookmark just before modifying it */
/************************************************************************************************/
void add_entry_to_bookmark(char *name,char *description, char *address,int no_reload)
{
	int nb_entry;
	gchar **entry_list;
	GStringChunk *gsc;
	GPtrArray *gpa;
	int i;

	gnome_config_get_vector("/" PROGNAME "/Bookmark/Content",&nb_entry,&entry_list);

	/* we copy the vector in a pointer array and we modify the copy */
	gsc=g_string_chunk_new(128);
	gpa=g_ptr_array_new();

	if(entry_list!=NULL)
	{
		for(i=0;i<nb_entry;i+=3)
		{
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i]));
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i+1]));
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i+2]));
		}
	}

	/* entry list is no more useful */
	if(entry_list!=NULL)
		g_strfreev(entry_list);

	/* add the new entry */
	g_ptr_array_add(gpa,g_string_chunk_insert(gsc,name));
	g_ptr_array_add(gpa,g_string_chunk_insert(gsc,description));
	g_ptr_array_add(gpa,g_string_chunk_insert(gsc,address));
	
	/* and save the vector */
	gnome_config_set_vector("/" PROGNAME "/Bookmark/Content",gpa->len,(const char* *)(gpa->pdata));

	/* and delete temporary storage */
	g_ptr_array_free(gpa,TRUE);
	g_string_chunk_free(gsc);
	gnome_config_sync ();

	if(no_reload!=1)
		reload_bookmark();
}

/**************************************/
/* delete a new entry to the bookmark */
/************************************************************************************************/
/* to avoid conflict with other running dc_gui, we reload the bookmark just before modifying it */
/************************************************************************************************/
void delete_entry_from_bookmark(char *name,char *description, char *address, int no_reload)
{
	int nb_entry;
	gchar **entry_list;
	GStringChunk *gsc;
	GPtrArray *gpa;
	int i;

	gnome_config_get_vector("/" PROGNAME "/Bookmark/Content",&nb_entry,&entry_list);

	/* we copy the vector in a pointer array and we modify the copy */
	gsc=g_string_chunk_new(128);
	gpa=g_ptr_array_new();

	if(entry_list!=NULL)
	{
		for(i=0;i<nb_entry;i+=3)
		{
			/* suppress the entry if we met it */
			if((!strcmp(entry_list[i],name))&&(!strcmp(entry_list[i+1],description))&&(!strcmp(entry_list[i+2],address)))
				continue;
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i]));
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i+1]));
			g_ptr_array_add(gpa,g_string_chunk_insert(gsc,entry_list[i+2]));
		}
	}

	/* entry list is no more useful */
	if(entry_list!=NULL)
		g_strfreev(entry_list);

	/* and save the vector */
	gnome_config_set_vector("/" PROGNAME "/Bookmark/Content",gpa->len,(const char* *)(gpa->pdata));

	/* and delete temporary storage */
	g_ptr_array_free(gpa,TRUE);
	g_string_chunk_free(gsc);
	gnome_config_sync ();

	if(no_reload!=1)
		reload_bookmark();
}


