/*
 * $Id: dbdimp.h,v 2.3 2001/05/11 08:55:53 flatline Exp $
 * Copyright (c) 1997 Jeff Urlwin
 * portions Copyright (c) 1997  Thomas K. Wenrich
 * portions Copyright (c) 1994,1995,1996  Tim Bunce
 * portions Copyright (c) 2000  Cristian Giussani
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Artistic License, as specified in the Perl README file.
 *
 */

#include "protocol.h"

/* This holds global data of the driver itself.
 */
struct imp_drh_st {
    dbih_drc_t com;		/* MUST be first element in structure	*/
};

/* Define dbh implementor data structure 
   This holds everything to describe the database connection.
 */
struct imp_dbh_st {
    dbih_dbc_t com;		/* MUST be first element in structure	*/

    dbftp_result *results;
};


/* Define sth implementor data structure */
struct imp_sth_st {
    dbih_stc_t com;		/* MUST be first element in structure	*/

    char *query;

    int rows;
};

#define IMP_STH_EXECUTING       0x0001

/* These defines avoid name clashes for multiple statically linked DBD's        */

#define dbd_init		dbftp_init
#define dbd_db_login		dbftp_db_login
#define dbd_db_do		dbftp_db_do
#define dbd_db_commit		dbftp_db_commit
#define dbd_db_rollback		dbftp_db_rollback
#define dbd_db_disconnect	dbftp_db_disconnect
#define dbd_db_destroy		dbftp_db_destroy
#define dbd_db_STORE_attrib	dbftp_db_STORE_attrib
#define dbd_db_FETCH_attrib	dbftp_db_FETCH_attrib
#define dbd_st_prepare		dbftp_st_prepare
#define dbd_st_rows		dbftp_st_rows
#define dbd_st_execute		dbftp_st_execute
#define dbd_st_fetch		dbftp_st_fetch
#define dbd_st_finish		dbftp_st_finish
#define dbd_st_destroy		dbftp_st_destroy
#define dbd_st_blob_read	dbftp_st_blob_read
#define dbd_st_STORE_attrib	dbftp_st_STORE_attrib
#define dbd_st_FETCH_attrib	dbftp_st_FETCH_attrib
#define dbd_describe		dbftp_describe
#define dbd_bind_ph		dbftp_bind_ph
#define dbd_error		dbftp_error

/* end */
