' Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com 

Imports System.IO
Imports System.IO.IsolatedStorage
Imports Db4objects.Db4o
Imports Db4objects.Db4o.IO
Imports Db4objects.Db4o.Internal

Namespace Db4objects.Db4odoc.IsolatedStorage
    ''' <summary>IO adapter for isolated storage files.</summary>
    ''' <remarks>IO adapter for isolated storage files.</remarks>
    Public Class IsolatedStorageFileAdapter
        Inherits IoAdapter
        Private _path As String

        Private _delegate As Db4oIsolatedStorageFile

        Public Sub New()
        End Sub


        Protected Sub New(ByVal path As String, ByVal lockFile As Boolean, ByVal initialLength As Long)
            Dim ok As Boolean = False
            Try
                _path = path
                _delegate = New Db4oIsolatedStorageFile(_path, "rw")
                If initialLength > 0 Then
                    _delegate.Seek(initialLength - 1)
                    _delegate.Write(New Byte() {0})
                End If
                ok = True
            Catch e As IOException
                Throw New Db4oIOException(e)
            Finally
                If Not ok Then
                    Close()
                End If
            End Try
        End Sub
        ' end IsolatedStorageFileAdapter

        Public Overloads Overrides Sub Close()
            Try
                If _delegate IsNot Nothing Then
                    _delegate.Close()
                End If
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Sub
        ' end Close

        Public Overloads Overrides Sub Delete(ByVal path As String)
            Dim isf As IsolatedStorageFile = IsolatedStorageFile.GetUserStoreForAssembly()
            isf.DeleteFile(path)
        End Sub
        ' end Delete

        Public Overloads Overrides Function Exists(ByVal path As String) As Boolean
            Dim isf As IsolatedStorageFile = IsolatedStorageFile.GetUserStoreForAssembly()
            Dim res As Boolean = isf.GetFileNames(path).Length > 0
            Return res
        End Function
        ' end Exists

        Public Overloads Overrides Function GetLength() As Long
            Try
                Return _delegate.Length()
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Function
        ' end GetLength

        Public Overloads Overrides Function Open(ByVal path As String, ByVal lockFile As Boolean, ByVal initialLength As Long) As IoAdapter
            Return New IsolatedStorageFileAdapter(path, lockFile, initialLength)
        End Function
        ' end Open

        Public Overloads Overrides Function Read(ByVal bytes As Byte(), ByVal length As Integer) As Integer
            Try
                Return _delegate.Read(bytes, 0, length)
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Function
        ' end Read

        Public Overloads Overrides Sub Seek(ByVal pos As Long)
            Try
                _delegate.Seek(pos)
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Sub
        ' end Seek

        Public Overloads Overrides Sub Sync()
            Try
                _delegate.GetFD().Sync()
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Sub
        ' end Sync

        Public Overloads Overrides Sub Write(ByVal buffer As Byte(), ByVal length As Integer)
            Try
                _delegate.Write(buffer, 0, length)
            Catch e As IOException
                Throw New Db4oIOException(e)
            End Try
        End Sub
        ' end Write
    End Class
End Namespace