/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Internal.CS.Messages;

namespace Db4objects.Db4o.Internal.CS.Messages
{
	public class MObjectByUuid : MsgD, IServerSideMessage
	{
		public bool ProcessAtServer()
		{
			long uuid = ReadLong();
			byte[] signature = ReadBytes();
			int id = 0;
			Transaction trans = Transaction();
			lock (StreamLock())
			{
				try
				{
					HardObjectReference hardRef = trans.GetHardReferenceBySignature(uuid, signature);
					if (hardRef._reference != null)
					{
						id = hardRef._reference.GetID();
					}
				}
				catch (Exception e)
				{
				}
			}
			Write(Msg.ObjectByUuid.GetWriterForInt(trans, id));
			return true;
		}
	}
}
