/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Foundation.Network;

namespace Db4objects.Db4o.Foundation.Network
{
	public interface ISocket4
	{
		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		void Close();

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		void Flush();

		bool IsConnected();

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		int Read();

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		int Read(byte[] a_bytes, int a_offset, int a_length);

		void SetSoTimeout(int timeout);

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		void Write(byte[] bytes);

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		void Write(byte[] bytes, int off, int len);

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		void Write(int i);

		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		ISocket4 OpenParalellSocket();
	}
}
