/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4oUnit.Extensions;
using Db4objects.Db4o.Tests.Common.Assorted;

namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class SimplestPossibleParentChildTestCase : AbstractDb4oTestCase
	{
		public static void Main(string[] args)
		{
			new SimplestPossibleParentChildTestCase().RunAll();
		}

		public class ParentItem
		{
			public object child;
		}

		public class ChildItem
		{
		}

		/// <exception cref="System.Exception"></exception>
		protected override void Store()
		{
			SimplestPossibleParentChildTestCase.ParentItem parentItem = new SimplestPossibleParentChildTestCase.ParentItem
				();
			parentItem.child = new SimplestPossibleParentChildTestCase.ChildItem();
			Store(parentItem);
		}

		public virtual void Test()
		{
			SimplestPossibleParentChildTestCase.ParentItem parentItem = (SimplestPossibleParentChildTestCase.ParentItem
				)RetrieveOnlyInstance(typeof(SimplestPossibleParentChildTestCase.ParentItem));
			Assert.IsInstanceOf(typeof(SimplestPossibleParentChildTestCase.ChildItem), parentItem
				.child);
		}
	}
}
