/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Diagnostic;
using Db4objects.Db4o.Query;
using Db4objects.Db4o.Tests.Common.Api;
using Db4objects.Db4o.Tests.Common.Assorted;

namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class InvalidOffsetInDeleteTestCase : TestWithTempFile, IDiagnosticListener
	{
		public class Item : InvalidOffsetInDeleteTestCase.Parent
		{
			public string _itemName;
		}

		public class Parent
		{
			public string _parentName;
		}

		public virtual void Test()
		{
			IConfiguration config = Db4oFactory.NewConfiguration();
			Configure(config);
			IObjectContainer objectContainer = Db4oFactory.OpenFile(config, TempFile());
			InvalidOffsetInDeleteTestCase.Item item = new InvalidOffsetInDeleteTestCase.Item(
				);
			item._itemName = "item";
			item._parentName = "parent";
			objectContainer.Store(item);
			objectContainer.Close();
			config = Db4oFactory.NewConfiguration();
			Configure(config);
			objectContainer = Db4oFactory.OpenFile(config, TempFile());
			IQuery query = objectContainer.Query();
			query.Constrain(typeof(InvalidOffsetInDeleteTestCase.Item));
			IObjectSet objectSet = query.Execute();
			item = (InvalidOffsetInDeleteTestCase.Item)objectSet.Next();
			objectContainer.Store(item);
			objectContainer.Close();
		}

		private void Configure(IConfiguration config)
		{
			config.Diagnostic().AddListener(this);
			config.GenerateVersionNumbers(ConfigScope.Globally);
			config.GenerateUUIDs(ConfigScope.Globally);
			config.ObjectClass(typeof(InvalidOffsetInDeleteTestCase.Item)).ObjectField("_itemName"
				).Indexed(true);
			config.ObjectClass(typeof(InvalidOffsetInDeleteTestCase.Parent)).ObjectField("_parentName"
				).Indexed(true);
		}

		public virtual void OnDiagnostic(IDiagnostic d)
		{
			if (d is DeletionFailed)
			{
				Assert.Fail("No deletion failed diagnostic message expected.");
			}
		}
	}
}
