/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	public class Unobfuscated
	{
		private static readonly Sharpen.Util.Random random = new Sharpen.Util.Random();

		public static bool CreateDb4oList(object a_stream)
		{
			((Db4objects.Db4o.Internal.ObjectContainerBase)a_stream).CheckClosed();
			return !((Db4objects.Db4o.Internal.ObjectContainerBase)a_stream).IsInstantiating(
				);
		}

		public static byte[] GenerateSignature()
		{
			Db4objects.Db4o.Internal.StatefulBuffer writer = new Db4objects.Db4o.Internal.StatefulBuffer
				(null, 300);
			writer.WriteLong(Sharpen.Runtime.CurrentTimeMillis());
			writer.WriteLong(RandomLong());
			writer.WriteLong(RandomLong() + 1);
			return writer.GetWrittenBytes();
		}

		internal static void LogErr(Db4objects.Db4o.Config.IConfiguration config, int code
			, string msg, System.Exception t)
		{
			Db4objects.Db4o.Internal.Messages.LogErr(config, code, msg, t);
		}

		internal static void PurgeUnsychronized(object a_stream, object a_object)
		{
			((Db4objects.Db4o.Internal.ObjectContainerBase)a_stream).Purge1(a_object);
		}

		public static long RandomLong()
		{
			return random.NextLong();
		}

		internal static void ShutDownHookCallback(object a_stream)
		{
			((Db4objects.Db4o.Internal.ObjectContainerBase)a_stream).FailedToShutDown();
		}
	}
}
