/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS.Messages
{
	public abstract class MsgBlob : Db4objects.Db4o.Internal.CS.Messages.MsgD, Db4objects.Db4o.IBlobStatus
	{
		public Db4objects.Db4o.Internal.BlobImpl _blob;

		internal int _currentByte;

		internal int _length;

		public virtual double GetStatus()
		{
			if (_length != 0)
			{
				return (double)_currentByte / (double)_length;
			}
			return Db4objects.Db4o.Ext.Status.ERROR;
		}

		public abstract void ProcessClient(Db4objects.Db4o.Foundation.Network.ISocket4 sock
			);

		internal virtual Db4objects.Db4o.Internal.BlobImpl ServerGetBlobImpl()
		{
			Db4objects.Db4o.Internal.BlobImpl blobImpl = null;
			int id = _payLoad.ReadInt();
			Db4objects.Db4o.Internal.ObjectContainerBase stream = Stream();
			lock (stream.i_lock)
			{
				blobImpl = (Db4objects.Db4o.Internal.BlobImpl)stream.GetByID1(Transaction(), id);
				stream.Activate1(Transaction(), blobImpl, 3);
			}
			return blobImpl;
		}

		protected virtual void Copy(Db4objects.Db4o.Foundation.Network.ISocket4 sock, Sharpen.IO.OutputStream
			 rawout, int length, bool update)
		{
			Sharpen.IO.BufferedOutputStream @out = new Sharpen.IO.BufferedOutputStream(rawout
				);
			byte[] buffer = new byte[Db4objects.Db4o.Internal.BlobImpl.COPYBUFFER_LENGTH];
			int totalread = 0;
			while (totalread < length)
			{
				int stilltoread = length - totalread;
				int readsize = (stilltoread < buffer.Length ? stilltoread : buffer.Length);
				int curread = sock.Read(buffer, 0, readsize);
				if (curread < 0)
				{
					throw new System.IO.IOException();
				}
				@out.Write(buffer, 0, curread);
				totalread += curread;
				if (update)
				{
					_currentByte += curread;
				}
			}
			@out.Flush();
			@out.Close();
		}

		protected virtual void Copy(Sharpen.IO.InputStream rawin, Db4objects.Db4o.Foundation.Network.ISocket4
			 sock, bool update)
		{
			Sharpen.IO.BufferedInputStream @in = new Sharpen.IO.BufferedInputStream(rawin);
			byte[] buffer = new byte[Db4objects.Db4o.Internal.BlobImpl.COPYBUFFER_LENGTH];
			int bytesread = -1;
			while ((bytesread = rawin.Read(buffer)) >= 0)
			{
				sock.Write(buffer, 0, bytesread);
				if (update)
				{
					_currentByte += bytesread;
				}
			}
			@in.Close();
		}
	}
}
