/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	/// <exclude></exclude>
	public class KeySpecHashtable4 : Db4objects.Db4o.Foundation.Hashtable4
	{
		private KeySpecHashtable4() : base((Db4objects.Db4o.Foundation.IDeepClone)null)
		{
		}

		public KeySpecHashtable4(int a_size) : base(a_size)
		{
		}

		public virtual void Put(Db4objects.Db4o.Foundation.KeySpec spec, byte value)
		{
			base.Put(spec, value);
		}

		public virtual void Put(Db4objects.Db4o.Foundation.KeySpec spec, bool value)
		{
			base.Put(spec, value);
		}

		public virtual void Put(Db4objects.Db4o.Foundation.KeySpec spec, int value)
		{
			base.Put(spec, value);
		}

		public virtual void Put(Db4objects.Db4o.Foundation.KeySpec spec, object value)
		{
			base.Put(spec, value);
		}

		public virtual byte GetAsByte(Db4objects.Db4o.Foundation.KeySpec spec)
		{
			return ((byte)Get(spec));
		}

		public virtual bool GetAsBoolean(Db4objects.Db4o.Foundation.KeySpec spec)
		{
			return ((bool)Get(spec));
		}

		public virtual int GetAsInt(Db4objects.Db4o.Foundation.KeySpec spec)
		{
			return ((int)Get(spec));
		}

		public virtual Db4objects.Db4o.Foundation.TernaryBool GetAsTernaryBool(Db4objects.Db4o.Foundation.KeySpec
			 spec)
		{
			return (Db4objects.Db4o.Foundation.TernaryBool)Get(spec);
		}

		public virtual string GetAsString(Db4objects.Db4o.Foundation.KeySpec spec)
		{
			return (string)Get(spec);
		}

		public virtual object Get(Db4objects.Db4o.Foundation.KeySpec spec)
		{
			object value = base.Get(spec);
			if (value == null)
			{
				value = spec.DefaultValue();
				if (value != null)
				{
					base.Put(spec, value);
				}
			}
			return value;
		}

		public override object DeepClone(object obj)
		{
			return DeepCloneInternal(new Db4objects.Db4o.Foundation.KeySpecHashtable4(), obj);
		}
	}
}
