/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Fieldindex
{
	public abstract class FieldIndexTestCaseBase : Db4oUnit.Extensions.AbstractDb4oTestCase
		, Db4oUnit.Extensions.Fixtures.IOptOutCS
	{
		public FieldIndexTestCaseBase() : base()
		{
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			IndexField(config, typeof(Db4objects.Db4o.Tests.Common.Fieldindex.FieldIndexItem)
				, "foo");
		}

		protected abstract override void Store();

		protected virtual void StoreItems(int[] foos)
		{
			for (int i = 0; i < foos.Length; i++)
			{
				Store(new Db4objects.Db4o.Tests.Common.Fieldindex.FieldIndexItem(foos[i]));
			}
		}

		protected virtual Db4objects.Db4o.Query.IQuery CreateQuery(int id)
		{
			Db4objects.Db4o.Query.IQuery q = CreateItemQuery();
			q.Descend("foo").Constrain(id);
			return q;
		}

		protected virtual Db4objects.Db4o.Query.IQuery CreateItemQuery()
		{
			return CreateQuery(typeof(Db4objects.Db4o.Tests.Common.Fieldindex.FieldIndexItem)
				);
		}

		protected virtual Db4objects.Db4o.Query.IQuery CreateQuery(System.Type clazz)
		{
			return CreateQuery(Trans(), clazz);
		}

		protected virtual Db4objects.Db4o.Query.IQuery CreateQuery(Db4objects.Db4o.Internal.Transaction
			 trans, System.Type clazz)
		{
			Db4objects.Db4o.Query.IQuery q = CreateQuery(trans);
			q.Constrain(clazz);
			return q;
		}

		protected virtual Db4objects.Db4o.Query.IQuery CreateItemQuery(Db4objects.Db4o.Internal.Transaction
			 trans)
		{
			Db4objects.Db4o.Query.IQuery q = CreateQuery(trans);
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Fieldindex.FieldIndexItem));
			return q;
		}

		private Db4objects.Db4o.Query.IQuery CreateQuery(Db4objects.Db4o.Internal.Transaction
			 trans)
		{
			return Stream().Query(trans);
		}
	}
}
