' Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com 
Imports System
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config
Imports Db4objects.Db4o.Defragment


Namespace Db4objects.Db4odoc.ClientServer
    Public Class DefragmentExample

        Public Shared Sub Main(ByVal args() As String)
            RunDefragment()
        End Sub
        ' end Main

        Public Shared Sub RunDefragment()
            Dim config As DefragmentConfig = New DefragmentConfig("sample.yap", "sample.bap")
            config.ForceBackupDelete(True)
            config.Db4oConfiguration(CreateDb4oConfiguration())
            config.StoredClassFilter(New AvailableTypeFilter())
            Try
                Defragment.Defrag(config)
            Catch ex As Exception
                System.Console.WriteLine(ex.Message)
            End Try
        End Sub
        ' end RunDefragment

        Private Function CreateDb4oConfiguration() As Configuration
            Dim config As Configuration = Db4oFactory.NewConfiguration()
            config.GenerateUUIDs(int.MaxValue)
            Return config
        End Function
        'end CreateDb4oConfiguration
    End Class
End Namespace

