#!/bin/sh

PROJECT=$1
TEST_DIR=$2
DART_DIR=/projects/Dart/Testing/Dart

DASHBOARD_MANAGER=${DART_DIR}/Source/Client/DashboardManager.tcl
LOCK=/tmp/${PROJECT}-rollup.lock

echo Content-type: text/html
echo ""
echo "<HTML>"
echo "<TITLE>${PROJECT} - Manual Dashboard Roll-up</TITLE>"
echo "<H1>${PROJECT} - Manual Dashboard Roll-up</H1>"

echo "<PRE><CODE>"

date
if [ -f ${LOCK} ]; then
  echo "Sorry, the dashboard is <B>locked</B> at the moment. Try later."
else
  touch ${LOCK} && echo "Lock file ${LOCK} created."
  # echo "Sorry, maintenance mode. Try later."
  cd ${TEST_DIR} &&
  /usr/bin/tclsh ${DASHBOARD_MANAGER} ${TEST_DIR}/DartConfiguration.tcl Nightly DashboardStart &&
  /usr/bin/tclsh ${DASHBOARD_MANAGER} ${TEST_DIR} Nightly DashboardEnd
  rm ${LOCK} && echo "Lock file ${LOCK} deleted."
fi

echo "</CODE></PRE>"

echo "</HTML>"
