/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.util.Vector;
import org.apache.xml.utils.IntVector;

public class DTMStringPool {
    Vector m_intToString;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    public static final int NULL = -1;

    public DTMStringPool() {
        this.m_intToString = new Vector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
        this.stringToIndex("");
    }

    public String indexToString(int n) throws ArrayIndexOutOfBoundsException {
        if (n == -1) {
            return null;
        }
        return (String)this.m_intToString.elementAt(n);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool dTMStringPool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        int n = 0;
        while (n <= 1) {
            int n2;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 != n3) {
                    System.out.println("\tMismatch populating pool: assigned " + n2 + " for create " + n3);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 != n3) {
                    System.out.println("\tMismatch in stringToIndex: returned " + n2 + " for lookup " + n3);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                String string = dTMStringPool.indexToString(n3);
                if (!stringArray2[n3].equals(string)) {
                    System.out.println("\tMismatch in indexToString: returned" + string + " for lookup " + n3);
                }
                ++n3;
            }
            dTMStringPool.removeAllElements();
            System.out.println("\nPass " + n + " complete\n");
            ++n;
        }
    }

    public void removeAllElements() {
        this.m_intToString.removeAllElements();
        int n = 0;
        while (n < 101) {
            this.m_hashStart[n] = -1;
            ++n;
        }
        this.m_hashChain.removeAllElements();
    }

    public int stringToIndex(String string) {
        int n;
        if (string == null) {
            return -1;
        }
        int n2 = string.hashCode() % 101;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n = this.m_hashStart[n2];
        while (n3 != -1) {
            if (this.m_intToString.elementAt(n3).equals(string)) {
                return n3;
            }
            n = n3;
            n3 = this.m_hashChain.elementAt(n3);
        }
        int n4 = this.m_intToString.size();
        this.m_intToString.addElement(string);
        this.m_hashChain.addElement(-1);
        if (n == -1) {
            this.m_hashStart[n2] = n4;
        } else {
            this.m_hashChain.setElementAt(n4, n);
        }
        return n4;
    }
}

