/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.xalan.transformer.KeyIterator;
import org.apache.xalan.transformer.KeyWalker;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.axes.LocPathIterator;

public class KeyRefIterator
extends LocPathIterator {
    private final QName m_name;
    private final XMLString m_lookupKey;
    private final KeyIterator m_ki;

    public KeyRefIterator(XMLString xMLString, KeyIterator keyIterator) {
        super(keyIterator.getPrefixResolver());
        this.m_ki = keyIterator;
        this.m_name = keyIterator.getName();
        this.m_lookupKey = xMLString;
        this.m_execContext = keyIterator.getXPathContext();
        this.setShouldCacheNodes(true);
    }

    public void addNode(int n) {
        NodeSetDTM nodeSetDTM = this.getCachedNodes();
        if (nodeSetDTM != null && !nodeSetDTM.contains(n)) {
            nodeSetDTM.addElement(n);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyRefIterator keyRefIterator = (KeyRefIterator)super.clone();
        return keyRefIterator;
    }

    public void detach() {
    }

    public QName getName() {
        return this.m_name;
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        NodeSetDTM nodeSetDTM = this.getCachedNodes();
        if (nodeSetDTM != null && this.m_next < nodeSetDTM.size()) {
            int n = nodeSetDTM.elementAt(this.m_next);
            this.setCurrentPos(++this.m_next);
            this.m_lastFetched = n;
            return n;
        }
        int n = -1;
        if (this.m_ki.getLookForMoreNodes()) {
            ((KeyWalker)this.m_ki.getFirstWalker()).m_lookupKey = this.m_lookupKey;
            n = this.m_ki.nextNode();
        }
        if (n != -1) {
            this.m_lastFetched = n;
            this.setCurrentPos(++this.m_next);
            return n;
        }
        this.m_foundLast = true;
        this.m_lastFetched = -1;
        return -1;
    }

    public void reset() {
        super.reset();
        this.setCurrentPos(0);
    }
}

