/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

public final class Cardinality {
    private Cardinality() {
    }

    public static final boolean allowsMany(int n) {
        return (n & 0x400) != 0;
    }

    public static final boolean allowsZero(int n) {
        return (n & 0x100) != 0;
    }

    public static final int union(int n, int n2) {
        int n3 = n | n2;
        if (n3 == 1280) {
            n3 = 1792;
        }
        return n3;
    }

    public static final boolean subsumes(int n, int n2) {
        return (n | n2) == n;
    }

    public static final int multiply(int n, int n2) {
        if (n == 256 || n2 == 256) {
            return 256;
        }
        if (n2 == 512) {
            return n;
        }
        if (n == 512) {
            return n2;
        }
        if (n == 768 && n2 == 768) {
            return 768;
        }
        if (n == 1536 && n2 == 1536) {
            return 1536;
        }
        return 1792;
    }

    public static String toString(int n) {
        switch (n) {
            case 768: {
                return "zero or one";
            }
            case 512: {
                return "exactly one";
            }
            case 1792: {
                return "zero or more";
            }
            case 1536: {
                return "one or more";
            }
            case 256: {
                return "exactly zero";
            }
        }
        throw new AssertionError((Object)"unknown cardinality value");
    }

    public static String getOccurrenceIndicator(int n) {
        switch (n) {
            case 768: {
                return "?";
            }
            case 512: {
                return "";
            }
            case 1792: {
                return "*";
            }
            case 1536: {
                return "+";
            }
        }
        throw new AssertionError((Object)"unknown cardinality value");
    }
}

