/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.xpath.XPathException;

public class XSLResultDocument
extends StyleElement {
    private Expression href;
    private int format = -1;
    private int validationAction = 4;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string5 = this.getNamePool().getClarkName(n2);
            if (string5 == "format") {
                string = attributeCollection.getValue(n).trim();
            } else if (string5 == "href") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string5 == "validation") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string5 == "type") {
                string4 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string2 != null) {
            this.href = this.makeAttributeValueTemplate(string2);
        }
        if (string != null) {
            try {
                this.format = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
        if (string3 == null) {
            this.validationAction = this.getContainingStyleSheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
            this.schemaType = this.getSchemaType(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (!this.getPreparedStyleSheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        Properties properties = null;
        try {
            properties = this.getPrincipalStyleSheet().gatherOutputProperties(this.format);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError("Named output format has not been defined");
            return null;
        }
        ResultDocument resultDocument = new ResultDocument(properties, this.href, this.getBaseURI(), this.validationAction, this.schemaType);
        this.compileChildren(executable, resultDocument);
        return resultDocument;
    }
}

