/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.DefiningVariable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.value.Value;

public final class Param
extends DefiningVariable {
    private Expression conversion = null;

    public void setConversion(Expression expression) {
        this.conversion = expression;
    }

    public String getInstructionName() {
        return "param";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        boolean bl;
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        if (this.isGlobal()) {
            bl = bindery.useGlobalParameter(this.variableFingerprint, this);
        } else {
            bl = bindery.useLocalParameter(this.variableFingerprint, this, this.isTunnelParam());
            if (bl && this.conversion != null) {
                bindery.setLocalVariable(this.getSlotNumber(), ExpressionTool.eagerEvaluate(this.conversion, xPathContext));
            }
        }
        if (!bl) {
            if (this.isRequiredParam()) {
                throw new TransformerException("No value supplied for required parameter");
            }
            if (this.isGlobal()) {
                Value value = this.getSelectValue(xPathContext);
                bindery.defineGlobalVariable(this, value);
            } else {
                Value value = this.getSelectValue(xPathContext);
                bindery.setLocalVariable(this.getSlotNumber(), value);
            }
        }
        return null;
    }
}

