/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.GlobalValidationContext;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationContext;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;

public abstract class ElementCreator
extends ExprInstruction {
    protected AttributeSet[] useAttributeSets;
    protected SchemaType schemaType;
    protected int validation;
    protected ValidationContext validationContext = GlobalValidationContext.getInstance();

    public ItemType getItemType() {
        return NodeKindTest.ELEMENT;
    }

    public int getCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof Expression) {
                    Expression expression = ((Expression)((Object)this.children[n])).analyze(staticContext);
                    if (expression instanceof Instr) {
                        this.children[n] = (Instr)((Object)expression);
                    } else {
                        SequenceInstruction sequenceInstruction = new SequenceInstruction(expression, null);
                        this.children[n] = sequenceInstruction;
                    }
                }
                ++n;
            }
        }
        return this;
    }

    public void setValidationMode(int n) {
        this.validation = n;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n] instanceof Expression) {
                Expression expression = ((Expression)((Object)this.children[n])).promote(promotionOffer);
                this.children[n] = expression instanceof Instr ? (Instr)((Object)expression) : new SequenceInstruction(expression, null);
            } else {
                throw new IllegalStateException("Children of an ExprInstruction must be Expressions");
            }
            ++n;
        }
    }

    protected abstract int getNameCode(XPathContext var1) throws TransformerException;

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2) throws TransformerException;

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        int n = this.getNameCode(xPathContext);
        if (n == -1) {
            this.skipElement(xPathContext);
            return null;
        }
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        SequenceReceiver sequenceReceiver2 = null;
        Receiver receiver = controller.getConfiguration().getElementValidator(sequenceReceiver, n, this.schemaType, this.validation, this.validationContext, controller.getNamePool());
        if (receiver != sequenceReceiver) {
            sequenceReceiver2 = sequenceReceiver;
            sequenceReceiver = new TreeReceiver(receiver);
            sequenceReceiver.setConfiguration(controller.getConfiguration());
            controller.setReceiver(sequenceReceiver);
        }
        sequenceReceiver.startElement(n, -1, 0);
        this.outputNamespaceNodes(xPathContext, sequenceReceiver);
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, controller);
        }
        this.processChildren(xPathContext);
        sequenceReceiver.endElement();
        if (sequenceReceiver2 != null) {
            controller.setReceiver(sequenceReceiver2);
        }
        return null;
    }

    private void skipElement(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        controller.getReceiver().startElement(-1, 0, 0);
        this.processChildren(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller = xPathContext.getController();
            SequenceReceiver sequenceReceiver = controller.getReceiver();
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            sequenceOutputter.setConfiguration(controller.getConfiguration());
            int n = this.getNameCode(xPathContext);
            Receiver receiver = controller.getConfiguration().getElementValidator(sequenceOutputter, n, this.schemaType, this.validation, this.validationContext, controller.getNamePool());
            SequenceReceiver sequenceReceiver2 = sequenceOutputter;
            if (receiver == sequenceOutputter) {
                controller.changeToSequenceOutputDestination(sequenceOutputter);
            } else {
                TreeReceiver treeReceiver = new TreeReceiver(receiver);
                treeReceiver.setConfiguration(controller.getConfiguration());
                controller.setReceiver(treeReceiver);
                sequenceReceiver2 = treeReceiver;
            }
            sequenceReceiver2.startDocument();
            sequenceReceiver2.startElement(n, -1, 0);
            this.outputNamespaceNodes(xPathContext, sequenceReceiver2);
            this.processChildren(xPathContext);
            sequenceReceiver2.endElement();
            sequenceReceiver2.endDocument();
            controller.resetOutputDestination(sequenceReceiver);
            return sequenceOutputter.getFirstItem();
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof ValidationException) {
                ((ValidationException)transformerException).setSourceLocator(this);
                ((ValidationException)transformerException).setSystemId(this.getSystemId());
            }
            if (transformerException.getLocator() == null) {
                transformerException.setLocator(this);
            }
            if (transformerException instanceof XPathException) {
                throw (XPathException)transformerException;
            }
            throw new XPathException.Dynamic(transformerException);
        }
    }
}

