/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Instruction[] actions;

    public Choose(Expression[] expressionArray, Instruction[] instructionArray) {
        this.conditions = expressionArray;
        this.actions = instructionArray;
    }

    public String getInstructionName() {
        return this.conditions.length == 1 ? "if" : "choose";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        int n = 0;
        while (n < this.conditions.length) {
            if (this.conditions[n].effectiveBooleanValue(xPathContext)) {
                return this.actions[n].processLeavingTail(xPathContext);
            }
            ++n;
        }
        return null;
    }
}

