/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DerivedAtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class ComputedExpression
implements Serializable,
Expression {
    protected int staticProperties = -1;
    protected short lineNumber = (short)-1;
    public static final Expression[] NO_ARGUMENTS = new Expression[0];

    public void setLineNumber(short s) {
        this.lineNumber = s;
    }

    public short getLineNumber() {
        return this.lineNumber;
    }

    public Expression simplify() throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x7F0000;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    protected abstract int computeCardinality();

    protected int computeSpecialProperties() {
        return 0;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x700;
    }

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x3F;
    }

    public int computeDependencies() {
        int n = this.getIntrinsicDependencies();
        Expression[] expressionArray = this.getSubExpressions();
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n |= (short)expressionArray[n2].getDependencies();
            ++n2;
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression[] getSubExpressions() {
        return NO_ARGUMENTS;
    }

    public boolean markTailFunctionCalls() {
        return false;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        Item item = this.evaluateItem(xPathContext);
        if (item instanceof DerivedAtomicValue) {
            item = ((DerivedAtomicValue)item).getPrimitiveValue();
        }
        if ((stringValue = (StringValue)item) == null) {
            return "";
        }
        return stringValue.getStringValue();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (!Cardinality.allowsMany(this.getCardinality())) {
            Item item = this.evaluateItem(xPathContext);
            return SingletonIterator.makeIterator(item);
        }
        throw new UnsupportedOperationException("Non-singleton expression " + this.getClass() + " must supply iterate() method");
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    protected void dynamicError(String string) throws XPathException.Dynamic {
        throw new XPathException.Dynamic(string, this.getSourceLocator());
    }

    protected void typeError(String string) throws XPathException.Type {
        throw new XPathException.Type(string, this.getSourceLocator());
    }

    public SourceLocator getSourceLocator() {
        return ExpressionTool.getLocator(this);
    }
}

