/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

class BooleanExpression
extends BinaryExpression {
    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public int computeCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        Expression expression = super.analyze(staticContext);
        if (expression instanceof BooleanExpression) {
            ((BooleanExpression)expression).operands[0] = ExpressionTool.unsorted(this.operands[0], false);
            ((BooleanExpression)expression).operands[1] = ExpressionTool.unsorted(this.operands[1], false);
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        switch (this.operator) {
            case 10: {
                return this.operands[0].effectiveBooleanValue(xPathContext) && this.operands[1].effectiveBooleanValue(xPathContext);
            }
            case 9: {
                return this.operands[0].effectiveBooleanValue(xPathContext) || this.operands[1].effectiveBooleanValue(xPathContext);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in boolean expression");
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }
}

