#!/usr/bin/env perl

# For issue184: recording files in directories that haven't explicity been added.

use lib 'lib/perl', '../tests/lib/perl';
use Test::More 'no_plan';
use Shell::Command;
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

init_tmp_repo();

mkdir 'new';
mkdir 'new/dir';
touch 'new/dir/t.t';
darcs "add new/dir/t.t";
my $out = darcs 'record -am "test" new/dir/t.t';

unlike($out, qr/don't want to record/, "avoid message which indicates there is nothing to record");
