%  Copyright (C) 2002-2004 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

\begin{code}
module Motd (show_motd) where
import Monad ( unless )
import DarcsFlags ( DarcsFlag( Quiet ) )
import External ( fetchFilePS, Cachable(..) )
import FastPackedString ( nullPS, nilPS, hPutPS )
import DarcsUtils ( catchall )
import System.IO ( stdout )
\end{code}

\paragraph{motd}\label{motd}
The \verb!_darcs/prefs/motd! file may contain a ``message of the day''
which will be displayed to users who get or pull from the repository without the
\verb!--quiet! option.

\begin{code}
show_motd :: [DarcsFlag] -> String -> IO ()
show_motd opts repo = do
  motd <- fetchFilePS (repo++"/_darcs/prefs/motd") (MaxAge 600)
           `catchall` return nilPS
  unless (nullPS motd || Quiet `elem` opts)
      $ do hPutPS stdout motd
           putStrLn "**********************"
\end{code}
