/*
 * restart.c
 *
 * $Id: restart.c,v 1.2.2.3 2001/11/06 13:20:16 asuffield Exp $
 */
/* Stupid gcc-2.95 doesn't understand %zi */
#define NO_PRINTF_CHECK
#include "restart.h"
#include "common.h"
#include "ircd.h"
#include "send.h"
#include "struct.h"
#include "s_debug.h"
#include "s_log.h"
#include "client.h"
#include "umodes.h"

#include <unistd.h>
#include <stdlib.h>

/* external var */
extern char** myargv;

void restart(const char *mesg)
{
  static int was_here = NO; /* redundant due to restarting flag below */

  if (was_here)
    abort();
  was_here = YES;

  log(L_NOTICE, "Restarting Server because: %s, memory data limit: %zi",
      mesg, get_maxrss());

  server_reboot();
}

void server_reboot(void)
{
  int i;
  
  sendto_ops_flag(UMODE_SERVNOTICE, "Aieeeee!!!  Restarting server... memory: %zi", get_maxrss());

  log(L_NOTICE, "Restarting server...");
  flush_connections(0);
#ifdef SAVE_MAXCLIENT
  write_stats();
#endif

  for (i = 0; i < MAXCONNECTIONS; ++i)
    close(i);
  execv(SPATH, myargv);

  exit(-1);
}


